/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowDock;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import org.jetbrains.annotations.NotNull;

public abstract class Window<W extends Workspace, V extends View<?>>
extends Fragment<W> {
    public Supplier<Integer> borderSize;
    public Supplier<Integer> titleSize = () -> this.borderSize.get() + 10;
    @NotNull
    public W parent;
    @NotNull
    private List<V> views = new ArrayList<V>();
    private V currentView = null;
    private boolean showTitle = true;
    private boolean canDrag = true;
    private boolean canDragResize = true;
    private boolean canBringToFront = true;
    private boolean canBeDocked = true;
    private boolean canBeUndocked = true;
    private boolean canDockStack = true;
    private boolean isUnique = true;
    public EdgeGrab edgeGrab;

    public Window(@NotNull W parent) {
        super(parent);
        this.parent = parent;
        this.borderSize = () -> (parent.isDocked(this) ? 1 : 0) + (this.renderMinecraftStyle() > 0 ? 4 : 3);
    }

    public <T extends Window<W, V>> T setBorderSize(Supplier<Integer> borderSize) {
        this.borderSize = borderSize;
        return (T)this;
    }

    public <T extends Window<W, V>> T pos(int x, int y) {
        return (T)((Window)this.setPos(x, y));
    }

    public <T extends Window<W, V>> T size(int width, int height) {
        return (T)((Window)this.setSize(width, height));
    }

    public V getCurrentView() {
        return this.currentView;
    }

    public <T extends Window<W, V>> T setView(V v) {
        this.views.add(v);
        this.setCurrentView(v);
        return (T)this;
    }

    public <T extends Window<W, V>> T setCurrentView(V v) {
        this.currentView = v;
        return (T)this;
    }

    public <T extends Window<W, V>> T disableTitle() {
        this.showTitle = false;
        return (T)this;
    }

    public <T extends Window<W, V>> T disableDrag() {
        this.canDrag = false;
        return (T)this;
    }

    public <T extends Window<W, V>> T disableDragResize() {
        this.canDragResize = false;
        return (T)this;
    }

    public <T extends Window<W, V>> T disableBringToFront() {
        this.canBringToFront = false;
        return (T)this;
    }

    public <T extends Window<W, V>> T disableDockingEntirely() {
        this.canBeDocked = false;
        this.canBeUndocked = false;
        this.canDockStack = false;
        return (T)this;
    }

    public <T extends Window<W, V>> T disableDocking() {
        this.canBeDocked = false;
        return (T)this;
    }

    public <T extends Window<W, V>> T disableUndocking() {
        this.canBeUndocked = false;
        return (T)this;
    }

    public <T extends Window<W, V>> T disableDockStacking() {
        this.canDockStack = false;
        return (T)this;
    }

    public <T extends Window<W, V>> T isNotUnique() {
        this.isUnique = false;
        return (T)this;
    }

    public boolean canShowTitle() {
        return this.showTitle;
    }

    public boolean hasTitle() {
        return this.canShowTitle() && !((View)this.currentView).title.isEmpty();
    }

    public boolean canDrag() {
        return this.canDrag;
    }

    public boolean canDragResize() {
        return this.canDragResize;
    }

    public boolean canBringToFront() {
        return this.canBringToFront;
    }

    public boolean canBeDocked() {
        return this.canBeDocked;
    }

    public boolean canBeUndocked() {
        return this.canBeUndocked;
    }

    public boolean canDockStack() {
        return this.canDockStack;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public List<V> children() {
        return this.currentView != null ? ImmutableList.of(this.currentView) : this.views;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            boolean isDocked;
            EdgeGrab grab;
            if (button == 0 && (this.canDrag() || this.canDragResize()) && (grab = new EdgeGrab((!(isDocked = ((Workspace)this.parent).isDocked(this)) && !this.constraint.hasLeft() || isDocked && (!this.constraint.hasLeft() || ((Workspace)this.parent).sameDockStack(this, this.constraint.get(Constraint.Property.Type.LEFT).getReference()))) && Window.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.borderSize.get()), (!isDocked && !this.constraint.hasRight() || isDocked && (!this.constraint.hasRight() || ((Workspace)this.parent).sameDockStack(this, this.constraint.get(Constraint.Property.Type.RIGHT).getReference()))) && Window.isMouseBetween(mouseX, this.getRight() - this.borderSize.get(), this.getRight()), (!isDocked && !this.constraint.hasTop() || isDocked && (!this.constraint.hasTop() || ((Workspace)this.parent).sameDockStack(this, this.constraint.get(Constraint.Property.Type.TOP).getReference()))) && Window.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.borderSize.get()), (!isDocked && !this.constraint.hasBottom() || isDocked && (!this.constraint.hasBottom() || ((Workspace)this.parent).sameDockStack(this, this.constraint.get(Constraint.Property.Type.BOTTOM).getReference()))) && Window.isMouseBetween(mouseY, this.getBottom() - this.borderSize.get(), this.getBottom()), (!isDocked || this.canBeUndocked()) && Window.isMouseBetween(mouseY, this.getTop() + this.borderSize.get(), this.getTop() + this.titleSize.get()) && this.hasTitle(), (int)mouseX, (int)mouseY)).isActive()) {
                this.edgeGrab = grab;
                this.setDragging(true);
            }
            if (this.edgeGrab == null) {
                super.mouseClicked(mouseX, mouseY, button);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.edgeGrab != null) {
            if (this.edgeGrab.titleGrab && this.canBeDocked() && !((Workspace)this.parent).isDocked(this)) {
                int oriX = this.posX;
                int oriY = this.posY;
                this.pos(-10000, -10000);
                WindowDock.DockInfo dockInfo = ((Workspace)this.parent).getDockInfo(mouseX, mouseY, this.canDockStack());
                this.pos(oriX, oriY);
                if (dockInfo != null) {
                    if (dockInfo.window() != null) {
                        ((Workspace)this.parent).addToDocked(dockInfo.window(), this);
                    } else {
                        ((Workspace)this.parent).addToDock(this, dockInfo.type());
                    }
                }
            }
            this.edgeGrab = null;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double distX, double distY) {
        if (this.edgeGrab != null) {
            if (this.edgeGrab.titleGrab) {
                if (this.canDrag()) {
                    if (((Workspace)this.parent).isDocked(this) && this.canBeUndocked()) {
                        int oriX = this.posX;
                        int oriY = this.posY;
                        int oriWidth = this.width;
                        ((Workspace)this.parent).removeFromDock(this);
                        this.posX += oriX - this.posX + (oriWidth - this.width) / 2;
                        this.posY += oriY - this.posY;
                    }
                    this.posX -= this.edgeGrab.x - (int)mouseX;
                    this.posY -= this.edgeGrab.y - (int)mouseY;
                    this.edgeGrab.x = (int)mouseX;
                    this.edgeGrab.y = (int)mouseY;
                }
            } else if (this.canDragResize()) {
                if (((Workspace)this.parent).isDocked(this)) {
                    this.dragResize(mouseX, mouseY, this.edgeGrab);
                    if (this.edgeGrab.left) {
                        ((Workspace)this.getWorkspace()).getDock().edgeGrab(this, mouseX, mouseY, new EdgeGrab(true, false, false, false, false, this.edgeGrab.x, this.edgeGrab.y));
                    }
                    if (this.edgeGrab.right) {
                        ((Workspace)this.getWorkspace()).getDock().edgeGrab(this, mouseX, mouseY, new EdgeGrab(false, true, false, false, false, this.edgeGrab.x, this.edgeGrab.y));
                    }
                    if (this.edgeGrab.top) {
                        ((Workspace)this.getWorkspace()).getDock().edgeGrab(this, mouseX, mouseY, new EdgeGrab(false, false, true, false, false, this.edgeGrab.x, this.edgeGrab.y));
                    }
                    if (this.edgeGrab.bottom) {
                        ((Workspace)this.getWorkspace()).getDock().edgeGrab(this, mouseX, mouseY, new EdgeGrab(false, false, false, true, false, this.edgeGrab.x, this.edgeGrab.y));
                    }
                } else {
                    this.dragResize(mouseX, mouseY, this.edgeGrab);
                }
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, distX, distY);
    }

    public void dragResize(double mouseX, double mouseY, EdgeGrab grab) {
        int left = this.getLeft();
        int right = this.getRight();
        int top = this.getTop();
        int bottom = this.getBottom();
        if (grab.left) {
            this.setLeft((int)mouseX);
            this.setRight(right);
        } else if (grab.right) {
            this.setRight((int)mouseX);
        }
        if (grab.top) {
            this.setTop((int)mouseY);
            this.setBottom(bottom);
        } else if (grab.bottom) {
            this.setBottom((int)mouseY);
        }
        if (this.width < 20) {
            this.width = 20;
            this.setLeft(left);
        }
        if (this.height < 20) {
            this.height = 20;
            this.setTop(top);
        }
        this.resize(Minecraft.getInstance(), ((Workspace)this.parent).getWidth(), ((Workspace)this.parent).getHeight());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return !((Workspace)this.parent).isObstructed(this, mouseX, mouseY) && Window.isMouseBetween(mouseX, this.getLeft(), this.getRight()) && Window.isMouseBetween(mouseY, this.getTop(), this.getBottom());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean isDocked;
        EdgeGrab grab;
        if (this.isMouseOver(mouseX, mouseY) && (this.canDrag() || this.canDragResize()) && (grab = new EdgeGrab((!(isDocked = ((Workspace)this.parent).isDocked(this)) && !this.constraint.hasLeft() || isDocked && (!this.constraint.hasLeft() || ((Workspace)this.parent).sameDockStack(this, this.constraint.get(Constraint.Property.Type.LEFT).getReference()))) && Window.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.borderSize.get()), (!isDocked && !this.constraint.hasRight() || isDocked && (!this.constraint.hasRight() || ((Workspace)this.parent).sameDockStack(this, this.constraint.get(Constraint.Property.Type.RIGHT).getReference()))) && Window.isMouseBetween(mouseX, this.getRight() - this.borderSize.get(), this.getRight()), (!isDocked && !this.constraint.hasTop() || isDocked && (!this.constraint.hasTop() || ((Workspace)this.parent).sameDockStack(this, this.constraint.get(Constraint.Property.Type.TOP).getReference()))) && Window.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.borderSize.get()), (!isDocked && !this.constraint.hasBottom() || isDocked && (!this.constraint.hasBottom() || ((Workspace)this.parent).sameDockStack(this, this.constraint.get(Constraint.Property.Type.BOTTOM).getReference()))) && Window.isMouseBetween(mouseY, this.getBottom() - this.borderSize.get(), this.getBottom()), (!isDocked || this.canBeUndocked()) && Window.isMouseBetween(mouseY, this.getTop() + this.borderSize.get(), this.getTop() + this.titleSize.get()) && this.hasTitle(), mouseX, mouseY)).isActive()) {
            ((Workspace)this.getWorkspace()).cursorState = grab.titleGrab ? Workspace.CURSOR_CROSSHAIR : (grab.left || grab.right ? Workspace.CURSOR_HRESIZE : Workspace.CURSOR_VRESIZE);
        }
        this.renderDockHighlight(graphics, mouseX, mouseY, partialTick);
        this.setScissor();
        this.renderBackground(graphics);
        if (this.hasTitle()) {
            this.drawString(graphics, ((View)this.currentView).title, this.getLeft() + this.borderSize.get() + 1, this.getTop() + this.borderSize.get());
        }
        ((View)this.currentView).render(graphics, mouseX, mouseY, partialTick);
        this.endScissor();
    }

    public void renderBackground(GuiGraphics graphics) {
        if (this.renderMinecraftStyle() > 0) {
            PoseStack stack = graphics.pose();
            VertexConsumer vertexConsumer = RenderHelper.startDrawBatch(this.resourceHorse());
            RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft() + 4, this.getTop() + 4, this.width - 8, this.height - 8, 0.0, 0.3203125, 0.6484375, 0.078125, 0.265625);
            RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft(), this.getTop() + 4, 4.0, this.height - 8, 0.0, 0.0, 0.015625, 0.015625, 0.6328125);
            RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft() + 4, this.getTop(), this.width - 8, 4.0, 0.0, 0.015625, 0.671875, 0.0, 0.015625);
            RenderHelper.drawBatch(stack, vertexConsumer, this.getRight() - 4, this.getTop() + 4, 4.0, this.height - 8, 0.0, 0.671875, 0.6875, 0.015625, 0.6328125);
            RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft() + 4, this.getBottom() - 4, this.width - 8, 4.0, 0.0, 0.015625, 0.671875, 0.6328125, 0.6484375);
            RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft(), this.getTop(), 4.0, 4.0, 0.0, 0.0, 0.015625, 0.0, 0.015625);
            RenderHelper.drawBatch(stack, vertexConsumer, this.getRight() - 4, this.getTop(), 4.0, 4.0, 0.0, 0.671875, 0.6875, 0.0, 0.015625);
            RenderHelper.drawBatch(stack, vertexConsumer, this.getLeft(), this.getBottom() - 4, 4.0, 4.0, 0.0, 0.0, 0.015625, 0.6328125, 0.6484375);
            RenderHelper.drawBatch(stack, vertexConsumer, this.getRight() - 4, this.getBottom() - 4, 4.0, 4.0, 0.0, 0.671875, 0.6875, 0.6328125, 0.6484375);
            RenderHelper.endDrawBatch();
        } else {
            this.fill(graphics, this.parent.getFocused() == this ? this.getTheme().windowBorderActive : this.getTheme().windowBorderInactive, 0);
        }
    }

    public void renderDockHighlight(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (((Workspace)this.getWorkspace()).canDockWindows() && this.getWorkspace().getFocused() == this && this.getWorkspace().isDragging() && (this.canBeDocked() || this.canDockStack()) && this.edgeGrab != null && this.edgeGrab.titleGrab) {
            boolean draw;
            WindowDock<? extends Workspace> dock = ((Workspace)this.getWorkspace()).getDock();
            double left = 0.0;
            double top = 0.0;
            double right = ((Workspace)this.getWorkspace()).getWidth();
            double bottom = ((Workspace)this.getWorkspace()).getHeight();
            for (Map.Entry<WindowDock.ArrayListHolder, Constraint.Property.Type> e : dock.docked.entrySet()) {
                for (Window<?, ?> key : e.getKey().windows()) {
                    Constraint.Property.Type value = e.getValue();
                    switch (value) {
                        case LEFT: {
                            if (!((double)key.getRight() > left)) break;
                            left = key.getRight();
                            break;
                        }
                        case TOP: {
                            if (!((double)key.getBottom() > top)) break;
                            top = key.getBottom();
                            break;
                        }
                        case RIGHT: {
                            if (!((double)key.getLeft() < right)) break;
                            right = key.getLeft();
                            break;
                        }
                        case BOTTOM: {
                            if (!((double)key.getTop() < bottom)) break;
                            bottom = key.getTop();
                        }
                    }
                }
            }
            Window window = this;
            int oriX = window.posX;
            int oriY = window.posY;
            window.pos(-10000, -10000);
            WindowDock.DockInfo info = dock.getDockInfo(mouseX, mouseY, window.canDockStack());
            window.pos(oriX, oriY);
            boolean bl = draw = info != null && info.window() != null;
            if (draw) {
                left = info.window().getLeft();
                right = info.window().getRight();
                top = info.window().getTop();
                bottom = info.window().getBottom();
            } else if (this.canBeDocked() && !((Workspace)this.getWorkspace()).isDocked(this)) {
                HashSet<Constraint.Property.Type> disabledDocks = ((Workspace)this.getWorkspace()).getDock().disabledDocks;
                int dockSnap = iChunUtil.configClient.bnsDockBorder;
                if ((double)mouseY >= top && (double)mouseY < bottom) {
                    if ((double)mouseX >= left && (double)mouseX < left + (double)dockSnap && !disabledDocks.contains((Object)Constraint.Property.Type.LEFT)) {
                        right = left + (double)dockSnap;
                        draw = true;
                    } else if ((double)mouseX >= right - (double)dockSnap && (double)mouseX < right && !disabledDocks.contains((Object)Constraint.Property.Type.RIGHT)) {
                        left = right - (double)dockSnap;
                        draw = true;
                    }
                }
                if ((double)mouseX >= left && (double)mouseX < right) {
                    if ((double)mouseY >= top && (double)mouseY < top + (double)dockSnap && !disabledDocks.contains((Object)Constraint.Property.Type.TOP)) {
                        bottom = top + (double)dockSnap;
                        draw = true;
                    } else if ((double)mouseY >= bottom - (double)dockSnap && bottom < right && !disabledDocks.contains((Object)Constraint.Property.Type.BOTTOM)) {
                        top = bottom - (double)dockSnap;
                        draw = true;
                    }
                }
            }
            if (draw) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                if (this.renderMinecraftStyle() <= 0) {
                    RenderHelper.drawColour(graphics, this.getTheme().elementTabBorderActive, 150, left, top, right - left, bottom - top, 0.0);
                }
                RenderSystem.disableBlend();
            }
        }
    }

    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (this.parent.getFocused() == this) {
            return super.nextFocusPath(event);
        }
        return null;
    }

    @Override
    public boolean requireScissor() {
        return true;
    }

    @Override
    public void resetScissorToParent() {
        this.endScissor();
    }

    @Override
    public W getWorkspace() {
        return super.getWorkspace();
    }

    public static class EdgeGrab {
        boolean left;
        boolean right;
        boolean top;
        boolean bottom;
        boolean titleGrab;
        int x;
        int y;

        public EdgeGrab(boolean left, boolean right, boolean top, boolean bottom, boolean titleGrab, int x, int y) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            this.titleGrab = titleGrab;
            this.x = x;
            this.y = y;
        }

        public boolean isActive() {
            return this.left || this.right || this.top || this.bottom || this.titleGrab;
        }
    }
}

