/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButtonAbstract;
import net.minecraft.client.gui.GuiGraphics;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementButtonRotatable
extends ElementButtonAbstract<ElementButtonRotatable> {
    public int rotationCount;

    public ElementButtonRotatable(@NotNull Fragment<?> parent, @NotNull String s, int rotCount, TriConsumer<ElementButtonRotatable, Double, Double> callback, @Nullable TriConsumer<ElementButtonRotatable, Double, Double> rightMouseCallback) {
        super(parent, s, callback, rightMouseCallback);
        this.rotationCount = rotCount;
    }

    public ElementButtonRotatable(@NotNull Fragment<?> parent, @NotNull String s, int rotCount, TriConsumer<ElementButtonRotatable, Double, Double> callback) {
        this(parent, s, rotCount, callback, null);
    }

    @Override
    public ElementButtonRotatable setSize(int width, int height) {
        if (this.rotationCount % 2 != 0) {
            return (ElementButtonRotatable)super.setSize(height, width);
        }
        return (ElementButtonRotatable)super.setSize(width, height);
    }

    @Override
    public void renderText(GuiGraphics graphics) {
        if (!this.text.isEmpty()) {
            String s = this.reString(this.text, (this.rotationCount % 2 != 0 ? this.height : this.width) - 4);
            PoseStack stack = graphics.pose();
            stack.pushPose();
            stack.translate((float)this.getLeft() + (float)this.width / 2.0f, (float)this.getTop() + (float)this.height / 2.0f, 0.0f);
            stack.mulPose(Axis.ZP.rotationDegrees(90.0f * (float)this.rotationCount));
            float f = (float)(-this.getFontRenderer().width(s)) / 2.0f;
            Objects.requireNonNull(this.getFontRenderer());
            stack.translate(f, (float)(-9) / 2.0f + 1.0f, 0.0f);
            this.drawString(graphics, s, 0.0f, 0.0f);
            stack.popPose();
        }
    }

    @Override
    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        String s;
        if (!this.text.isEmpty() && !(s = this.reString(this.text, (this.rotationCount % 2 != 0 ? this.height : this.width) - 4)).equals(this.text)) {
            if (this.tooltip != null) {
                return this.text + " - " + this.tooltip;
            }
            return this.text;
        }
        return this.tooltip;
    }
}

