/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementClickable<T extends ElementClickable<T>>
extends Element<Fragment<?>> {
    @NotNull
    public TriConsumer<T, Double, Double> callback;
    @Nullable
    public TriConsumer<T, Double, Double> rightClickCallback;
    public boolean hover;
    public boolean disabled;

    public ElementClickable(@NotNull Fragment<?> parent, @NotNull TriConsumer<T, Double, Double> callback, @Nullable TriConsumer<T, Double, Double> rightClickCallback) {
        super(parent);
        this.callback = callback;
        this.rightClickCallback = rightClickCallback;
    }

    public ElementClickable(@NotNull Fragment<?> parent, @NotNull TriConsumer<T, Double, Double> callback) {
        this(parent, callback, null);
    }

    public T setDisabled(boolean flag) {
        this.disabled = flag;
        return (T)this;
    }

    public T setRightClickCallback(TriConsumer<T, Double, Double> rightClickCallback) {
        this.rightClickCallback = rightClickCallback;
        return (T)this;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.hover = false;
        if (!this.disabled) {
            this.hover = this.isMouseOver(mouseX, mouseY) || ((Fragment)this.parent).getFocused() == this;
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean flag = super.mouseReleased(mouseX, mouseY, button);
        ((Fragment)this.parent).setFocused(null);
        if (!this.disabled && this.isMouseOver(mouseX, mouseY)) {
            if (button == 0) {
                this.trigger(mouseX, mouseY);
            } else if (this.rightClickCallback != null && button == 1) {
                this.triggerRMB(mouseX, mouseY);
            }
        }
        return flag;
    }

    public void trigger(double mouseX, double mouseY) {
        if (this.renderMinecraftStyle() > 0) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        this.onClickRelease();
        this.callback.accept((Object)this, (Object)mouseX, (Object)mouseY);
    }

    public void triggerRMB(double mouseX, double mouseY) {
        if (this.renderMinecraftStyle() > 0) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        this.onRightClickRelease();
        this.rightClickCallback.accept((Object)this, (Object)mouseX, (Object)mouseY);
    }

    public abstract void onClickRelease();

    public void onRightClickRelease() {
    }

    public boolean keyPressed(int key, int scancode, int listener) {
        if (!(this.disabled || key != 32 && key != 257 && key != 335)) {
            if (Screen.hasControlDown()) {
                this.triggerRMB(this.getCenterX(), this.getCenterY());
            } else {
                this.trigger(this.getCenterX(), this.getCenterY());
            }
            return true;
        }
        return false;
    }

    @Override
    public int getMinecraftFontColour() {
        return ((Fragment)this.parent).isDragging() && ((Fragment)this.parent).getFocused() == this || this.disabled ? 0xA0A0A0 : (this.hover ? 0xFFFFA0 : 0xE0E0E0);
    }
}

