/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.List;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import org.jetbrains.annotations.NotNull;

public abstract class ElementFertile<P extends Fragment<?>>
extends Element<P> {
    public ElementFertile(@NotNull P parent) {
        super(parent);
    }

    @Override
    public abstract List<? extends Fragment<?>> children();

    @Override
    public void init() {
        super.init();
        this.children().forEach(Fragment::init);
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.children().forEach(child -> child.resize(mc, this.width, this.height));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            boolean hasElement = this.defaultMouseClicked(mouseX, mouseY, button);
            if (!hasElement && this.getFocused() instanceof Fragment) {
                this.setFocused(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return null;
    }

    public abstract int getBorderSize();

    @Override
    public int getMinWidth() {
        int min = 0;
        for (Fragment<?> fragment : this.children()) {
            int fragWidth = this.getConstraintSensitiveMinWidth(fragment);
            if (fragWidth <= min) continue;
            min = fragWidth;
        }
        return min > 0 ? min + this.getBorderSize() * 2 : 4;
    }

    @Override
    public int getMinHeight() {
        int min = 0;
        for (Fragment<?> fragment : this.children()) {
            int fragHeight = this.getConstraintSensitiveMinHeight(fragment);
            if (fragHeight <= min) continue;
            min = fragHeight;
        }
        return min > 0 ? min + this.getBorderSize() * 2 : 4;
    }

    public int getConstraintSensitiveMinWidth(Fragment<?> child) {
        Constraint.Property right;
        int ourWidth = child.getMinWidth();
        ourWidth += child.constraint.get(Constraint.Property.Type.LEFT).getDist();
        ourWidth += child.constraint.get(Constraint.Property.Type.RIGHT).getDist();
        Constraint.Property left = child.constraint.get(Constraint.Property.Type.LEFT);
        if (left != Constraint.Property.NONE && left.getReference() != this && left.getReference() instanceof Fragment) {
            ourWidth += this.getConstraintSensitiveMinWidth((Fragment)left.getReference());
        }
        if ((right = child.constraint.get(Constraint.Property.Type.RIGHT)) != Constraint.Property.NONE && right.getReference() != this && right.getReference() instanceof Fragment) {
            ourWidth += this.getConstraintSensitiveMinWidth((Fragment)right.getReference());
        }
        return ourWidth;
    }

    public int getConstraintSensitiveMinHeight(Fragment<?> child) {
        Constraint.Property bottom;
        int ourHeight = child.getMinHeight();
        ourHeight += child.constraint.get(Constraint.Property.Type.TOP).getDist();
        ourHeight += child.constraint.get(Constraint.Property.Type.BOTTOM).getDist();
        Constraint.Property top = child.constraint.get(Constraint.Property.Type.TOP);
        if (top != Constraint.Property.NONE && top.getReference() != this && top.getReference() instanceof Fragment) {
            ourHeight += this.getConstraintSensitiveMinHeight((Fragment)top.getReference());
        }
        if ((bottom = child.constraint.get(Constraint.Property.Type.BOTTOM)) != Constraint.Property.NONE && bottom.getReference() != this && bottom.getReference() instanceof Fragment) {
            ourHeight += this.getConstraintSensitiveMinHeight((Fragment)bottom.getReference());
        }
        return ourHeight;
    }
}

