/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.batchedentityrendering.mixin;

import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.irisshaders.batchedentityrendering.impl.DrawCallTrackingRenderBuffers;
import net.irisshaders.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.irisshaders.batchedentityrendering.impl.Groupable;
import net.irisshaders.batchedentityrendering.impl.RenderBuffersExt;
import net.irisshaders.batchedentityrendering.impl.TransparencyType;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=999)
public class MixinLevelRenderer {
    @Unique
    private static final String RENDER_ENTITY = "Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V";
    @Shadow
    private RenderBuffers renderBuffers;
    @Unique
    private Groupable groupable;

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void batchedentityrendering$beginLevelRender(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        if (this.renderBuffers instanceof DrawCallTrackingRenderBuffers) {
            ((DrawCallTrackingRenderBuffers)this.renderBuffers).resetDrawCounts();
        }
        ((RenderBuffersExt)this.renderBuffers).beginLevelRendering();
        MultiBufferSource.BufferSource provider = this.renderBuffers.bufferSource();
        if (provider instanceof Groupable) {
            this.groupable = (Groupable)provider;
        }
    }

    @Inject(method={"renderEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V")})
    private void batchedentityrendering$preRenderEntity(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, Camera camera, DeltaTracker deltaTracker, List<Entity> list, CallbackInfo ci) {
        if (this.groupable != null) {
            this.groupable.startGroup();
        }
    }

    @Inject(method={"renderEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V", shift=At.Shift.AFTER)})
    private void batchedentityrendering$postRenderEntity(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, Camera camera, DeltaTracker deltaTracker, List<Entity> list, CallbackInfo ci) {
        if (this.groupable != null) {
            this.groupable.endGroup();
        }
    }

    @Inject(method={"method_62214", "lambda$addMainPass$2"}, require=1, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;waterMask()Lnet/minecraft/client/renderer/RenderType;")})
    private void batchedentityrendering$beginTranslucents(CallbackInfo ci) {
        MultiBufferSource.BufferSource bufferSource = this.renderBuffers.bufferSource();
        if (bufferSource instanceof FullyBufferedMultiBufferSource) {
            FullyBufferedMultiBufferSource fullyBufferedMultiBufferSource = (FullyBufferedMultiBufferSource)bufferSource;
            fullyBufferedMultiBufferSource.readyUp();
        }
        if (WorldRenderingSettings.INSTANCE.shouldSeparateEntityDraws()) {
            Profiler.get().popPush("entity_draws_opaque");
            bufferSource = this.renderBuffers.bufferSource();
            if (bufferSource instanceof FullyBufferedMultiBufferSource) {
                FullyBufferedMultiBufferSource source = (FullyBufferedMultiBufferSource)bufferSource;
                source.endBatchWithType(TransparencyType.OPAQUE);
                source.endBatchWithType(TransparencyType.OPAQUE_DECAL);
                source.endBatchWithType(TransparencyType.WATER_MASK);
            } else {
                this.renderBuffers.bufferSource().endBatch();
            }
        } else {
            Profiler.get().popPush("entity_draws");
            this.renderBuffers.bufferSource().endBatch();
        }
    }

    @Inject(method={"method_62214", "lambda$addMainPass$2"}, require=1, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", ordinal=3)})
    private void batchedentityrendering$endTranslucents(CallbackInfo ci) {
        if (WorldRenderingSettings.INSTANCE.shouldSeparateEntityDraws()) {
            this.renderBuffers.bufferSource().endBatch();
        }
    }

    @Inject(method={"method_62214", "lambda$addMainPass$2"}, require=1, at={@At(value="RETURN")})
    private void batchedentityrendering$endLevelRender(CallbackInfo ci) {
        ((RenderBuffersExt)this.renderBuffers).endLevelRendering();
        this.groupable = null;
    }
}

