/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin;

import com.google.common.collect.ImmutableSet;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.blending.DepthColorStorage;
import net.irisshaders.iris.pipeline.ShaderRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ExtendedShader;
import net.irisshaders.iris.pipeline.programs.FallbackShader;
import net.minecraft.client.renderer.CompiledShaderProgram;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CompiledShaderProgram.class})
public abstract class MixinCompiledShaderProgram {
    @Unique
    private static final ImmutableSet<String> ATTRIBUTE_LIST = ImmutableSet.of((Object)"Position", (Object)"Color", (Object)"Normal", (Object)"UV0", (Object)"UV1", (Object)"UV2", (Object[])new String[0]);
    @Unique
    private static CompiledShaderProgram lastAppliedShader;

    @Unique
    private static boolean shouldOverrideShaders() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof ShaderRenderingPipeline) {
            return ((ShaderRenderingPipeline)pipeline).shouldOverrideShaders();
        }
        return false;
    }

    @Inject(method={"apply"}, at={@At(value="HEAD")})
    private void iris$lockDepthColorState(CallbackInfo ci) {
        if (lastAppliedShader != null) {
            lastAppliedShader.clear();
            lastAppliedShader = null;
        }
    }

    @Inject(method={"apply"}, at={@At(value="TAIL")})
    private void onTail(CallbackInfo ci) {
        lastAppliedShader = (CompiledShaderProgram)this;
        if (this instanceof ExtendedShader || this instanceof FallbackShader || !MixinCompiledShaderProgram.shouldOverrideShaders()) {
            DepthColorStorage.unlockDepthColor();
            return;
        }
        DepthColorStorage.disableDepthColor();
    }

    @Inject(method={"clear"}, at={@At(value="HEAD")})
    private void iris$unlockDepthColorState(CallbackInfo ci) {
        lastAppliedShader = null;
        if (this instanceof ExtendedShader || this instanceof FallbackShader || !MixinCompiledShaderProgram.shouldOverrideShaders()) {
            return;
        }
        DepthColorStorage.unlockDepthColor();
    }
}

