/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import com.mojang.blaze3d.systems.RenderSystem;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.compat.dh.DHCompat;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.layer.IsOutlineRenderStateShard;
import net.irisshaders.iris.layer.OuterWrappedRenderType;
import net.irisshaders.iris.mixin.LevelRendererAccessor;
import net.irisshaders.iris.pathways.HandRenderer;
import net.irisshaders.iris.pipeline.WorldRenderingPhase;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shadows.frustum.fallback.NonCullingFrustum;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.IrisTimeUniforms;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.Profiler;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    private static final String CLEAR = "Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V";
    private static final String RENDER_SKY = "Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V";
    private static final String RENDER_CLOUDS = "Lnet/minecraft/client/renderer/LevelRenderer;renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;FDDD)V";
    private static final String RENDER_WEATHER = "Lnet/minecraft/client/renderer/LevelRenderer;renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V";
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private WorldRenderingPipeline pipeline;
    @Shadow
    private RenderBuffers renderBuffers;
    @Shadow
    private int ticks;
    @Shadow
    private Frustum cullingFrustum;
    @Shadow
    @Final
    private LevelTargetBundle targets;
    private boolean warned;

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void iris$setupPipeline(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, Matrix4f modelView, Matrix4f projection, CallbackInfo ci) {
        DHCompat.checkFrame();
        IrisTimeUniforms.updateTime();
        CapturedRenderingState.INSTANCE.setGbufferModelView((Matrix4fc)modelView);
        CapturedRenderingState.INSTANCE.setGbufferProjection(projection);
        float fakeTickDelta = deltaTracker.getGameTimeDeltaPartialTick(false);
        CapturedRenderingState.INSTANCE.setTickDelta(fakeTickDelta);
        CapturedRenderingState.INSTANCE.setCloudTime(((float)this.ticks + fakeTickDelta) * 0.03f);
        this.pipeline = Iris.getPipelineManager().preparePipeline(Iris.getCurrentDimension());
        if (this.pipeline.shouldDisableFrustumCulling()) {
            this.cullingFrustum = new NonCullingFrustum();
            this.cullingFrustum.prepare(camera.getPosition().x(), camera.getPosition().y(), camera.getPosition().z());
        }
        this.pipeline.beginLevelRendering();
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
        IrisRenderSystem.backupAndDisableCullingState(this.pipeline.shouldDisableOcclusionCulling());
        if (Iris.shouldActivateWireframe() && this.minecraft.isLocalServer()) {
            IrisRenderSystem.setPolygonMode(6913);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/framegraph/FramePass;executes(Ljava/lang/Runnable;)V", ordinal=0, shift=At.Shift.AFTER)})
    private void iris$beginLevelRender(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci, @Local FrameGraphBuilder frameGraphBuilder, @Local(ordinal=1) FogParameters fogParameters, @Local(ordinal=0) FramePass clearPass) {
        FramePass framePass = frameGraphBuilder.addPass("iris_setup");
        this.targets.main = framePass.readsAndWrites(this.targets.main);
        framePass.requires(clearPass);
        framePass.executes(() -> {
            FogParameters params = RenderSystem.getShaderFog();
            RenderSystem.setShaderFog((FogParameters)fogParameters);
            this.pipeline.onBeginClear();
            RenderSystem.setShaderFog((FogParameters)params);
        });
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFog(Lnet/minecraft/client/renderer/FogParameters;)V")})
    private void iris$endLevelRender(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, Matrix4f modelMatrix, Matrix4f matrix4f2, CallbackInfo ci) {
        HandRenderer.INSTANCE.renderTranslucent((Matrix4fc)modelMatrix, deltaTracker.getGameTimeDeltaPartialTick(true), camera, gameRenderer, this.pipeline);
        Profiler.get().popPush("iris_final");
        this.pipeline.finalizeLevelRendering();
        this.pipeline = null;
        if (!this.warned) {
            this.warned = true;
            Iris.getUpdateChecker().getBetaInfo().ifPresent(info -> Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)("A new beta is out for Iris " + info.betaTag + ". Please redownload it.")).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED})));
        }
        IrisRenderSystem.restoreCullingState();
        if (Iris.shouldActivateWireframe() && this.minecraft.isLocalServer()) {
            IrisRenderSystem.setPolygonMode(6914);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;collectVisibleEntities(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/culling/Frustum;Ljava/util/List;)Z", shift=At.Shift.AFTER)})
    private void iris$renderTerrainShadows(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, GameRenderer gameRenderer, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        this.pipeline.renderShadows((LevelRendererAccessor)((Object)this), camera);
    }

    private boolean iris$alwaysRenderSky(boolean value) {
        return false;
    }

    @Inject(method={"method_62215", "lambda$addSkyPass$12"}, require=1, at={@At(value="HEAD")})
    private void iris$beginSky(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.CUSTOM_SKY);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION);
    }

    @Inject(method={"method_62215", "lambda$addSkyPass$12"}, require=1, at={@At(value="RETURN")})
    private void iris$endSky(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"method_62205", "lambda$addCloudsPass$6"}, require=1, at={@At(value="HEAD")})
    private void iris$beginClouds(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.CLOUDS);
    }

    @Inject(method={"method_62205", "lambda$addCloudsPass$6"}, require=1, at={@At(value="RETURN")})
    private void iris$endClouds(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"renderSectionLayer"}, at={@At(value="HEAD")})
    private void iris$beginTerrainLayer(RenderType renderType, double d, double e, double f, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.fromTerrainRenderType(renderType));
    }

    @Inject(method={"renderSectionLayer"}, at={@At(value="RETURN")})
    private void iris$endTerrainLayer(RenderType renderType, double d, double e, double f, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"method_62216", "lambda$addWeatherPass$7"}, require=1, at={@At(value="HEAD")})
    private void iris$beginWeather(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.RAIN_SNOW);
    }

    @Inject(method={"method_62216", "lambda$addWeatherPass$7"}, require=1, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/WorldBorderRenderer;render(Lnet/minecraft/world/level/border/WorldBorder;Lnet/minecraft/world/phys/Vec3;DD)V")})
    private void iris$beginWorldBorder(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.WORLD_BORDER);
    }

    @Inject(method={"method_62216", "lambda$addWeatherPass$7"}, require=1, at={@At(value="RETURN")})
    private void iris$endWeather(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @Inject(method={"method_62214", "lambda$addMainPass$2"}, require=1, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/debug/DebugRenderer;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;DDD)V")})
    private void iris$setDebugRenderStage(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.DEBUG);
    }

    @Inject(method={"method_62214", "lambda$addMainPass$2"}, require=1, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/debug/DebugRenderer;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/culling/Frustum;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;DDD)V", shift=At.Shift.AFTER)})
    private void iris$resetDebugRenderStage(CallbackInfo ci) {
        this.pipeline.setPhase(WorldRenderingPhase.NONE);
    }

    @ModifyArg(method={"renderBlockOutline"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;"))
    private RenderType iris$beginBlockOutline(RenderType type) {
        return new OuterWrappedRenderType("iris:is_outline", type, IsOutlineRenderStateShard.INSTANCE);
    }

    @Inject(method={"method_62214", "lambda$addMainPass$2"}, require=1, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V", ordinal=1)})
    private void iris$beginTranslucents(CallbackInfo ci, @Local(argsOnly=true) DeltaTracker deltaTracker, @Local(ordinal=0, argsOnly=true) Matrix4f modelMatrix, @Local(argsOnly=true) Camera camera) {
        this.pipeline.beginHand();
        HandRenderer.INSTANCE.renderSolid((Matrix4fc)modelMatrix, deltaTracker.getGameTimeDeltaPartialTick(true), camera, Minecraft.getInstance().gameRenderer, this.pipeline);
        Profiler.get().popPush("iris_pre_translucent");
        this.pipeline.beginTranslucents();
    }
}

