/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin;

import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.compat.sodium.mixin.CloudRendererAccessor;
import net.irisshaders.iris.pathways.HandRenderer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderAccess;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.pipeline.programs.ShaderOverrides;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.ShaderProgram;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShaderManager.class})
public abstract class MixinShaderManager_Overrides {
    private static final Function<IrisRenderingPipeline, ShaderKey> FAKE_FUNCTION = p -> null;
    @Unique
    private static final Map<ShaderProgram, Function<IrisRenderingPipeline, ShaderKey>> coreShaderMap = new Object2ObjectArrayMap();
    private static final Map<ShaderProgram, Function<IrisRenderingPipeline, ShaderKey>> coreShaderMapShadow = new Object2ObjectArrayMap();
    private Set<ShaderProgram> missingShaders = new HashSet<ShaderProgram>();

    @Shadow
    @Nullable
    public abstract CompiledShaderProgram getProgram(ShaderProgram var1);

    private static ShaderKey getCutout(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY_DIFFUSE;
        }
        return ShaderKey.ENTITIES_CUTOUT_DIFFUSE;
    }

    private static ShaderKey getSolid(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT : ShaderKey.HAND_TRANSLUCENT;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY;
        }
        return ShaderKey.ENTITIES_SOLID;
    }

    private static ShaderKey getTranslucent(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY;
        }
        return ShaderKey.ENTITIES_TRANSLUCENT;
    }

    @Inject(method={"getProgram"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectIrisProgram(ShaderProgram shaderProgram, CallbackInfoReturnable<CompiledShaderProgram> cir) {
        IrisRenderingPipeline irisPipeline;
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof IrisRenderingPipeline && (irisPipeline = (IrisRenderingPipeline)pipeline).shouldOverrideShaders()) {
            ShaderProgram newProgram = shaderProgram;
            if (newProgram == ShaderAccess.MEKANISM_FLAME) {
                CompiledShaderProgram result = irisPipeline.getShaderMap().getShader(ShadowRenderingState.areShadowsCurrentlyBeingRendered() ? ShaderKey.MEKANISM_FLAME_SHADOW : ShaderKey.MEKANISM_FLAME);
                if (result != null) {
                    cir.setReturnValue((Object)result);
                }
            } else if (shaderProgram == ShaderAccess.MEKASUIT) {
                newProgram = CoreShaders.RENDERTYPE_ENTITY_CUTOUT;
            }
            CompiledShaderProgram program = MixinShaderManager_Overrides.override(irisPipeline, newProgram);
            if (program != null) {
                cir.setReturnValue((Object)program);
            } else if (this.missingShaders.add(shaderProgram)) {
                Iris.logger.error("Missing program " + String.valueOf(shaderProgram.configId()) + " in override list. This is not a critical problem, but it could lead to weird rendering.", new Throwable());
            }
        } else if (shaderProgram == ShaderAccess.MEKANISM_FLAME) {
            cir.setReturnValue((Object)this.getProgram(CoreShaders.POSITION_TEX_COLOR));
        } else if (shaderProgram == ShaderAccess.MEKASUIT) {
            cir.setReturnValue((Object)this.getProgram(CoreShaders.RENDERTYPE_ENTITY_CUTOUT));
        } else if (shaderProgram != ShaderAccess.IE_COMPAT) {
            if (shaderProgram == ShaderAccess.TRANSLUCENT_PARTICLE_SHADER) {
                cir.setReturnValue((Object)this.getProgram(CoreShaders.PARTICLE));
            } else if (shaderProgram == ShaderAccess.WEATHER_SHADER) {
                cir.setReturnValue((Object)this.getProgram(CoreShaders.PARTICLE));
            }
        }
    }

    private static CompiledShaderProgram override(IrisRenderingPipeline pipeline, ShaderProgram shaderProgram) {
        ShaderKey shaderKey = MixinShaderManager_Overrides.convertToShaderKey(pipeline, shaderProgram);
        return shaderKey == null ? null : pipeline.getShaderMap().getShader(shaderKey);
    }

    private static ShaderKey convertToShaderKey(IrisRenderingPipeline pipeline, ShaderProgram shaderProgram) {
        return ShadowRenderingState.areShadowsCurrentlyBeingRendered() ? (ShaderKey)((Object)coreShaderMapShadow.getOrDefault(shaderProgram, FAKE_FUNCTION).apply((Object)pipeline)) : (ShaderKey)((Object)coreShaderMap.getOrDefault(shaderProgram, FAKE_FUNCTION).apply((Object)pipeline));
    }

    static {
        coreShaderMap.put(CoreShaders.POSITION, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.getSkyShader((IrisRenderingPipeline)p)));
        coreShaderMap.put(CoreShaders.POSITION_TEX, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.getSkyTexShader((IrisRenderingPipeline)p)));
        coreShaderMap.put(CoreShaders.POSITION_TEX_COLOR, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.getSkyTexColorShader((IrisRenderingPipeline)p)));
        coreShaderMap.put(CoreShaders.POSITION_COLOR, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.getSkyColorShader((IrisRenderingPipeline)p)));
        coreShaderMap.put(CoreShaders.PARTICLE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.PARTICLES));
        coreShaderMap.put(ShaderAccess.TRANSLUCENT_PARTICLE_SHADER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.PARTICLES_TRANS));
        coreShaderMap.put(ShaderAccess.WEATHER_SHADER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.WEATHER));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_SOLID, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getSolid(p)));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ARMOR_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ARMOR_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getTranslucent(p)));
        coreShaderMap.put(CoreShaders.RENDERTYPE_GLINT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_GLINT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_GLINT_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ARMOR_ENTITY_GLINT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_CUTOUT_NO_CULL_Z_OFFSET, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_SHADOW, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_SMOOTH_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> MixinShaderManager_Overrides.getCutout(p)));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getTranslucent));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_EYES_TRANS));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_ALPHA, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_ALPHA));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_DECAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_CUTOUT_DIFFUSE));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ITEM_ENTITY_TRANSLUCENT_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getTranslucent));
        coreShaderMap.put(CoreShaders.RENDERTYPE_SOLID, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.MOVING_BLOCK : ShaderKey.TERRAIN_SOLID));
        coreShaderMap.put(CoreShaders.RENDERTYPE_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.MOVING_BLOCK : ShaderKey.TERRAIN_CUTOUT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_CUTOUT_MIPPED, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.MOVING_BLOCK : ShaderKey.TERRAIN_CUTOUT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.MOVING_BLOCK : ShaderKey.TERRAIN_TRANSLUCENT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TRIPWIRE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_TRANSLUCENT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_LINES, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LINES));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TEXT_BACKGROUND, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXT_BG));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TEXT_BACKGROUND_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXT_BG));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TEXT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.TEXT_BE : ShaderKey.TEXT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TEXT_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.TEXT_BE : ShaderKey.TEXT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TEXT_INTENSITY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.TEXT_INTENSITY_BE : ShaderKey.TEXT_INTENSITY));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TEXT_INTENSITY_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.TEXT_INTENSITY_BE : ShaderKey.TEXT_INTENSITY));
        coreShaderMap.put(CoreShaders.RENDERTYPE_EYES, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_EYES));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENTITY_NO_OUTLINE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getTranslucent));
        coreShaderMap.put(CoreShaders.RENDERTYPE_BREEZE_WIND, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getTranslucent));
        coreShaderMap.put(CoreShaders.RENDERTYPE_ENERGY_SWIRL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_CUTOUT));
        coreShaderMap.put(CoreShaders.RENDERTYPE_BEACON_BEAM, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BEACON));
        coreShaderMap.put(CoreShaders.RENDERTYPE_LIGHTNING, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LIGHTNING));
        coreShaderMap.put(CoreShaders.RENDERTYPE_END_PORTAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getCutout));
        coreShaderMap.put(CoreShaders.RENDERTYPE_END_GATEWAY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)MixinShaderManager_Overrides::getCutout));
        coreShaderMap.put(CoreShaders.RENDERTYPE_LEASH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LEASH));
        coreShaderMap.put(CoreShaders.RENDERTYPE_WATER_MASK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_SOLID));
        coreShaderMap.put(CoreShaders.RENDERTYPE_CLOUDS, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS));
        coreShaderMap.put(CoreShaders.RENDERTYPE_CRUMBLING, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CRUMBLING));
        coreShaderMap.put(CloudRendererAccessor.getCLOUDS_SHADER(), (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS_SODIUM));
        coreShaderMap.put(CoreShaders.RENDERTYPE_TRANSLUCENT_MOVING_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.MOVING_BLOCK));
        coreShaderMapShadow.put(CoreShaders.POSITION, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BASIC));
        coreShaderMapShadow.put(CoreShaders.POSITION_TEX, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEX));
        coreShaderMapShadow.put(CoreShaders.POSITION_TEX_COLOR, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEX_COLOR));
        coreShaderMapShadow.put(CoreShaders.POSITION_COLOR, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BASIC_COLOR));
        coreShaderMapShadow.put(CoreShaders.PARTICLE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        coreShaderMapShadow.put(ShaderAccess.TRANSLUCENT_PARTICLE_SHADER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        coreShaderMapShadow.put(ShaderAccess.WEATHER_SHADER, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_SOLID, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ARMOR_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_GLINT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_GLINT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_GLINT_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ARMOR_ENTITY_GLINT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_CUTOUT_NO_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_CUTOUT_NO_CULL_Z_OFFSET, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_SMOOTH_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_SHADOW, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_DECAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_ALPHA, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ITEM_ENTITY_TRANSLUCENT_CULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_SOLID, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_CUTOUT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_CUTOUT_MIPPED, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderOverrides.isBlockEntities((IrisRenderingPipeline)p) ? ShaderKey.SHADOW_ENTITIES_CUTOUT : ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TRIPWIRE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ARMOR_TRANSLUCENT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_LINES, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LINES));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TEXT_BACKGROUND, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_BG));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TEXT_BACKGROUND_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_BG));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TEXT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TEXT_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TEXT_INTENSITY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_INTENSITY));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TEXT_INTENSITY_SEE_THROUGH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_INTENSITY));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_EYES, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENTITY_NO_OUTLINE, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_BREEZE_WIND, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_ENERGY_SWIRL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_BEACON_BEAM, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BEACON_BEAM));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_LIGHTNING, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LIGHTNING));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_END_PORTAL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_END_GATEWAY, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_LEASH, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LEASH));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_WATER_MASK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_CLOUDS, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_CLOUDS));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_CRUMBLING, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BASIC));
        coreShaderMapShadow.put(CloudRendererAccessor.getCLOUDS_SHADER(), (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_CLOUDS));
        coreShaderMapShadow.put(CoreShaders.RENDERTYPE_TRANSLUCENT_MOVING_BLOCK, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        for (ShaderProgram program : CoreShaders.getProgramsToPreload()) {
            if (!coreShaderMap.containsKey(program) || coreShaderMapShadow.containsKey(program)) continue;
            throw new IllegalStateException("Shader program " + String.valueOf(program) + " is not accounted for in the shadow list");
        }
    }
}

