/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pathways;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.irisshaders.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.mixin.GameRendererAccessor;
import net.irisshaders.iris.pipeline.WorldRenderingPhase;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    public static final float DEPTH = 0.125f;
    private final FullyBufferedMultiBufferSource bufferSource = new FullyBufferedMultiBufferSource();
    private boolean ACTIVE;
    private boolean renderingSolid;

    private PoseStack setupGlState(GameRenderer gameRenderer, Camera camera, Matrix4fc modelMatrix, float tickDelta) {
        PoseStack poseStack = new PoseStack();
        Matrix4f scaleMatrix = new Matrix4f().scale(1.0f, 1.0f, 0.125f);
        scaleMatrix.mul((Matrix4fc)gameRenderer.getProjectionMatrix(((GameRendererAccessor)gameRenderer).invokeGetFov(camera, tickDelta, false)));
        RenderSystem.setProjectionMatrix((Matrix4f)scaleMatrix, (ProjectionType)ProjectionType.PERSPECTIVE);
        poseStack.setIdentity();
        ((GameRendererAccessor)gameRenderer).invokeBobHurt(poseStack, tickDelta);
        if (((Boolean)Minecraft.getInstance().options.bobView().get()).booleanValue()) {
            ((GameRendererAccessor)gameRenderer).invokeBobView(poseStack, tickDelta);
        }
        return poseStack;
    }

    private boolean canRender(Camera camera, GameRenderer gameRenderer) {
        return ((GameRendererAccessor)gameRenderer).getRenderHand() && !camera.isDetached() && camera.getEntity() instanceof Player && !((GameRendererAccessor)gameRenderer).getPanoramicMode() && !Minecraft.getInstance().options.hideGui && (!(camera.getEntity() instanceof LivingEntity) || !((LivingEntity)camera.getEntity()).isSleeping()) && Minecraft.getInstance().gameMode.getPlayerMode() != GameType.SPECTATOR;
    }

    public boolean isHandTranslucent(InteractionHand hand) {
        Item item = Minecraft.getInstance().player.getItemBySlot(hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND).getItem();
        if (item instanceof BlockItem) {
            return ItemBlockRenderTypes.getChunkRenderType((BlockState)((BlockItem)item).getBlock().defaultBlockState()) == RenderType.translucent();
        }
        return false;
    }

    public boolean isAnyHandTranslucent() {
        return this.isHandTranslucent(InteractionHand.MAIN_HAND) || this.isHandTranslucent(InteractionHand.OFF_HAND);
    }

    public void renderSolid(Matrix4fc modelMatrix, float tickDelta, Camera camera, GameRenderer gameRenderer, WorldRenderingPipeline pipeline) {
        if (!this.canRender(camera, gameRenderer) || !Iris.isPackInUseQuick()) {
            return;
        }
        this.ACTIVE = true;
        PoseStack poseStack = this.setupGlState(gameRenderer, camera, modelMatrix, tickDelta);
        pipeline.setPhase(WorldRenderingPhase.HAND_SOLID);
        poseStack.pushPose();
        Profiler.get().push("iris_hand");
        this.renderingSolid = true;
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().set((Matrix4fc)poseStack.last().pose());
        gameRenderer.itemInHandRenderer.renderHandsWithItems(tickDelta, new PoseStack(), this.bufferSource.getUnflushableWrapper(), Minecraft.getInstance().player, Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(camera.getEntity(), tickDelta));
        Profiler.get().pop();
        this.bufferSource.readyUp();
        this.bufferSource.endBatch();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferProjection()), (ProjectionType)ProjectionType.PERSPECTIVE);
        poseStack.popPose();
        RenderSystem.getModelViewStack().popMatrix();
        this.renderingSolid = false;
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public void renderTranslucent(Matrix4fc modelMatrix, float tickDelta, Camera camera, GameRenderer gameRenderer, WorldRenderingPipeline pipeline) {
        if (!(this.canRender(camera, gameRenderer) && this.isAnyHandTranslucent() && Iris.isPackInUseQuick())) {
            return;
        }
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_TRANSLUCENT);
        PoseStack poseStack = this.setupGlState(gameRenderer, camera, modelMatrix, tickDelta);
        poseStack.pushPose();
        Profiler.get().push("iris_hand_translucent");
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().set((Matrix4fc)poseStack.last().pose());
        gameRenderer.itemInHandRenderer.renderHandsWithItems(tickDelta, new PoseStack(), (MultiBufferSource.BufferSource)this.bufferSource, Minecraft.getInstance().player, Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(camera.getEntity(), tickDelta));
        poseStack.popPose();
        Profiler.get().pop();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferProjection()), (ProjectionType)ProjectionType.PERSPECTIVE);
        this.bufferSource.endBatch();
        RenderSystem.getModelViewStack().popMatrix();
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public boolean isActive() {
        return this.ACTIVE;
    }

    public boolean isRenderingSolid() {
        return this.renderingSolid;
    }

    public FullyBufferedMultiBufferSource getBufferSource() {
        return this.bufferSource;
    }
}

