/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.irisshaders.iris.gl.GLDebug;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.BufferBlendOverride;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.gl.image.ImageHolder;
import net.irisshaders.iris.gl.program.ProgramImages;
import net.irisshaders.iris.gl.program.ProgramSamplers;
import net.irisshaders.iris.gl.program.ProgramUniforms;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.gl.uniform.DynamicLocationalUniformHolder;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.samplers.IrisSamplers;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.ShaderProgramConfig;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ExtendedShader
extends CompiledShaderProgram {
    private static final Matrix4f identity = new Matrix4f();
    private static ExtendedShader lastApplied;
    private final boolean intensitySwizzle;
    private final List<BufferBlendOverride> bufferBlendOverrides;
    private final boolean hasOverrides;
    private final Uniform modelViewInverse;
    private final Uniform projectionInverse;
    private final Uniform normalMatrix;
    private final CustomUniforms customUniforms;
    private final IrisRenderingPipeline parent;
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    private final GlFramebuffer writingToBeforeTranslucent;
    private final GlFramebuffer writingToAfterTranslucent;
    private final BlendModeOverride blendModeOverride;
    private final float alphaTest;
    private final boolean usesTessellation;
    private final Matrix4f tempMatrix4f = new Matrix4f();
    private final Matrix3f tempMatrix3f = new Matrix3f();
    private final float[] tempFloats = new float[16];
    private final float[] tempFloats2 = new float[9];
    private int textureToUnswizzle;

    public ExtendedShader(int programId, ResourceProvider resourceFactory, String string, VertexFormat vertexFormat, boolean usesTessellation, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, BlendModeOverride blendModeOverride, AlphaTest alphaTest, Consumer<DynamicLocationalUniformHolder> uniformCreator, BiConsumer<SamplerHolder, ImageHolder> samplerCreator, boolean isIntensity, IrisRenderingPipeline parent, @Nullable List<BufferBlendOverride> bufferBlendOverrides, CustomUniforms customUniforms) throws IOException {
        super(programId);
        ArrayList<ShaderProgramConfig.Uniform> uniformList = new ArrayList<ShaderProgramConfig.Uniform>();
        ArrayList<ShaderProgramConfig.Sampler> samplerList = new ArrayList<ShaderProgramConfig.Sampler>();
        uniformList.add(new ShaderProgramConfig.Uniform("iris_ModelViewMat", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_NormalMat", "matrix3x3", 9, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_ProjMat", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_TextureMat", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_ColorModulator", "float", 4, List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_FogColor", "float", 4, List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_ModelOffset", "float", 3, List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_FogStart", "float", 1, List.of(Float.valueOf(0.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_FogEnd", "float", 1, List.of(Float.valueOf(1.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_GlintAlpha", "float", 1, List.of(Float.valueOf(0.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_ModelViewMatInverse", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new ShaderProgramConfig.Uniform("iris_ProjMatInverse", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        samplerList.add(new ShaderProgramConfig.Sampler("Sampler0"));
        this.setupUniforms(uniformList, samplerList);
        GLDebug.nameObject(33506, programId, string);
        ProgramUniforms.Builder uniformBuilder = ProgramUniforms.builder(string, programId);
        ProgramSamplers.Builder samplerBuilder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        uniformCreator.accept(uniformBuilder);
        ProgramImages.Builder builder = ProgramImages.builder(programId);
        samplerCreator.accept(samplerBuilder, builder);
        customUniforms.mapholderToPass(uniformBuilder, (Object)this);
        this.usesTessellation = usesTessellation;
        this.uniforms = uniformBuilder.buildUniforms();
        this.customUniforms = customUniforms;
        this.samplers = samplerBuilder.build();
        this.images = builder.build();
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.blendModeOverride = blendModeOverride;
        this.bufferBlendOverrides = bufferBlendOverrides;
        this.hasOverrides = bufferBlendOverrides != null && !bufferBlendOverrides.isEmpty();
        this.alphaTest = alphaTest.reference();
        this.parent = parent;
        this.modelViewInverse = this.getUniform("ModelViewMatInverse");
        this.projectionInverse = this.getUniform("ProjMatInverse");
        this.normalMatrix = this.getUniform("NormalMat");
        this.intensitySwizzle = isIntensity;
    }

    public boolean isIntensitySwizzle() {
        return this.intensitySwizzle;
    }

    public void clear() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        if (this.blendModeOverride != null || this.hasOverrides) {
            BlendModeOverride.restore();
        }
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        super.clear();
    }

    public void setDefaultUniforms(VertexFormat.Mode mode, Matrix4f modelView, Matrix4f projection, Window window) {
        super.setDefaultUniforms(mode, modelView, projection, window);
        if (this.modelViewInverse != null) {
            this.modelViewInverse.set(modelView.invert(this.tempMatrix4f));
        }
        if (this.normalMatrix != null) {
            this.normalMatrix.set(modelView.invert(this.tempMatrix4f).transpose3x3(this.tempMatrix3f));
        }
        if (this.projectionInverse != null) {
            this.projectionInverse.set(projection.invert(this.tempMatrix4f));
        }
    }

    public void apply() {
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        GlStateManager._glUseProgram((int)this.getProgramId());
        int i = GlStateManager._getActiveTexture();
        GlStateManager._activeTexture((int)i);
        if (this.intensitySwizzle) {
            IrisRenderSystem.addUnswizzle(RenderSystem.getShaderTexture((int)0));
            IrisRenderSystem.texParameteriv(RenderSystem.getShaderTexture((int)0), TextureType.TEXTURE_2D.getGlType(), 36422, new int[]{6403, 6403, 6403, 6403});
        }
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 0, RenderSystem.getShaderTexture((int)0));
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 1, RenderSystem.getShaderTexture((int)1));
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 2, RenderSystem.getShaderTexture((int)2));
        ImmediateState.usingTessellation = this.usesTessellation;
        this.uploadIfNotNull(this.projectionInverse);
        this.uploadIfNotNull(this.modelViewInverse);
        this.uploadIfNotNull(this.normalMatrix);
        this.samplers.update();
        this.uniforms.update();
        List uniformList = ((CompiledShaderProgram)this).uniforms;
        for (Uniform uniform : uniformList) {
            this.uploadIfNotNull(uniform);
        }
        this.customUniforms.push((Object)this);
        this.images.update();
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.hasOverrides) {
            this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    @Nullable
    public Uniform getUniform(@NotNull String name) {
        Uniform uniform = super.getUniform("iris_" + name);
        if (uniform == null && (name.equalsIgnoreCase("OverlayUV") || name.equalsIgnoreCase("LightUV"))) {
            return null;
        }
        return uniform;
    }

    public void setupUniforms(List<ShaderProgramConfig.Uniform> list, List<ShaderProgramConfig.Sampler> list2) {
        RenderSystem.assertOnRenderThread();
        for (ShaderProgramConfig.Uniform uniform : list) {
            String string = uniform.name();
            int i = Uniform.glGetUniformLocation((int)this.getProgramId(), (CharSequence)string);
            if (i == -1) continue;
            Uniform uniform2 = this.parseUniformNode(uniform);
            uniform2.setLocation(i);
            ((CompiledShaderProgram)this).uniforms.add(uniform2);
            this.uniformsByName.put(string, uniform2);
        }
        for (ShaderProgramConfig.Sampler sampler : list2) {
            int j = Uniform.glGetUniformLocation((int)this.getProgramId(), (CharSequence)sampler.name());
            if (j == -1) continue;
            ((CompiledShaderProgram)this).samplers.add(sampler);
            this.samplerLocations.add(j);
        }
        this.MODEL_VIEW_MATRIX = super.getUniform("iris_ModelViewMat");
        this.PROJECTION_MATRIX = super.getUniform("iris_ProjMat");
        this.TEXTURE_MATRIX = super.getUniform("iris_TextureMat");
        this.SCREEN_SIZE = super.getUniform("iris_ScreenSize");
        this.COLOR_MODULATOR = super.getUniform("iris_ColorModulator");
        this.LIGHT0_DIRECTION = super.getUniform("iris_Light0_Direction");
        this.LIGHT1_DIRECTION = super.getUniform("iris_Light1_Direction");
        this.GLINT_ALPHA = super.getUniform("iris_GlintAlpha");
        this.FOG_START = super.getUniform("iris_FogStart");
        this.FOG_END = super.getUniform("iris_FogEnd");
        this.FOG_COLOR = super.getUniform("iris_FogColor");
        this.FOG_SHAPE = super.getUniform("iris_FogShape");
        this.LINE_WIDTH = super.getUniform("iris_LineWidth");
        this.GAME_TIME = super.getUniform("iris_GameTime");
        this.MODEL_OFFSET = super.getUniform("iris_ModelOffset");
    }

    private void uploadIfNotNull(Uniform uniform) {
        if (uniform != null) {
            uniform.upload();
        }
    }

    public boolean hasActiveImages() {
        return this.images.getActiveImages() > 0;
    }

    static {
        identity.identity();
    }
}

