/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.GLDebug;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.BufferBlendOverride;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.gl.image.ImageHolder;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.shader.ShaderCompileException;
import net.irisshaders.iris.gl.shader.ShaderType;
import net.irisshaders.iris.gl.state.FogMode;
import net.irisshaders.iris.gl.state.ShaderAttributeInputs;
import net.irisshaders.iris.gl.uniform.LocationalUniformHolder;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.fallback.ShaderSynthesizer;
import net.irisshaders.iris.pipeline.programs.ExtendedShader;
import net.irisshaders.iris.pipeline.programs.FallbackShader;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.pipeline.programs.ShaderSupplier;
import net.irisshaders.iris.pipeline.programs.VertexFormatExtension;
import net.irisshaders.iris.pipeline.transform.PatchShaderType;
import net.irisshaders.iris.pipeline.transform.ShaderPrinter;
import net.irisshaders.iris.pipeline.transform.TransformPatcher;
import net.irisshaders.iris.platform.IrisPlatformHelpers;
import net.irisshaders.iris.shaderpack.loading.ProgramId;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shadows.ShadowRenderTargets;
import net.irisshaders.iris.uniforms.CommonUniforms;
import net.irisshaders.iris.uniforms.FrameUpdateNotifier;
import net.irisshaders.iris.uniforms.VanillaUniforms;
import net.irisshaders.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.minecraft.client.renderer.ShaderProgramConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;

public class ShaderCreator {
    public static ShaderSupplier create(WorldRenderingPipeline pipeline, String name, ShaderKey shaderKey, ProgramSource source, ProgramId programId, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, AlphaTest fallbackAlpha, VertexFormat vertexFormat, ShaderAttributeInputs inputs, FrameUpdateNotifier updateNotifier, IrisRenderingPipeline parent, Supplier<ImmutableSet<Integer>> flipped, FogMode fogMode, boolean isIntensity, boolean isFullbright, boolean isShadowPass, boolean isLines, CustomUniforms customUniforms) throws IOException {
        AlphaTest alpha = source.getDirectives().getAlphaTestOverride().orElse(fallbackAlpha);
        BlendModeOverride blendModeOverride = source.getDirectives().getBlendModeOverride().orElse(programId.getBlendModeOverride());
        Map<PatchShaderType, String> transformed = TransformPatcher.patchVanilla(name, source.getVertexSource().orElseThrow(RuntimeException::new), source.getGeometrySource().orElse(null), source.getTessControlSource().orElse(null), source.getTessEvalSource().orElse(null), source.getFragmentSource().orElseThrow(RuntimeException::new), alpha, isLines, true, inputs, pipeline.getTextureMap());
        String vertex = transformed.get((Object)PatchShaderType.VERTEX);
        String geometry = transformed.get((Object)PatchShaderType.GEOMETRY);
        String tessControl = transformed.get((Object)PatchShaderType.TESS_CONTROL);
        String tessEval = transformed.get((Object)PatchShaderType.TESS_EVAL);
        String fragment = transformed.get((Object)PatchShaderType.FRAGMENT);
        String shaderJsonString = String.format("    {\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"%s\",\n    \"fragment\": \"%s\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"uniforms\": [\n        { \"name\": \"iris_TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ModelViewMatInverse\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ProjMatInverse\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_NormalMat\", \"type\": \"matrix3x3\", \"count\": 9, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0 ] },\n        { \"name\": \"iris_ModelOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        { \"name\": \"iris_ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"iris_GlintAlpha\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"iris_FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] },\n        {\n                    \"name\": \"iris_OverlayUV\",\n                    \"type\": \"int\",\n                    \"count\": 2,\n                    \"values\": [\n                        0,\n                        0\n                    ]\n                },\n                {\n                    \"name\": \"iris_LightUV\",\n                    \"type\": \"int\",\n                    \"count\": 2,\n                    \"values\": [\n                        0,\n                        0\n                    ]\n                }\n    ]\n}", name, name);
        ShaderPrinter.printProgram(name).addSources(transformed).addJson(shaderJsonString).print();
        IrisProgramResourceFactory shaderResourceFactory = new IrisProgramResourceFactory(shaderJsonString, vertex, geometry, tessControl, tessEval, fragment);
        ArrayList overrides = new ArrayList();
        source.getDirectives().getBufferBlendOverrides().forEach(information -> {
            int index = Ints.indexOf((int[])source.getDirectives().getDrawBuffers(), (int)information.index());
            if (index > -1) {
                overrides.add(new BufferBlendOverride(index, information.blendMode()));
            }
        });
        int id = ShaderCreator.link(name, vertex, geometry, tessControl, tessEval, fragment, vertexFormat, false);
        return new ShaderSupplier(shaderKey, id, () -> {
            try {
                return new ExtendedShader(id, shaderResourceFactory, name, vertexFormat, tessControl != null || tessEval != null, writingToBeforeTranslucent, writingToAfterTranslucent, blendModeOverride, alpha, uniforms -> {
                    CommonUniforms.addDynamicUniforms(uniforms, FogMode.PER_VERTEX);
                    customUniforms.assignTo((LocationalUniformHolder)uniforms);
                    BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
                    VanillaUniforms.addVanillaUniforms(uniforms);
                }, (arg_0, arg_1) -> ShaderCreator.lambda$create$2(parent, (Supplier)flipped, isShadowPass, inputs, arg_0, arg_1), isIntensity, parent, overrides, customUniforms);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static int link(String name, String vertex, String geometry, String tessControl, String tessEval, String fragment, VertexFormat vertexFormat, boolean isFallback) throws ShaderCompileException {
        int i = GlStateManager.glCreateProgram();
        if (i <= 0) {
            throw new RuntimeException("Could not create shader program (returned program ID " + i + ")");
        }
        int vertexS = ShaderCreator.createShader(name, ShaderType.VERTEX, vertex);
        int geometryS = ShaderCreator.createShader(name, ShaderType.GEOMETRY, geometry);
        int tessContS = ShaderCreator.createShader(name, ShaderType.TESSELATION_CONTROL, tessControl);
        int tessEvalS = ShaderCreator.createShader(name, ShaderType.TESSELATION_EVAL, tessEval);
        int fragS = ShaderCreator.createShader(name, ShaderType.FRAGMENT, fragment);
        ShaderCreator.attachIfValid(i, vertexS);
        ShaderCreator.attachIfValid(i, geometryS);
        ShaderCreator.attachIfValid(i, tessContS);
        ShaderCreator.attachIfValid(i, tessEvalS);
        ShaderCreator.attachIfValid(i, fragS);
        if (isFallback) {
            vertexFormat.bindAttributes(i);
        } else {
            ((VertexFormatExtension)vertexFormat).bindAttributesIris(i);
        }
        GlStateManager.glLinkProgram((int)i);
        ShaderCreator.detachIfValid(i, vertexS);
        ShaderCreator.detachIfValid(i, geometryS);
        ShaderCreator.detachIfValid(i, tessContS);
        ShaderCreator.detachIfValid(i, tessEvalS);
        ShaderCreator.detachIfValid(i, fragS);
        return i;
    }

    private static void attachIfValid(int i, int s) {
        if (s >= 0) {
            GlStateManager.glAttachShader((int)i, (int)s);
        }
    }

    private static void detachIfValid(int i, int s) {
        if (s >= 0) {
            IrisRenderSystem.detachShader(i, s);
            GlStateManager.glDeleteShader((int)s);
        }
    }

    private static int createShader(String name, ShaderType shaderType, String source) {
        int result;
        if (source == null) {
            return -1;
        }
        int shader = GlStateManager.glCreateShader((int)shaderType.id);
        GlStateManager.glShaderSource((int)shader, (String)source);
        GlStateManager.glCompileShader((int)shader);
        String log = IrisRenderSystem.getShaderInfoLog(shader);
        if (!log.isEmpty()) {
            Iris.logger.warn("Shader compilation log for " + name + ": " + log);
        }
        if ((result = GlStateManager.glGetShaderi((int)shader, (int)35713)) != 1) {
            throw new ShaderCompileException(name, log);
        }
        return shader;
    }

    public static ShaderSupplier createFallback(String name, ShaderKey shaderKey, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, AlphaTest alpha, VertexFormat vertexFormat, BlendModeOverride blendModeOverride, IrisRenderingPipeline parent, FogMode fogMode, boolean entityLighting, boolean isGlint, boolean isText, boolean intensityTex, boolean isFullbright) throws IOException {
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(vertexFormat, isFullbright, false, isGlint, isText, false);
        boolean isLeash = vertexFormat == DefaultVertexFormat.POSITION_COLOR_LIGHTMAP;
        String vertex = ShaderSynthesizer.vsh(true, inputs, fogMode, entityLighting, isLeash);
        String fragment = ShaderSynthesizer.fsh(inputs, fogMode, alpha, intensityTex, isLeash);
        String shaderJsonString = String.format("    {\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"%s\",\n    \"fragment\": \"%s\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"uniforms\": [\n        \t\t{ \"name\": \"TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        \t\t{ \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        \t\t{ \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        \t\t{ \"name\": \"ModelOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        \t\t{ \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        \t\t{ \"name\": \"GlintAlpha\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        \t\t{ \"name\": \"Light0_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        \t\t{ \"name\": \"Light1_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        \t\t{ \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        \t\t{ \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        \t\t{ \"name\": \"FogDensity\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        \t\t{ \"name\": \"FogIsExp2\", \"type\": \"int\", \"count\": 1, \"values\": [ 0 ] },\n        \t\t{ \"name\": \"AlphaTestValue\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        \t\t{ \"name\": \"LineWidth\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        \t\t{ \"name\": \"ScreenSize\", \"type\": \"float\", \"count\": 2, \"values\": [ 1.0, 1.0 ] },\n        \t\t{ \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}", name, name);
        ShaderPrinter.printProgram(name).addSource(PatchShaderType.VERTEX, vertex).addSource(PatchShaderType.FRAGMENT, fragment).print();
        JsonElement jsonElement = JsonParser.parseString((String)shaderJsonString);
        ShaderProgramConfig shaderProgramConfig = (ShaderProgramConfig)ShaderProgramConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonSyntaxException::new);
        IrisProgramResourceFactory shaderResourceFactory = new IrisProgramResourceFactory(shaderJsonString, vertex, null, null, null, fragment);
        int id = ShaderCreator.link(name, vertex, null, null, null, fragment, vertexFormat, true);
        GLDebug.nameObject(33506, id, name + "_fallback");
        return new ShaderSupplier(shaderKey, id, () -> {
            try {
                return new FallbackShader(id, shaderProgramConfig, shaderResourceFactory, name, vertexFormat, writingToBeforeTranslucent, writingToAfterTranslucent, blendModeOverride, alpha.reference(), parent);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static ShaderSupplier createFallbackShadow(String name, ShaderKey shaderKey, Supplier<ShadowRenderTargets> shadowSupplier, AlphaTest alpha, VertexFormat vertexFormat, BlendModeOverride blendModeOverride, IrisRenderingPipeline parent, FogMode fogMode, boolean entityLighting, boolean isGlint, boolean isText, boolean intensityTex, boolean isFullbright) throws IOException {
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(vertexFormat, isFullbright, false, isGlint, isText, false);
        boolean isLeash = vertexFormat == DefaultVertexFormat.POSITION_COLOR_LIGHTMAP;
        String vertex = ShaderSynthesizer.vsh(true, inputs, fogMode, entityLighting, isLeash);
        String fragment = ShaderSynthesizer.fsh(inputs, fogMode, alpha, intensityTex, isLeash);
        String shaderJsonString = String.format("    {\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"%s\",\n    \"fragment\": \"%s\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"uniforms\": [\n        \t\t{ \"name\": \"TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        \t\t{ \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        \t\t{ \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        \t\t{ \"name\": \"ModelOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        \t\t{ \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        \t\t{ \"name\": \"GlintAlpha\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        \t\t{ \"name\": \"Light0_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        \t\t{ \"name\": \"Light1_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        \t\t{ \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        \t\t{ \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        \t\t{ \"name\": \"FogDensity\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        \t\t{ \"name\": \"FogIsExp2\", \"type\": \"int\", \"count\": 1, \"values\": [ 0 ] },\n        \t\t{ \"name\": \"AlphaTestValue\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        \t\t{ \"name\": \"LineWidth\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        \t\t{ \"name\": \"ScreenSize\", \"type\": \"float\", \"count\": 2, \"values\": [ 1.0, 1.0 ] },\n        \t\t{ \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}", name, name);
        ShaderPrinter.printProgram(name).addSource(PatchShaderType.VERTEX, vertex).addSource(PatchShaderType.FRAGMENT, fragment).print();
        JsonElement jsonElement = JsonParser.parseString((String)shaderJsonString);
        ShaderProgramConfig shaderProgramConfig = (ShaderProgramConfig)ShaderProgramConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonSyntaxException::new);
        IrisProgramResourceFactory shaderResourceFactory = new IrisProgramResourceFactory(shaderJsonString, vertex, null, null, null, fragment);
        int id = ShaderCreator.link(name, vertex, null, null, null, fragment, vertexFormat, true);
        return new ShaderSupplier(shaderKey, id, () -> {
            try {
                GlFramebuffer framebuffer = ((ShadowRenderTargets)shadowSupplier.get()).createShadowFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), new int[]{0});
                return new FallbackShader(id, shaderProgramConfig, shaderResourceFactory, name, vertexFormat, framebuffer, framebuffer, blendModeOverride, alpha.reference(), parent);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static ShaderSupplier createShadow(WorldRenderingPipeline pipeline, String name, ShaderKey shaderKey, ProgramSource source, ProgramId programId, Supplier<ShadowRenderTargets> shadowSupplier, AlphaTest fallbackAlpha, VertexFormat vertexFormat, ShaderAttributeInputs inputs, FrameUpdateNotifier updateNotifier, IrisRenderingPipeline parent, Supplier<ImmutableSet<Integer>> flipped, FogMode fogMode, boolean isIntensity, boolean isFullbright, boolean isShadowPass, boolean isLines, CustomUniforms customUniforms) throws IOException {
        AlphaTest alpha = source.getDirectives().getAlphaTestOverride().orElse(fallbackAlpha);
        BlendModeOverride blendModeOverride = source.getDirectives().getBlendModeOverride().orElse(programId.getBlendModeOverride());
        Map<PatchShaderType, String> transformed = TransformPatcher.patchVanilla(name, source.getVertexSource().orElseThrow(RuntimeException::new), source.getGeometrySource().orElse(null), source.getTessControlSource().orElse(null), source.getTessEvalSource().orElse(null), source.getFragmentSource().orElseThrow(RuntimeException::new), alpha, isLines, true, inputs, pipeline.getTextureMap());
        String vertex = transformed.get((Object)PatchShaderType.VERTEX);
        String geometry = transformed.get((Object)PatchShaderType.GEOMETRY);
        String tessControl = transformed.get((Object)PatchShaderType.TESS_CONTROL);
        String tessEval = transformed.get((Object)PatchShaderType.TESS_EVAL);
        String fragment = transformed.get((Object)PatchShaderType.FRAGMENT);
        ShaderPrinter.printProgram(name).addSources(transformed).print();
        IrisProgramResourceFactory shaderResourceFactory = new IrisProgramResourceFactory("", vertex, geometry, tessControl, tessEval, fragment);
        ArrayList overrides = new ArrayList();
        source.getDirectives().getBufferBlendOverrides().forEach(information -> {
            int index = Ints.indexOf((int[])source.getDirectives().getDrawBuffers(), (int)information.index());
            if (index > -1) {
                overrides.add(new BufferBlendOverride(index, information.blendMode()));
            }
        });
        int id = ShaderCreator.link(name, vertex, geometry, tessControl, tessEval, fragment, vertexFormat, false);
        return new ShaderSupplier(shaderKey, id, () -> {
            int[] nArray;
            ShadowRenderTargets shadowRenderTargets = (ShadowRenderTargets)shadowSupplier.get();
            ImmutableSet immutableSet = ImmutableSet.of();
            if (source.getDirectives().hasUnknownDrawBuffers()) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 1;
            } else {
                nArray = source.getDirectives().getDrawBuffers();
            }
            GlFramebuffer framebuffer = shadowRenderTargets.createShadowFramebuffer((ImmutableSet<Integer>)immutableSet, nArray);
            try {
                return new ExtendedShader(id, shaderResourceFactory, name, vertexFormat, tessControl != null || tessEval != null, framebuffer, framebuffer, blendModeOverride, alpha, uniforms -> {
                    CommonUniforms.addDynamicUniforms(uniforms, FogMode.PER_VERTEX);
                    customUniforms.assignTo((LocationalUniformHolder)uniforms);
                    BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
                    VanillaUniforms.addVanillaUniforms(uniforms);
                }, (arg_0, arg_1) -> ShaderCreator.lambda$createShadow$8(parent, (Supplier)flipped, isShadowPass, inputs, arg_0, arg_1), isIntensity, parent, overrides, customUniforms);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static /* synthetic */ void lambda$createShadow$8(IrisRenderingPipeline parent, Supplier flipped, boolean isShadowPass, ShaderAttributeInputs inputs, SamplerHolder samplerHolder, ImageHolder imageHolder) {
        parent.addGbufferOrShadowSamplers(samplerHolder, imageHolder, flipped, isShadowPass, inputs.hasTex(), inputs.hasLight(), inputs.hasOverlay());
    }

    private static /* synthetic */ void lambda$create$2(IrisRenderingPipeline parent, Supplier flipped, boolean isShadowPass, ShaderAttributeInputs inputs, SamplerHolder samplerHolder, ImageHolder imageHolder) {
        parent.addGbufferOrShadowSamplers(samplerHolder, imageHolder, flipped, isShadowPass, inputs.hasTex(), inputs.hasLight(), inputs.hasOverlay());
    }

    private record IrisProgramResourceFactory(String json, String vertex, String geometry, String tessControl, String tessEval, String fragment) implements ResourceProvider
    {
        public Optional<Resource> getResource(ResourceLocation id) {
            String path = id.getPath();
            if (path.endsWith("json")) {
                return Optional.of(new StringResource(id, this.json));
            }
            if (path.endsWith("vsh")) {
                return Optional.of(new StringResource(id, this.vertex));
            }
            if (path.endsWith("gsh")) {
                if (this.geometry == null) {
                    return Optional.empty();
                }
                return Optional.of(new StringResource(id, this.geometry));
            }
            if (path.endsWith("tcs")) {
                if (this.tessControl == null) {
                    return Optional.empty();
                }
                return Optional.of(new StringResource(id, this.tessControl));
            }
            if (path.endsWith("tes")) {
                if (this.tessEval == null) {
                    return Optional.empty();
                }
                return Optional.of(new StringResource(id, this.tessEval));
            }
            if (path.endsWith("fsh")) {
                return Optional.of(new StringResource(id, this.fragment));
            }
            return Optional.empty();
        }
    }

    private static class StringResource
    extends Resource {
        private final String content;

        private StringResource(ResourceLocation id, String content) {
            super((PackResources)new PathPackResources(new PackLocationInfo("<iris shaderpack shaders>", (Component)Component.literal((String)"iris"), PackSource.BUILT_IN, Optional.of(new KnownPack("iris", "shader", "1.0"))), IrisPlatformHelpers.getInstance().getConfigDir()), () -> new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
            this.content = content;
        }

        public InputStream open() {
            return IOUtils.toInputStream((String)this.content, (Charset)StandardCharsets.UTF_8);
        }
    }
}

