/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.uniforms;

import com.mojang.blaze3d.systems.RenderSystem;
import net.irisshaders.iris.gl.state.FogMode;
import net.irisshaders.iris.gl.uniform.DynamicUniformHolder;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.renderer.FogParameters;
import org.joml.Vector4f;

public class IrisInternalUniforms {
    private static final Vector4f ONE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);

    private IrisInternalUniforms() {
    }

    public static void addFogUniforms(DynamicUniformHolder uniforms, FogMode fogMode) {
        uniforms.uniform4f("iris_FogColor", () -> {
            FogParameters fog = RenderSystem.getShaderFog();
            if (fog == FogParameters.NO_FOG) {
                return ONE;
            }
            return new Vector4f(fog.red(), fog.green(), fog.blue(), fog.alpha());
        }, t -> {});
        uniforms.uniform1f("iris_FogStart", () -> RenderSystem.getShaderFog().start(), t -> {}).uniform1f("iris_FogEnd", () -> RenderSystem.getShaderFog().end(), t -> {});
        uniforms.uniform1f("iris_FogDensity", () -> Math.max(0.0f, CapturedRenderingState.INSTANCE.getFogDensity()), notifier -> {});
        uniforms.uniform1f("iris_currentAlphaTest", CapturedRenderingState.INSTANCE::getCurrentAlphaTest, notifier -> {});
        uniforms.uniform1f("alphaTestRef", CapturedRenderingState.INSTANCE::getCurrentAlphaTest, notifier -> {});
    }
}

