/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.block.hopper;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.caffeinemc.mods.lithium.api.inventory.LithiumCooldownReceivingInventory;
import net.caffeinemc.mods.lithium.api.inventory.LithiumInventory;
import net.caffeinemc.mods.lithium.common.block.entity.SleepingBlockEntity;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import net.caffeinemc.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import net.caffeinemc.mods.lithium.common.compat.TransferApiHelper;
import net.caffeinemc.mods.lithium.common.hopper.BlockStateOnlyInventory;
import net.caffeinemc.mods.lithium.common.hopper.HopperCachingState;
import net.caffeinemc.mods.lithium.common.hopper.HopperHelper;
import net.caffeinemc.mods.lithium.common.hopper.InventoryHelper;
import net.caffeinemc.mods.lithium.common.hopper.LithiumStackList;
import net.caffeinemc.mods.lithium.common.hopper.UpdateReceiver;
import net.caffeinemc.mods.lithium.common.tracking.entity.SectionedEntityMovementListener;
import net.caffeinemc.mods.lithium.common.tracking.entity.SectionedInventoryEntityMovementTracker;
import net.caffeinemc.mods.lithium.common.tracking.entity.SectionedItemEntityMovementTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HopperBlockEntity.class}, priority=950)
public abstract class HopperBlockEntityMixin
extends BlockEntity
implements Hopper,
UpdateReceiver,
LithiumInventory,
InventoryChangeListener,
SectionedEntityMovementListener {
    @Shadow
    private long tickedGameTime;
    private long myModCountAtLastInsert;
    private long myModCountAtLastExtract;
    private long myModCountAtLastItemCollect;
    private HopperCachingState.BlockInventory insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
    private HopperCachingState.BlockInventory extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
    @Nullable
    private Container insertBlockInventory;
    @Nullable
    private Container extractBlockInventory;
    @Nullable
    private LithiumInventory insertInventory;
    @Nullable
    private LithiumInventory extractInventory;
    @Nullable
    private LithiumStackList insertStackList;
    @Nullable
    private LithiumStackList extractStackList;
    private long insertStackListModCount;
    private long extractStackListModCount;
    private SectionedItemEntityMovementTracker<ItemEntity> collectItemEntityTracker;
    private boolean collectItemEntityTrackerWasEmpty;
    private AABB collectItemEntityBox;
    private long collectItemEntityAttemptTime;
    private SectionedInventoryEntityMovementTracker<Container> extractInventoryEntityTracker;
    private AABB extractInventoryEntityBox;
    private long extractInventoryEntityFailedSearchTime;
    private SectionedInventoryEntityMovementTracker<Container> insertInventoryEntityTracker;
    private AABB insertInventoryEntityBox;
    private long insertInventoryEntityFailedSearchTime;
    private boolean shouldCheckSleep;
    @Shadow
    private Direction facing;

    public HopperBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Shadow
    protected abstract boolean isOnCustomCooldown();

    @Redirect(method={"suckInItems"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getSourceContainer(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/Container;"), require=0, expect=0)
    private static Container getExtractInventory(Level world, Hopper hopper, BlockPos extractBlockPos, BlockState extractBlockState) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntityMixin.getSourceContainer(world, hopper, extractBlockPos, extractBlockState);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        Container blockInventory = hopperBlockEntity.lithium$getExtractBlockInventory(world, extractBlockPos, extractBlockState);
        if (blockInventory != null) {
            return blockInventory;
        }
        return hopperBlockEntity.lithium$getExtractEntityInventory(world);
    }

    @Inject(cancellable=true, method={"ejectItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;isFullContainer(Lnet/minecraft/world/Container;Lnet/minecraft/core/Direction;)Z")})
    private static void lithiumInsert(Level world, BlockPos pos, HopperBlockEntity blockEntity, CallbackInfoReturnable<Boolean> cir, @Local Container insertInventory) {
        boolean insertInventoryHandlesModdedCooldown;
        boolean insertInventoryWasEmptyHopperNotDisabled;
        if (insertInventory == null || !(blockEntity instanceof HopperBlockEntity) || blockEntity instanceof WorldlyContainer) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)blockEntity;
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        if (hopperBlockEntity.insertInventory == insertInventory && hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastInsert && hopperBlockEntity.insertStackList != null && hopperBlockEntity.insertStackList.getModCount() == hopperBlockEntity.insertStackListModCount) {
            cir.setReturnValue((Object)false);
            return;
        }
        boolean bl = insertInventoryWasEmptyHopperNotDisabled = insertInventory instanceof HopperBlockEntityMixin && !((HopperBlockEntityMixin)insertInventory).isOnCustomCooldown() && hopperBlockEntity.insertStackList != null && hopperBlockEntity.insertStackList.getOccupiedSlots() == 0;
        boolean bl2 = ((LithiumCooldownReceivingInventory)insertInventory).canReceiveTransferCooldown() && hopperBlockEntity.insertStackList != null ? hopperBlockEntity.insertStackList.getOccupiedSlots() == 0 : (insertInventoryHandlesModdedCooldown = insertInventory.isEmpty());
        if (hopperBlockEntity.insertInventory != insertInventory || hopperBlockEntity.insertStackList.getFullSlots() != hopperBlockEntity.insertStackList.size()) {
            Direction fromDirection = hopperBlockEntity.facing.getOpposite();
            int size = hopperStackList.size();
            for (int i = 0; i < size; ++i) {
                boolean transferSuccess;
                ItemStack transferStack = (ItemStack)hopperStackList.get(i);
                if (transferStack.isEmpty() || !(transferSuccess = HopperHelper.tryMoveSingleItem(insertInventory, transferStack, fromDirection))) continue;
                if (insertInventoryWasEmptyHopperNotDisabled) {
                    HopperBlockEntityMixin receivingHopper = (HopperBlockEntityMixin)insertInventory;
                    int k = 8;
                    if (receivingHopper.tickedGameTime >= hopperBlockEntity.tickedGameTime) {
                        k = 7;
                    }
                    receivingHopper.setCooldown(k);
                }
                if (insertInventoryHandlesModdedCooldown) {
                    ((LithiumCooldownReceivingInventory)insertInventory).setTransferCooldown(hopperBlockEntity.tickedGameTime);
                }
                insertInventory.setChanged();
                cir.setReturnValue((Object)true);
                return;
            }
        }
        hopperBlockEntity.myModCountAtLastInsert = hopperStackList.getModCount();
        if (hopperBlockEntity.insertStackList != null) {
            hopperBlockEntity.insertStackListModCount = hopperBlockEntity.insertStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Redirect(method={"ejectItems"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getAttachedContainer(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;)Lnet/minecraft/world/Container;"), require=0, expect=0)
    private static Container getLithiumOutputInventory(Level world, BlockPos pos, HopperBlockEntity blockEntity) {
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)blockEntity;
        return hopperBlockEntity.getInsertInventory(world);
    }

    @Inject(method={"suckInItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/core/Direction;DOWN:Lnet/minecraft/core/Direction;", shift=At.Shift.AFTER)}, cancellable=true)
    private static void lithiumExtract(Level world, Hopper to, CallbackInfoReturnable<Boolean> cir, @Local Container from) {
        if (!(to instanceof HopperBlockEntityMixin)) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)to;
        if (from != hopperBlockEntity.extractInventory || hopperBlockEntity.extractStackList == null) {
            return;
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        LithiumStackList fromStackList = hopperBlockEntity.extractStackList;
        if (hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastExtract && fromStackList.getModCount() == hopperBlockEntity.extractStackListModCount) {
            ComparatorTracker comparatorTracker;
            if (!(from instanceof ComparatorTracker) || (comparatorTracker = (ComparatorTracker)from).lithium$hasAnyComparatorNearby()) {
                fromStackList.runComparatorUpdatePatternOnFailedExtract(fromStackList, from);
            }
            cir.setReturnValue((Object)false);
            return;
        }
        int[] availableSlots = from instanceof WorldlyContainer ? ((WorldlyContainer)from).getSlotsForFace(Direction.DOWN) : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.getContainerSize();
        for (int i = 0; i < fromSize; ++i) {
            int fromSlot = availableSlots != null ? availableSlots[i] : i;
            ItemStack itemStack = (ItemStack)fromStackList.get(fromSlot);
            if (itemStack.isEmpty() || !HopperBlockEntityMixin.canTakeItemFromContainer((Container)to, from, itemStack, fromSlot, Direction.DOWN)) continue;
            ItemStack takenItem = from.removeItem(fromSlot, 1);
            assert (!takenItem.isEmpty());
            boolean transferSuccess = HopperHelper.tryMoveSingleItem((Container)to, takenItem, null);
            if (transferSuccess) {
                to.setChanged();
                from.setChanged();
                cir.setReturnValue((Object)true);
                return;
            }
            ItemStack restoredStack = (ItemStack)fromStackList.get(fromSlot);
            if (restoredStack.isEmpty()) {
                restoredStack = takenItem;
            } else {
                restoredStack.grow(1);
            }
            from.setItem(fromSlot, restoredStack);
        }
        hopperBlockEntity.myModCountAtLastExtract = hopperStackList.getModCount();
        if (fromStackList != null) {
            hopperBlockEntity.extractStackListModCount = fromStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Redirect(method={"tryMoveItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;inventoryFull()Z"))
    private static boolean lithiumHopperIsFull(HopperBlockEntity hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getFullSlots() == lithiumStackList.size();
    }

    @Redirect(method={"tryMoveItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;isEmpty()Z"))
    private static boolean lithiumHopperIsEmpty(HopperBlockEntity hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getOccupiedSlots() == 0;
    }

    @Shadow
    protected abstract void setCooldown(int var1);

    @Shadow
    protected abstract boolean isOnCooldown();

    @Shadow
    private static native boolean canTakeItemFromContainer(Container var0, Container var1, ItemStack var2, int var3, Direction var4);

    @Shadow
    @Nullable
    private static native Container getBlockContainer(Level var0, BlockPos var1, BlockState var2);

    @Shadow
    @Nullable
    protected static native Container getSourceContainer(Level var0, Hopper var1, BlockPos var2, BlockState var3);

    @Override
    public void lithium$invalidateCacheOnNeighborUpdate(boolean fromAbove) {
        if (fromAbove) {
            if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
                this.invalidateBlockExtractionData();
            }
        } else if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockInsertionData();
        }
    }

    @Override
    public void lithium$invalidateCacheOnUndirectedNeighborUpdate() {
        if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockExtractionData();
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockInsertionData();
        }
    }

    @Override
    public void lithium$invalidateCacheOnNeighborUpdate(Direction fromDirection) {
        boolean fromAbove;
        boolean bl = fromAbove = fromDirection == Direction.UP;
        if (fromAbove || this.getBlockState().getValue((Property)HopperBlock.FACING) == fromDirection) {
            this.lithium$invalidateCacheOnNeighborUpdate(fromAbove);
        }
    }

    @Unique
    @Nullable
    private Container lithium$getExtractEntityInventory(Level world) {
        if (this.extractInventoryEntityTracker == null) {
            this.initExtractInventoryTracker(world);
        }
        if (this.extractInventoryEntityTracker.isUnchangedSince(this.extractInventoryEntityFailedSearchTime)) {
            this.extractInventoryEntityFailedSearchTime = this.tickedGameTime;
            return null;
        }
        this.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        this.shouldCheckSleep = false;
        List<Container> inventoryEntities = this.extractInventoryEntityTracker.getEntities(this.extractInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            this.extractInventoryEntityFailedSearchTime = this.tickedGameTime;
            return null;
        }
        Container inventory = inventoryEntities.get(world.random.nextInt(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != this.extractInventory || this.extractStackList != extractInventoryStackList) {
                this.cacheExtractLithiumInventory(optimizedInventory);
            }
        }
        return inventory;
    }

    @Redirect(method={"suckInItems"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;getItemsAtAndAbove(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/Hopper;)Ljava/util/List;"))
    private static List<ItemEntity> lithiumGetInputItemEntities(Level world, Hopper hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntity.getItemsAtAndAbove((Level)world, (Hopper)hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        if (hopperBlockEntity.collectItemEntityTracker == null) {
            hopperBlockEntity.initCollectItemEntityTracker();
        }
        long modCount = InventoryHelper.getLithiumStackList(hopperBlockEntity).getModCount();
        if ((hopperBlockEntity.collectItemEntityTrackerWasEmpty || hopperBlockEntity.myModCountAtLastItemCollect == modCount) && hopperBlockEntity.collectItemEntityTracker.isUnchangedSince(hopperBlockEntity.collectItemEntityAttemptTime)) {
            hopperBlockEntity.collectItemEntityAttemptTime = hopperBlockEntity.tickedGameTime;
            return Collections.emptyList();
        }
        hopperBlockEntity.myModCountAtLastItemCollect = modCount;
        hopperBlockEntity.shouldCheckSleep = false;
        List<ItemEntity> itemEntities = hopperBlockEntity.collectItemEntityTracker.getEntities(hopperBlockEntity.collectItemEntityBox);
        hopperBlockEntity.collectItemEntityAttemptTime = hopperBlockEntity.tickedGameTime;
        hopperBlockEntity.collectItemEntityTrackerWasEmpty = itemEntities.isEmpty();
        return itemEntities;
    }

    private void cacheInsertBlockInventory(Container insertInventory) {
        assert (!(insertInventory instanceof Entity));
        if (insertInventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)insertInventory;
            this.cacheInsertLithiumInventory(optimizedInventory);
        } else {
            this.insertInventory = null;
            this.insertStackList = null;
            this.insertStackListModCount = 0L;
        }
        if (insertInventory instanceof BlockEntity || insertInventory instanceof CompoundContainer) {
            this.insertBlockInventory = insertInventory;
            if (insertInventory instanceof InventoryChangeTracker) {
                this.insertionMode = HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY;
                ((InventoryChangeTracker)insertInventory).listenForMajorInventoryChanges(this);
            } else {
                this.insertionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
            }
        } else if (insertInventory == null) {
            this.insertBlockInventory = null;
            this.insertionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.insertBlockInventory = insertInventory;
            this.insertionMode = insertInventory instanceof BlockStateOnlyInventory ? HopperCachingState.BlockInventory.BLOCK_STATE : HopperCachingState.BlockInventory.UNKNOWN;
        }
    }

    private void cacheInsertLithiumInventory(LithiumInventory optimizedInventory) {
        LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
        this.insertInventory = optimizedInventory;
        this.insertStackList = insertInventoryStackList;
        this.insertStackListModCount = insertInventoryStackList.getModCount() - 1L;
    }

    private void cacheExtractLithiumInventory(LithiumInventory optimizedInventory) {
        LithiumStackList extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
        this.extractInventory = optimizedInventory;
        this.extractStackList = extractInventoryStackList;
        this.extractStackListModCount = extractInventoryStackList.getModCount() - 1L;
    }

    private void cacheExtractBlockInventory(Container extractInventory) {
        assert (!(extractInventory instanceof Entity));
        if (extractInventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)extractInventory;
            this.cacheExtractLithiumInventory(optimizedInventory);
        } else {
            this.extractInventory = null;
            this.extractStackList = null;
            this.extractStackListModCount = 0L;
        }
        if (extractInventory instanceof BlockEntity || extractInventory instanceof CompoundContainer) {
            this.extractBlockInventory = extractInventory;
            if (extractInventory instanceof InventoryChangeTracker) {
                this.extractionMode = HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY;
                ((InventoryChangeTracker)extractInventory).listenForMajorInventoryChanges(this);
            } else {
                this.extractionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
            }
        } else if (extractInventory == null) {
            this.extractBlockInventory = null;
            this.extractionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.extractBlockInventory = extractInventory;
            this.extractionMode = extractInventory instanceof BlockStateOnlyInventory ? HopperCachingState.BlockInventory.BLOCK_STATE : HopperCachingState.BlockInventory.UNKNOWN;
        }
    }

    public Container lithium$getExtractBlockInventory(Level world, BlockPos extractBlockPos, BlockState extractBlockState) {
        Container blockInventory = this.extractBlockInventory;
        if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
            return null;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            return blockInventory;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            return blockInventory;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY) {
            BlockEntity blockEntity = (BlockEntity)Objects.requireNonNull(blockInventory);
            BlockPos pos = blockEntity.getBlockPos();
            if (!blockEntity.isRemoved() && pos.equals((Object)extractBlockPos)) {
                LithiumInventory optimizedInventory = this.extractInventory;
                if (optimizedInventory != null) {
                    LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                    if (insertInventoryStackList == this.extractStackList) {
                        return optimizedInventory;
                    }
                    this.invalidateBlockExtractionData();
                } else {
                    return blockInventory;
                }
            }
        }
        blockInventory = HopperBlockEntityMixin.getBlockContainer(world, extractBlockPos, extractBlockState);
        blockInventory = HopperHelper.replaceDoubleInventory(blockInventory);
        this.cacheExtractBlockInventory(blockInventory);
        return blockInventory;
    }

    public Container lithium$getInsertBlockInventory(Level world) {
        Container blockInventory = this.insertBlockInventory;
        if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
            return null;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            return blockInventory;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            return blockInventory;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY) {
            BlockEntity blockEntity = (BlockEntity)Objects.requireNonNull(blockInventory);
            BlockPos pos = blockEntity.getBlockPos();
            Direction direction = this.facing;
            BlockPos transferPos = this.getBlockPos().relative(direction);
            if (!blockEntity.isRemoved() && pos.equals((Object)transferPos)) {
                LithiumInventory optimizedInventory = this.insertInventory;
                if (optimizedInventory != null) {
                    LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                    if (insertInventoryStackList == this.insertStackList) {
                        return optimizedInventory;
                    }
                    this.invalidateBlockInsertionData();
                } else {
                    return blockInventory;
                }
            }
        }
        Direction direction = this.facing;
        BlockPos insertBlockPos = this.getBlockPos().relative(direction);
        BlockState blockState = world.getBlockState(insertBlockPos);
        blockInventory = HopperBlockEntityMixin.getBlockContainer(world, insertBlockPos, blockState);
        blockInventory = HopperHelper.replaceDoubleInventory(blockInventory);
        this.cacheInsertBlockInventory(blockInventory);
        return blockInventory;
    }

    public Container getInsertInventory(Level world) {
        Container blockInventory = this.lithium$getInsertBlockInventory(world);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (this.insertInventoryEntityTracker == null) {
            this.initInsertInventoryTracker(world);
        }
        if (this.insertInventoryEntityTracker.isUnchangedSince(this.insertInventoryEntityFailedSearchTime)) {
            this.insertInventoryEntityFailedSearchTime = this.tickedGameTime;
            return null;
        }
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        this.shouldCheckSleep = false;
        List<Container> inventoryEntities = this.insertInventoryEntityTracker.getEntities(this.insertInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            this.insertInventoryEntityFailedSearchTime = this.tickedGameTime;
            return null;
        }
        Container inventory = inventoryEntities.get(world.random.nextInt(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != this.insertInventory || this.insertStackList != insertInventoryStackList) {
                this.cacheInsertLithiumInventory(optimizedInventory);
            }
        }
        return inventory;
    }

    private void initCollectItemEntityTracker() {
        AABB inputBox;
        assert (this.level instanceof ServerLevel);
        this.collectItemEntityBox = inputBox = this.getSuckAabb().move((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
        this.collectItemEntityTracker = SectionedItemEntityMovementTracker.registerAt((ServerLevel)this.level, inputBox, ItemEntity.class);
        this.collectItemEntityAttemptTime = Long.MIN_VALUE;
    }

    private void initExtractInventoryTracker(Level world) {
        assert (world instanceof ServerLevel);
        BlockPos pos = this.worldPosition.relative(Direction.UP);
        this.extractInventoryEntityBox = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
        this.extractInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((ServerLevel)this.level, this.extractInventoryEntityBox, Container.class);
        this.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    private void initInsertInventoryTracker(Level world) {
        assert (world instanceof ServerLevel);
        Direction direction = this.facing;
        BlockPos pos = this.worldPosition.relative(direction);
        this.insertInventoryEntityBox = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
        this.insertInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((ServerLevel)this.level, this.insertInventoryEntityBox, Container.class);
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    @Inject(method={"setBlockState(Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")})
    private void invalidateOnSetCachedState(BlockState state, CallbackInfo ci) {
        if (this.level != null && !this.level.isClientSide() && state.getValue((Property)HopperBlock.FACING) != this.getBlockState().getValue((Property)HopperBlock.FACING)) {
            this.invalidateCachedData();
        }
    }

    private void invalidateCachedData() {
        this.shouldCheckSleep = false;
        this.invalidateInsertionData();
        this.invalidateExtractionData();
    }

    private void invalidateInsertionData() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.insertInventoryEntityTracker != null) {
                this.insertInventoryEntityTracker.unRegister(serverWorld);
                this.insertInventoryEntityTracker = null;
                this.insertInventoryEntityBox = null;
                this.insertInventoryEntityFailedSearchTime = 0L;
            }
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            assert (this.insertBlockInventory != null);
            ((InventoryChangeTracker)this.insertBlockInventory).stopListenForMajorInventoryChanges(this);
        }
        this.invalidateBlockInsertionData();
    }

    private void invalidateBlockInsertionData() {
        this.insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.insertBlockInventory = null;
        this.insertInventory = null;
        this.insertStackList = null;
        this.insertStackListModCount = 0L;
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    private void invalidateExtractionData() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.extractInventoryEntityTracker != null) {
                this.extractInventoryEntityTracker.unRegister(serverWorld);
                this.extractInventoryEntityTracker = null;
                this.extractInventoryEntityBox = null;
                this.extractInventoryEntityFailedSearchTime = 0L;
            }
            if (this.collectItemEntityTracker != null) {
                this.collectItemEntityTracker.unRegister(serverWorld);
                this.collectItemEntityTracker = null;
                this.collectItemEntityBox = null;
                this.collectItemEntityTrackerWasEmpty = false;
            }
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
            assert (this.extractBlockInventory != null);
            ((InventoryChangeTracker)this.extractBlockInventory).stopListenForMajorInventoryChanges(this);
        }
        this.invalidateBlockExtractionData();
    }

    private void invalidateBlockExtractionData() {
        this.extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.extractBlockInventory = null;
        this.extractInventory = null;
        this.extractStackList = null;
        this.extractStackListModCount = 0L;
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    @Inject(method={"pushItemsTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/HopperBlockEntity;tryMoveItems(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z", shift=At.Shift.AFTER)})
    private static void checkSleepingConditions(Level world, BlockPos pos, BlockState state, HopperBlockEntity blockEntity, CallbackInfo ci) {
        ((HopperBlockEntityMixin)blockEntity).checkSleepingConditions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkSleepingConditions() {
        Container blockInventory;
        if (this.isOnCooldown()) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (!(hopperBlockEntityMixin instanceof SleepingBlockEntity)) return;
        SleepingBlockEntity thisSleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
        if (thisSleepingBlockEntity.isSleeping()) {
            return;
        }
        if (!this.shouldCheckSleep) {
            this.shouldCheckSleep = true;
            return;
        }
        HopperBlockEntityMixin hopperBlockEntityMixin2 = this;
        if (!(hopperBlockEntityMixin2 instanceof InventoryChangeTracker)) return;
        InventoryChangeTracker thisTracker = (InventoryChangeTracker)((Object)hopperBlockEntityMixin2);
        boolean listenToExtractTracker = false;
        boolean listenToInsertTracker = false;
        boolean listenToExtractEntities = false;
        boolean listenToInsertEntities = false;
        LithiumStackList thisStackList = InventoryHelper.getLithiumStackList(this);
        if (this.extractionMode != HopperCachingState.BlockInventory.BLOCK_STATE && thisStackList.getFullSlots() != thisStackList.size()) {
            if (this.extractionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
                ComparatorTracker comparatorTracker;
                blockInventory = this.extractBlockInventory;
                if (this.extractStackList == null || !(blockInventory instanceof InventoryChangeTracker)) return;
                if (this.extractStackList.maybeSendsComparatorUpdatesOnFailedExtract() && (!(blockInventory instanceof ComparatorTracker) || (comparatorTracker = (ComparatorTracker)blockInventory).lithium$hasAnyComparatorNearby())) return;
                listenToExtractTracker = true;
            } else {
                if (this.extractionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) return;
                if (TransferApiHelper.canHopperInteractWithApiInventory((HopperBlockEntity)this, this.getBlockState(), true)) {
                    return;
                }
                listenToExtractEntities = true;
            }
        }
        if (this.insertionMode != HopperCachingState.BlockInventory.BLOCK_STATE && 0 < thisStackList.getOccupiedSlots()) {
            if (this.insertionMode == HopperCachingState.BlockInventory.REMOVAL_TRACKING_BLOCK_ENTITY) {
                blockInventory = this.insertBlockInventory;
                if (this.insertStackList == null || !(blockInventory instanceof InventoryChangeTracker)) return;
                listenToInsertTracker = true;
            } else {
                if (this.insertionMode != HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) return;
                if (TransferApiHelper.canHopperInteractWithApiInventory((HopperBlockEntity)this, this.getBlockState(), false)) {
                    return;
                }
                listenToInsertEntities = true;
            }
        }
        if (listenToExtractTracker) {
            ((InventoryChangeTracker)this.extractBlockInventory).listenForContentChangesOnce(this.extractStackList, this);
        }
        if (listenToInsertTracker) {
            ((InventoryChangeTracker)this.insertBlockInventory).listenForContentChangesOnce(this.insertStackList, this);
        }
        if (listenToInsertEntities) {
            if (this.insertInventoryEntityTracker == null) {
                return;
            }
            this.insertInventoryEntityTracker.listenToEntityMovementOnce(this);
        }
        if (listenToExtractEntities) {
            if (this.extractInventoryEntityTracker == null) {
                return;
            }
            this.extractInventoryEntityTracker.listenToEntityMovementOnce(this);
            if (this.collectItemEntityTracker == null) {
                return;
            }
            this.collectItemEntityTracker.listenToEntityMovementOnce(this);
        }
        thisTracker.listenForContentChangesOnce(thisStackList, this);
        thisSleepingBlockEntity.lithium$startSleeping();
    }

    @Override
    public void lithium$handleInventoryContentModified(Container inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }

    @Override
    public void lithium$handleInventoryRemoved(Container inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
        if (inventory == this.insertBlockInventory) {
            this.invalidateBlockInsertionData();
        }
        if (inventory == this.extractBlockInventory) {
            this.invalidateBlockExtractionData();
        }
        if (inventory == this) {
            this.invalidateCachedData();
        }
    }

    @Override
    public boolean lithium$handleComparatorAdded(Container inventory) {
        HopperBlockEntityMixin hopperBlockEntityMixin;
        if (inventory == this.extractBlockInventory && (hopperBlockEntityMixin = this) instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
            return true;
        }
        return false;
    }

    @Override
    public void lithium$handleEntityMovement(Object category) {
        HopperBlockEntityMixin hopperBlockEntityMixin = this;
        if (hopperBlockEntityMixin instanceof SleepingBlockEntity) {
            SleepingBlockEntity sleepingBlockEntity = (SleepingBlockEntity)((Object)hopperBlockEntityMixin);
            sleepingBlockEntity.wakeUpNow();
        }
    }
}

