/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.experimental.entity.block_caching.block_touching;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Set;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlagHolder;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.tracking.VicinityCache;
import net.caffeinemc.mods.lithium.common.tracking.VicinityCacheProvider;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements VicinityCacheProvider {
    @Inject(method={"checkInsideBlocks(Ljava/util/List;Ljava/util/Set;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;makeBoundingBox(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/AABB;")}, cancellable=true)
    private void cancelIfSkippable(List<?> movementList, Set<BlockState> touchedBlocks, CallbackInfo ci) {
        VicinityCache bc;
        if (movementList.size() != 1) {
            return;
        }
        if (!(this instanceof ServerPlayer) && (bc = this.getUpdatedVicinityCache((Entity)this)).canSkipBlockTouching()) {
            ci.cancel();
        }
    }

    @Inject(method={"checkInsideBlocks(Ljava/util/List;Ljava/util/Set;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;deflate(D)Lnet/minecraft/world/phys/AABB;")})
    private void assumeNoTouchableBlock(CallbackInfo ci) {
        VicinityCache bc = this.lithium$getVicinityCache();
        if (bc.isTracking()) {
            bc.setCanSkipBlockTouching(true);
        }
    }

    @Inject(method={"checkInsideBlocks(Ljava/util/List;Ljava/util/Set;)V"}, at={@At(value="RETURN")})
    private void checkTouchableBlock(CallbackInfo ci, @Local(argsOnly=true) Set<BlockState> set) {
        VicinityCache bc = this.lithium$getVicinityCache();
        if (bc.canSkipBlockTouching()) {
            for (BlockState blockState : set) {
                if (0 == (((BlockStateFlagHolder)blockState).lithium$getAllFlags() & 1 << BlockStateFlags.ENTITY_TOUCHABLE.getIndex())) continue;
                bc.setCanSkipBlockTouching(false);
                break;
            }
        }
    }
}

