/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.util.block_tracking;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.block.BlockCountingSection;
import net.caffeinemc.mods.lithium.common.block.BlockListeningSection;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlagHolder;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.block.TrackedBlockStatePredicate;
import net.caffeinemc.mods.lithium.common.tracking.block.ChunkSectionChangeCallback;
import net.caffeinemc.mods.lithium.common.tracking.block.SectionedBlockChangeTracker;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunkSection.class})
public abstract class LevelChunkSectionMixin
implements BlockCountingSection,
BlockListeningSection {
    @Shadow
    @Final
    private PalettedContainer<BlockState> states;
    @Unique
    private short[] countsByFlag = null;
    @Unique
    private ChunkSectionChangeCallback changeListener;

    @Unique
    private static void addToFlagCount(short[] countsByFlag, BlockState state, short change) {
        int i;
        int flags = ((BlockStateFlagHolder)state).lithium$getAllFlags();
        while ((i = Integer.numberOfTrailingZeros(flags)) < 32 && i < countsByFlag.length) {
            int n = i;
            countsByFlag[n] = (short)(countsByFlag[n] + change);
            flags &= ~(1 << i);
        }
    }

    @Override
    public boolean lithium$mayContainAny(TrackedBlockStatePredicate trackedBlockStatePredicate) {
        if (this.countsByFlag == null) {
            this.fastInitClientCounts();
        }
        return this.countsByFlag[trackedBlockStatePredicate.getIndex()] != 0;
    }

    @Unique
    private void fastInitClientCounts() {
        this.countsByFlag = new short[BlockStateFlags.NUM_TRACKED_FLAGS];
        for (TrackedBlockStatePredicate trackedBlockStatePredicate : BlockStateFlags.TRACKED_FLAGS) {
            if (!this.states.maybeHas((Predicate)trackedBlockStatePredicate)) continue;
            this.countsByFlag[trackedBlockStatePredicate.getIndex()] = 4096;
        }
    }

    @Redirect(method={"recalcBlockCounts()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer;count(Lnet/minecraft/world/level/chunk/PalettedContainer$CountConsumer;)V"))
    private void initFlagCounters(PalettedContainer<BlockState> palettedContainer, PalettedContainer.CountConsumer<BlockState> consumer) {
        palettedContainer.count((state, count) -> {
            consumer.accept(state, count);
            LevelChunkSectionMixin.addToFlagCount(this.countsByFlag, state, (short)count);
        });
    }

    @Inject(method={"recalcBlockCounts()V"}, at={@At(value="HEAD")})
    private void createFlagCounters(CallbackInfo ci) {
        this.countsByFlag = new short[BlockStateFlags.NUM_TRACKED_FLAGS];
    }

    @Inject(method={"read(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="HEAD")})
    private void resetData(FriendlyByteBuf buf, CallbackInfo ci) {
        this.countsByFlag = null;
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFluidState()Lnet/minecraft/world/level/material/FluidState;", ordinal=0)})
    private void updateFlagCounters(int x, int y, int z, BlockState newState, boolean lock, CallbackInfoReturnable<BlockState> cir, @Local(ordinal=1) BlockState oldState) {
        this.lithium$trackBlockStateChange(newState, oldState);
        if (this.changeListener != null) {
            this.changeListener.onBlockChange(this);
        }
    }

    @Override
    public void lithium$trackBlockStateChange(BlockState newState, BlockState oldState) {
        int flagIndex;
        short[] countsByFlag = this.countsByFlag;
        if (countsByFlag == null) {
            return;
        }
        int prevFlags = ((BlockStateFlagHolder)oldState).lithium$getAllFlags();
        int flags = ((BlockStateFlagHolder)newState).lithium$getAllFlags();
        int flagsXOR = prevFlags ^ flags;
        while ((flagIndex = Integer.numberOfTrailingZeros(flagsXOR)) < 32 && flagIndex < countsByFlag.length) {
            int flagBit = 1 << flagIndex;
            if ((flagsXOR & flagBit) != 0) {
                int n = flagIndex;
                countsByFlag[n] = (short)(countsByFlag[n] + (short)(1 - ((prevFlags >>> flagIndex & 1) << 1)));
            }
            flagsXOR &= ~flagBit;
        }
    }

    @Override
    public void lithium$addToCallback(SectionedBlockChangeTracker tracker, long sectionPos, Level world) {
        if (this.changeListener == null) {
            if (sectionPos == Long.MIN_VALUE || world == null) {
                throw new IllegalArgumentException("Expected world and section pos during intialization!");
            }
            this.changeListener = ChunkSectionChangeCallback.create(sectionPos, world);
        }
        this.changeListener.addTracker(tracker);
    }

    @Override
    public void lithium$removeFromCallback(SectionedBlockChangeTracker tracker) {
        if (this.changeListener != null) {
            this.changeListener.removeTracker(tracker);
        }
    }
}

