/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.WidgetContainerScreen;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.packedup.BackpackIconRenderer;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.packets.PacketOpenBag;
import com.supermartijn642.packedup.screen.BackpackContainerScreen;
import com.supermartijn642.packedup.screen.customization.BackpackCustomizationScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class PackedUpClient {
    public static KeyMapping OPEN_BAG_KEY;

    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"packedup");
        handler.registerContainerScreen(() -> PackedUp.container, container -> WidgetContainerScreen.of((Widget)new BackpackContainerScreen(), (BaseContainer)container, (boolean)true));
        handler.registerItemModelType("icon_renderer", BackpackIconRenderer.CODEC);
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent e) {
        OPEN_BAG_KEY = new KeyMapping("packedup.keys.openbag", 79, "packedup.keys.category");
        e.register(OPEN_BAG_KEY);
        NeoForge.EVENT_BUS.addListener(PackedUpClient::onKey);
    }

    public static void openBackpackRenameScreen(InteractionHand hand) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new BackpackCustomizationScreen(hand)));
    }

    public static void onKey(InputEvent.Key e) {
        if (OPEN_BAG_KEY != null && OPEN_BAG_KEY.consumeClick() && ClientUtils.getWorld() != null && ClientUtils.getMinecraft().screen == null) {
            PackedUp.CHANNEL.sendToServer((BasePacket)new PacketOpenBag());
        }
    }

    public static Component getKeyBindCharacter() {
        return OPEN_BAG_KEY == null || OPEN_BAG_KEY.getKey().getValue() == -1 ? null : OPEN_BAG_KEY.getKey().getDisplayName();
    }
}

