/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.screen.customization;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.ItemBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.packets.PacketSetIcon;
import com.supermartijn642.packedup.screen.customization.BackpackCustomizationScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class IconSelectionScreen
extends ItemBaseWidget {
    private static final ResourceLocation SLOT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"textures/gui/slot.png");
    private static final ResourceLocation SLOT_HIGHLIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"packedup", (String)"textures/gui/slot_highlight.png");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"packedup", (String)"textures/gui/preview_frame.png");
    private static final Component TITLE = TextComponents.translation((String)"packedup.icon_selection_screen.icon.title").get();
    private final InteractionHand hand;

    public IconSelectionScreen(InteractionHand hand) {
        super(0, 0, 176, 151, () -> ClientUtils.getPlayer().getItemInHand(hand), s -> !s.isEmpty() && s.getItem() instanceof BackpackItem);
        this.hand = hand;
    }

    public Component getNarrationMessage(ItemStack stack) {
        return TITLE;
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY, ItemStack stack) {
        ScreenUtils.drawTexture((ResourceLocation)BACKGROUND_TEXTURE, (PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        IconSelectionScreen.forEachSlot((x, y, index) -> {
            if (mouseX >= x && mouseX < x + 18 && mouseY >= y && mouseY < y + 18) {
                ScreenUtils.drawTexture((ResourceLocation)SLOT_HIGHLIGHT_TEXTURE, (PoseStack)context.poseStack(), (float)(x - 1), (float)(y - 1), (float)20.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.5f, (float)1.0f);
            }
        });
        super.renderBackground(context, mouseX, mouseY, (Object)stack);
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY, ItemStack stack) {
        ItemStack icon = BackpackItem.getIcon(stack);
        Holder hoveredStack = new Holder();
        Inventory inventory = ClientUtils.getPlayer().getInventory();
        IconSelectionScreen.forEachSlot((x, y, index) -> {
            ItemStack item = inventory.getItem(index);
            ScreenUtils.drawItem((PoseStack)context.poseStack(), (ItemStack)item, (Level)ClientUtils.getWorld(), (int)(x + 1), (int)(y + 1));
            if (!icon.isEmpty() && ItemStack.isSameItem((ItemStack)icon, (ItemStack)item)) {
                ScreenUtils.drawTexture((ResourceLocation)SLOT_HIGHLIGHT_TEXTURE, (PoseStack)context.poseStack(), (float)(x - 1), (float)(y - 1), (float)20.0f, (float)20.0f, (float)0.5f, (float)0.0f, (float)0.5f, (float)1.0f);
            }
            if (mouseX >= x && mouseX < x + 18 && mouseY >= y && mouseY < y + 18) {
                hoveredStack.set((Object)item);
            }
        });
        context.poseStack().pushPose();
        context.poseStack().translate(67.0f, 7.0f, 0.0f);
        context.poseStack().scale(2.625f, 2.625f, 1.0f);
        ItemStack preview = stack;
        if (hoveredStack.get() != null) {
            preview = preview.copy();
            BackpackItem.setIcon(preview, (ItemStack)hoveredStack.get());
        }
        ScreenUtils.drawItem((PoseStack)context.poseStack(), (ItemStack)preview, (Level)ClientUtils.getWorld(), (int)0, (int)0);
        context.poseStack().popPose();
        super.render(context, mouseX, mouseY, (Object)stack);
    }

    protected boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled, ItemStack stack) {
        if (!hasBeenHandled && button == 0) {
            Holder hoveredStack = new Holder();
            Inventory inventory = ClientUtils.getPlayer().getInventory();
            IconSelectionScreen.forEachSlot((x, y, index) -> {
                if (mouseX >= x && mouseX < x + 18 && mouseY >= y && mouseY < y + 18) {
                    hoveredStack.set((Object)inventory.getItem(index));
                }
            });
            if (hoveredStack.get() != null) {
                PackedUp.CHANNEL.sendToServer((BasePacket)new PacketSetIcon(this.hand, (ItemStack)hoveredStack.get()));
                ClientUtils.getMinecraft().setScreen((Screen)WidgetScreen.of((Widget)new BackpackCustomizationScreen(this.hand)));
                hasBeenHandled = true;
            }
        }
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled, (Object)stack);
    }

    protected boolean keyPressed(int keyCode, boolean hasBeenHandled, ItemStack object) {
        if (!hasBeenHandled && (ClientUtils.getMinecraft().options.keyInventory.matches(keyCode, 0) || keyCode == 256)) {
            ClientUtils.getMinecraft().setScreen((Screen)WidgetScreen.of((Widget)new BackpackCustomizationScreen(this.hand)));
            hasBeenHandled = true;
        }
        return super.keyPressed(keyCode, hasBeenHandled, (Object)object);
    }

    private static void forEachSlot(SlotFunction function) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int x = 7 + column * 18;
                int y = 68 + row * 18;
                function.apply(x, y, row * 9 + column + 9);
            }
        }
        for (int column = 0; column < 9; ++column) {
            int x = 7 + column * 18;
            int y = 126;
            function.apply(x, y, column);
        }
    }

    private static interface SlotFunction {
        public void apply(int var1, int var2, int var3);
    }
}

