/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup.storage;

import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.storage.BackpackStorageManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class BackpackInventory {
    private final boolean remote;
    private final ArrayList<ItemStack> stacks = new ArrayList();
    private final int inventoryIndex;
    public Set<Integer> bagsInThisBag = new HashSet<Integer>();
    public Set<Integer> bagsDirectlyInThisBag = new HashSet<Integer>();
    public Set<Integer> bagsThisBagIsIn = new HashSet<Integer>();
    public Set<Integer> bagsThisBagIsDirectlyIn = new HashSet<Integer>();
    public int layer;

    public BackpackInventory(boolean remote, int inventoryIndex, int slots, Set<Integer> bagsInThisBag, Set<Integer> bagsThisBagIsIn, int layer) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
        for (int a = 0; a < slots; ++a) {
            this.stacks.add(ItemStack.EMPTY);
        }
        this.bagsInThisBag.addAll(bagsInThisBag);
        this.bagsThisBagIsIn.addAll(bagsThisBagIsIn);
        this.layer = layer;
    }

    public BackpackInventory(boolean remote, int inventoryIndex, int slots) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
        for (int a = 0; a < slots; ++a) {
            this.stacks.add(ItemStack.EMPTY);
        }
    }

    public BackpackInventory(boolean remote, int inventoryIndex) {
        this.remote = remote;
        this.inventoryIndex = inventoryIndex;
    }

    public int getInventoryIndex() {
        return this.inventoryIndex;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.stacks.get(slot);
    }

    public ItemStack extractItem(int slot, int amount) {
        ItemStack stack = this.stacks.get(slot);
        int count = Math.min(amount, stack.getCount());
        ItemStack result = stack.copy();
        stack.shrink(count);
        if (!this.remote && result.getItem() instanceof BackpackItem && result.has(BackpackItem.INVENTORY_ID)) {
            int index = (Integer)result.get(BackpackItem.INVENTORY_ID);
            boolean contains = false;
            for (ItemStack stack1 : this.stacks) {
                if (!(stack1.getItem() instanceof BackpackItem) || !stack1.has(BackpackItem.INVENTORY_ID) || (Integer)stack1.get(BackpackItem.INVENTORY_ID) != index) continue;
                contains = true;
                break;
            }
            if (!contains) {
                BackpackStorageManager.onExtract(index, this.inventoryIndex);
            }
        }
        result.setCount(count);
        return result;
    }

    public boolean isItemValid(ItemStack stack) {
        ItemContainerContents container;
        if (stack.getItem() instanceof BackpackItem && !this.isBagAllowed(stack)) {
            return false;
        }
        return !(stack.getItem() instanceof BlockItem) || !(((BlockItem)stack.getItem()).getBlock() instanceof ShulkerBoxBlock) || !stack.has(DataComponents.CONTAINER) || (container = (ItemContainerContents)stack.get(DataComponents.CONTAINER)) == null || !container.stream().anyMatch(stack1 -> stack1.getItem() instanceof BackpackItem);
    }

    private static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public void save(Path path, HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("stacks", this.stacks.size());
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            compound.put("stack" + slot, this.stacks.get(slot).saveOptional(provider));
        }
        compound.putIntArray("bagsInThisBag", (List)Lists.newArrayList(this.bagsInThisBag));
        compound.putIntArray("bagsThisBagIsIn", (List)Lists.newArrayList(this.bagsThisBagIsIn));
        compound.putInt("layer", this.layer);
        compound.putInt("version", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        try {
            NbtIo.write((CompoundTag)compound, (Path)path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(Path path, HolderLookup.Provider provider) {
        CompoundTag compound;
        try {
            compound = NbtIo.read((Path)path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int dataVersion = compound.contains("version", 3) ? compound.getInt("version") : 3700;
        this.stacks.clear();
        int size = compound.contains("stacks") ? compound.getInt("stacks") : (compound.contains("rows") ? compound.getInt("rows") * 9 : compound.getInt("slots"));
        for (int slot = 0; slot < size; ++slot) {
            CompoundTag tag = compound.getCompound("stack" + slot);
            tag = (CompoundTag)DataFixers.getDataFixer().update(References.ITEM_STACK, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag), dataVersion, SharedConstants.getCurrentVersion().getDataVersion().getVersion()).getValue();
            this.stacks.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag));
        }
        this.bagsInThisBag.clear();
        Arrays.stream(compound.getIntArray("bagsInThisBag")).forEach(this.bagsInThisBag::add);
        this.bagsThisBagIsIn.clear();
        Arrays.stream(compound.getIntArray("bagsThisBagIsIn")).forEach(this.bagsThisBagIsIn::add);
        this.layer = compound.getInt("layer");
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int index;
        ItemStack oldStack = this.stacks.get(slot);
        this.stacks.set(slot, ItemStack.EMPTY);
        if (!this.remote && oldStack.getItem() instanceof BackpackItem && oldStack.has(BackpackItem.INVENTORY_ID)) {
            index = (Integer)oldStack.get(BackpackItem.INVENTORY_ID);
            boolean contains = false;
            for (ItemStack stack1 : this.stacks) {
                if (!(stack1.getItem() instanceof BackpackItem) || !stack1.has(BackpackItem.INVENTORY_ID) || (Integer)stack1.get(BackpackItem.INVENTORY_ID) != index) continue;
                contains = true;
                break;
            }
            if (!contains) {
                BackpackStorageManager.onExtract(index, this.inventoryIndex);
            }
        }
        this.stacks.set(slot, stack);
        if (!this.remote && stack.getItem() instanceof BackpackItem && stack.has(BackpackItem.INVENTORY_ID) && !this.bagsDirectlyInThisBag.contains(index = ((Integer)stack.get(BackpackItem.INVENTORY_ID)).intValue())) {
            BackpackStorageManager.onInsert(index, this.inventoryIndex);
        }
    }

    public void adjustSize(BackpackType type) {
        while (this.stacks.size() < type.getSlots()) {
            this.stacks.add(ItemStack.EMPTY);
        }
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    private boolean isBagAllowed(ItemStack bag) {
        if (BackpackStorageManager.maxLayers.get() != -1 && this.layer >= BackpackStorageManager.maxLayers.get()) {
            return false;
        }
        if (!bag.has(BackpackItem.INVENTORY_ID)) {
            return true;
        }
        int index = (Integer)bag.get(BackpackItem.INVENTORY_ID);
        return index != this.inventoryIndex && !this.bagsThisBagIsIn.contains(index);
    }
}

