/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetConfig;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureEndRodChains
extends Feature<StructureTargetConfig> {
    private static final Set<Block> ALLOWED_ATTACHEMENT_BLOCKS = Set.of(Blocks.CHAIN, Blocks.OBSIDIAN, Blocks.CRYING_OBSIDIAN, Blocks.PURPUR_BLOCK, Blocks.PURPUR_PILLAR, Blocks.PURPUR_SLAB, Blocks.PURPUR_STAIRS);

    public StructureEndRodChains(Codec<StructureTargetConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<StructureTargetConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < ((StructureTargetConfig)context.config()).attempts; ++i) {
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(7) - 3, -1, context.random().nextInt(7) - 3);
            if (!world.getBlockState((BlockPos)mutable).isAir()) continue;
            int length = 0;
            boolean exitEarly = false;
            while (mutable.getY() < world.getMaxY() - 3 && length < context.random().nextInt(context.random().nextInt(context.random().nextInt(8) + 1) + 1) + 1) {
                if (world.isEmptyBlock((BlockPos)mutable)) {
                    BlockState belowBlockstate = world.getBlockState(mutable.below());
                    Block belowBlock = belowBlockstate.getBlock();
                    if (ALLOWED_ATTACHEMENT_BLOCKS.contains(belowBlock)) {
                        world.setBlock((BlockPos)mutable, Blocks.CHAIN.defaultBlockState(), 2);
                        if (belowBlock instanceof SlabBlock) {
                            world.setBlock(mutable.below(), (BlockState)belowBlockstate.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE), 3);
                        }
                        ++length;
                    }
                } else {
                    exitEarly = true;
                }
                mutable.move(Direction.UP);
            }
            if (exitEarly || mutable.getY() == world.getMaxY() - 3 || !(context.random().nextFloat() < 0.475f) || !world.isEmptyBlock(mutable.above()) || !world.isEmptyBlock((BlockPos)mutable)) continue;
            world.setBlock((BlockPos)mutable, (BlockState)Blocks.END_ROD.defaultBlockState().setValue((Property)EndRodBlock.FACING, (Comparable)Direction.UP), 2);
        }
        return true;
    }
}

