/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.options;

import com.teamresourceful.resourcefulconfig.api.annotations.ConfigObject;
import java.util.function.Predicate;

public enum EntryType {
    BYTE(type -> type == Byte.TYPE || type == Byte.class),
    SHORT(type -> type == Short.TYPE || type == Short.class),
    INTEGER(type -> type == Integer.TYPE || type == Integer.class),
    LONG(type -> type == Long.TYPE || type == Long.class),
    FLOAT(type -> type == Float.TYPE || type == Float.class),
    DOUBLE(type -> type == Double.TYPE || type == Double.class),
    BOOLEAN(type -> type == Boolean.TYPE || type == Boolean.class),
    STRING(type -> type == String.class),
    ENUM(Class::isEnum),
    OBJECT(type -> type.isAnnotationPresent(ConfigObject.class));

    private final Predicate<Class<?>> predicate;

    private EntryType(Predicate<Class<?>> predicate) {
        this.predicate = predicate;
    }

    public boolean test(Class<?> type) {
        return this.predicate.test(type);
    }

    public boolean isAllowedInArrays() {
        return this != OBJECT;
    }

    public boolean mustBeFinal() {
        return this == OBJECT;
    }
}

