/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.modifier;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.service.CoreServices;

public interface LootTableModifier {
    public static LootTableModifier getInstance() {
        return CoreServices.load(LootTableModifier.class);
    }

    public void addItems(RegistryObject<Item> var1, float var2, Supplier<Float> var3, ResourceKey<LootTable> ... var4);

    public void addItems(RegistryObject<Item> var1, float var2, float var3, Supplier<Float> var4, ResourceKey<LootTable> ... var5);

    public void addBlocks(RegistryObject<Block> var1, float var2, Supplier<Float> var3, ResourceKey<LootTable> ... var4);

    public void addBlocks(RegistryObject<Block> var1, float var2, float var3, Supplier<Float> var4, ResourceKey<LootTable> ... var5);

    public void addItems(ItemLike var1, float var2, Supplier<Float> var3, ResourceKey<LootTable> ... var4);

    public void addItems(ItemLike var1, float var2, float var3, Supplier<Float> var4, ResourceKey<LootTable> ... var5);

    public static LootPool.Builder lootPool(ItemLike item, float chance, float amount) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)LootTableModifier.value(chance))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)amount)));
    }

    public static LootPool.Builder lootPool(ItemLike item, float chance, float minAmount, float maxAmount) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)LootTableModifier.value(chance))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minAmount, (float)maxAmount)));
    }

    public static float value(float chance) {
        return Math.min(1.0f, Math.max(0.0f, chance));
    }
}

