/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resourcelibrary.registration;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.xstopho.resourcelibrary.LibConstants;
import net.xstopho.resourcelibrary.registration.ResourcePackRegistry;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="resourcelibrary", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class NeoForgeResourcePackRegistry
implements ResourcePackRegistry {
    private String modId;
    private static final Map<ResourceLocation, Component> RESOURCE_PACKS = new HashMap<ResourceLocation, Component>();

    @Override
    public ResourcePackRegistry setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public void register(@NotNull ResourceLocation packLocation, @NotNull String packDisplayName) {
        ResourceLocation packPath = ResourceLocation.fromNamespaceAndPath((String)packLocation.getNamespace(), (String)("resourcepacks/" + packLocation.getPath()));
        if (!RESOURCE_PACKS.containsKey(packPath)) {
            RESOURCE_PACKS.put(packPath, (Component)Component.literal((String)packDisplayName));
        } else {
            LibConstants.LOG.error("Resourcepack '{}' with location '{}' is already registered!", (Object)packDisplayName, (Object)packLocation);
        }
    }

    @SubscribeEvent
    public static void registerResourcePacks(AddPackFindersEvent event) {
        RESOURCE_PACKS.forEach((location, component) -> {
            event.addPackFinders(location, PackType.CLIENT_RESOURCES, component, PackSource.BUILT_IN, false, Pack.Position.TOP);
            LibConstants.LOG.info("Registered Built-In Resourcepack: {}", (Object)component.getString());
        });
    }
}

