/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinTemplate;
import atomicstryker.ruins.common.RuinsMod;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

class CommandTestTemplate {
    public static RuinTemplate parsedRuin;
    public static final LiteralArgumentBuilder<CommandSourceStack> BUILDER;

    CommandTestTemplate() {
    }

    private static void execute(ServerPlayer source, String input) {
        ServerPlayer sender = source;
        String[] args = input == null ? new String[]{} : input.split(" ");
        RuinsMod.LOGGER.info("called test command with input [{}], args count {}", (Object)input, (Object)args.length);
        int xpos = (int)sender.getX();
        int ypos = (int)sender.getY();
        int zpos = (int)sender.getZ();
        if (args.length < 4) {
            if (args.length < 1) {
                if (parsedRuin != null) {
                    Level world = sender.getCommandSenderWorld();
                    parsedRuin.doBuild(world, world.random, xpos, ypos, zpos, 0, true, false);
                    parsedRuin = null;
                } else {
                    sender.displayClientMessage((Component)Component.literal((String)"You need to use the command with the target template name, eg. /testruin beach/LightHouse"), false);
                }
            } else {
                CommandTestTemplate.tryBuild((Player)sender, args, xpos, ypos, zpos, true);
            }
        } else {
            try {
                if (args[2].equals("_")) {
                    int x = Integer.valueOf(args[1]);
                    int z = Integer.valueOf(args[3]);
                    CommandTestTemplate.tryBuild((Player)sender, args, x, -1, z, true);
                } else {
                    int x = Integer.valueOf(args[1]);
                    int y = Integer.valueOf(args[2]);
                    int z = Integer.valueOf(args[3]);
                    CommandTestTemplate.tryBuild((Player)sender, args, x, y, z, true);
                }
            }
            catch (NumberFormatException e) {
                sender.displayClientMessage((Component)Component.literal((String)"Invalid coordinates specified"), false);
            }
        }
    }

    private static void tryBuild(Player sender, String[] args, int x, int y, int z, boolean is_player) {
        block11: {
            File file;
            Object target = args[0];
            if (!((String)target).contains("/")) {
                target = "templateparser/" + (String)target;
            }
            if ((file = new File(RuinsMod.getMinecraftBaseDir(), "config/ruins_config/" + (String)target + ".tml")).exists() && file.canWrite()) {
                try {
                    parsedRuin = new RuinTemplate(file.getCanonicalPath(), file.getName(), is_player);
                    int rotation = args.length > 4 ? Integer.parseInt(args[4]) : 0;
                    boolean ignore_ceiling = args.length > 5 && Boolean.parseBoolean(args[5]);
                    Level world = sender.getCommandSenderWorld();
                    if (parsedRuin != null) {
                        if (y < world.getMinY()) {
                            int ceiling = world.getHeight();
                            for (y = ceiling - 1; y > world.getMinY(); --y) {
                                BlockPos pos = new BlockPos(x, y, z);
                                BlockState b = world.getBlockState(pos);
                                if (parsedRuin.isIgnoredBlock(b)) continue;
                                if (parsedRuin.isAcceptableSurface(world, b, pos)) break;
                                sender.displayClientMessage((Component)Component.literal((String)"Could not find acceptable Y coordinate"), false);
                                return;
                            }
                            ++y;
                        }
                        if (parsedRuin.doBuild(world, world.random, x, y, z, rotation, is_player, ignore_ceiling) > world.getMinY()) {
                            parsedRuin = null;
                        } else {
                            sender.displayClientMessage((Component)Component.literal((String)"EventRuinTemplateSpawn returned as cancelled, not building that."), false);
                        }
                        break block11;
                    }
                    sender.displayClientMessage((Component)Component.literal((String)("Could not parse Ruin of file " + String.valueOf(file))), false);
                }
                catch (RuinTemplate.IncompatibleModException e) {
                    sender.displayClientMessage((Component)Component.literal((String)e.getMessage()), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                sender.displayClientMessage((Component)Component.literal((String)("Could not open/write file " + String.valueOf(file))), false);
            }
        }
    }

    static {
        BUILDER = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"testruin").requires(caller -> caller.hasPermission(2))).then(Commands.argument((String)"input", (ArgumentType)StringArgumentType.greedyString()).executes(caller -> {
            CommandTestTemplate.execute(((CommandSourceStack)caller.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)caller, (String)"input"));
            return 1;
        }))).executes(caller -> {
            CommandTestTemplate.execute(((CommandSourceStack)caller.getSource()).getPlayerOrException(), null);
            return 1;
        });
    }
}

