/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.EventRuinTemplateSpawn;
import atomicstryker.ruins.common.RuinData;
import atomicstryker.ruins.common.RuinRuleProcess;
import atomicstryker.ruins.common.RuinTemplateLayer;
import atomicstryker.ruins.common.RuinTemplateRule;
import atomicstryker.ruins.common.RuinVennCriterion;
import atomicstryker.ruins.common.RuinsMod;
import atomicstryker.ruins.common.RuleStringNbtHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;

public class RuinTemplate {
    private static final Pattern patternRuleRaw = Pattern.compile("(?:[^*=^]*\\*)?(?:rule[^=^]*)?[=^]");
    private static final Pattern patternRule = Pattern.compile("(?:([1-9]\\d{0,4})\\*)?(rule[^=^]*)?([=^])(?:([1-9]\\d{0,4})\\*)?(.*)");
    private static Set<String> installed_mods_ = null;
    private final String name;
    private final VariantRuleset variantRuleset;
    private final ArrayList<RuinTemplateLayer> layers;
    private final HashSet<String> biomes;
    private final boolean debugging;
    private final ArrayList<AdjoiningTemplateData> adjoiningTemplates;
    private final Set<String> acceptedDimensions = new HashSet<String>();
    public int uniqueMinDistance = 0;
    public int spawnMinDistance = 0;
    public int spawnMaxDistance = Integer.MAX_VALUE;
    private BlockState[] acceptedSurfaces;
    private BlockState[] deniedSurfaces;
    private int height = 0;
    private int width = 0;
    private int length = 0;
    private int overhang = 0;
    private int embed = 0;
    private int randomOffMin = 0;
    private int randomOffMax = 0;
    private double weight = 1.0;
    private int leveling = 4;
    private int lbuffer = 0;
    private int w_off = 0;
    private int l_off = 0;
    private boolean preserveWater = false;
    private boolean preserveLava = false;
    private boolean preventRotation = false;
    private final List<BonemealMarker> bonemealMarkers = new ArrayList<BonemealMarker>();

    public RuinTemplate(String filename, String simpleName, boolean debug) throws Exception {
        this.name = simpleName;
        this.debugging = debug;
        ArrayList<String> lines = new ArrayList<String>();
        this.variantRuleset = new VariantRuleset();
        this.layers = new ArrayList();
        this.biomes = new HashSet();
        this.adjoiningTemplates = new ArrayList();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String read = br.readLine();
        while (read != null) {
            lines.add(read);
            read = br.readLine();
        }
        this.parseFile(lines);
        br.close();
    }

    public RuinTemplate(String filename, String simpleName) throws Exception {
        this(filename, simpleName, false);
    }

    public boolean equals(Object o) {
        return o instanceof RuinTemplate && ((RuinTemplate)o).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public double getWeight() {
        return this.weight;
    }

    public HashSet<String> getBiomesToSpawnIn() {
        return this.biomes;
    }

    public boolean isIgnoredBlock(BlockState blockState) {
        return !blockState.isSolid() || this.preserveWater && blockState.is(Blocks.WATER) || this.preserveLava && blockState.is(Blocks.LAVA);
    }

    public boolean isAcceptableSurface(Level world, BlockState blockState, BlockPos pos) {
        for (BlockState b : this.deniedSurfaces) {
            if (blockState != b) continue;
            return false;
        }
        if (this.acceptedSurfaces.length == 0) {
            return blockState.isSolid();
        }
        for (BlockState b : this.acceptedSurfaces) {
            if (blockState != b) continue;
            return true;
        }
        return false;
    }

    public int checkArea(Level world, int xBase, int y, int zBase, int rotate) {
        return this.checkArea(world, xBase, y, zBase, rotate, 0);
    }

    private int checkArea(Level world, int xBase, int y, int zBase, int rotate, int additionalYRangeChecked) {
        Object pos;
        int x = xBase + this.w_off;
        int z = zBase + this.l_off;
        int xDim = this.width;
        int zDim = this.length;
        if (!(this.preventRotation || rotate != 1 && rotate != 3)) {
            x = xBase + this.l_off;
            z = zBase + this.w_off;
            xDim = this.length;
            zDim = this.width;
        }
        int topYguess = y - 1 + this.height + additionalYRangeChecked;
        int minimalCheckedY = y - 1 - this.height - additionalYRangeChecked;
        int[][] heightMap = new int[xDim][zDim];
        int lastX = x + xDim;
        int lastZ = z + zDim;
        for (int ix = x; ix < lastX; ++ix) {
            for (int iz = z; iz < lastZ; ++iz) {
                boolean foundSurface = false;
                for (int iy = topYguess; iy >= minimalCheckedY; --iy) {
                    pos = new BlockPos(ix, iy, iz);
                    BlockState blockState = world.getBlockState((BlockPos)pos);
                    if (this.isIgnoredBlock(blockState)) continue;
                    if (this.isAcceptableSurface(world, blockState, (BlockPos)pos)) {
                        heightMap[ix - x][iz - z] = iy;
                        foundSurface = true;
                        break;
                    }
                    return world.getMinY() - 1;
                }
                if (foundSurface) continue;
                heightMap[ix - x][iz - z] = world.getMinY() - 1;
            }
        }
        double sum = 0.0;
        double vals = 0.0;
        pos = heightMap;
        int n = ((int[][])pos).length;
        for (int i = 0; i < n; ++i) {
            int[] row;
            for (int value : row = pos[i]) {
                if (value <= world.getMinY()) continue;
                vals += 1.0;
                sum += (double)value;
            }
        }
        int newY = vals > (double)world.getMinY() ? (int)Math.round(sum / vals) : y;
        int localOverhang = this.overhang;
        int[][] nArray = heightMap;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int[] row;
            for (int value : row = nArray[i]) {
                if (value < world.getMinY()) {
                    if (--localOverhang >= 0) continue;
                    RuinsMod.LOGGER.debug("overhang fail at [{}|{}|{}]", (Object)x, (Object)newY, (Object)z);
                    return world.getMinY() - 1;
                }
                if (Math.abs(newY - value) <= this.leveling) continue;
                RuinsMod.LOGGER.debug("leveling fail at [{}|{}|{}]: {} > {}", (Object)x, (Object)newY, (Object)z, (Object)Math.abs(newY - value), (Object)this.leveling);
                return world.getMinY() - 1;
            }
        }
        return newY + 1;
    }

    public RuinData getRuinData(int x, int y, int z, int rotate) {
        int zMax;
        int zMin;
        int xMax;
        int xMin;
        int add = 0;
        int y_add = 0;
        if (this.leveling > 0 && this.lbuffer >= 0) {
            add = this.lbuffer;
            y_add = this.leveling;
        }
        if (rotate == 1 || rotate == 3) {
            xMin = x + this.l_off - add;
            xMax = xMin + this.length + add;
            zMin = z + this.w_off - add;
            zMax = zMin + this.width + add;
        } else {
            xMin = x + this.w_off - add;
            xMax = xMin + this.width + add;
            zMin = z + this.l_off - add;
            zMax = zMin + this.length + add;
        }
        return new RuinData(xMin, xMax, Math.max(y - y_add, 0), y + this.height - 1, zMin, zMax, this.name);
    }

    public int doBuild(Level world, RandomSource random, int xBase, int yBase, int zBase, int rotate, boolean is_player, boolean ignore_ceiling) {
        try {
            return this.doBuildNested(world, random, xBase, yBase, zBase, rotate, is_player, ignore_ceiling);
        }
        catch (Exception e) {
            RuinsMod.LOGGER.error("An Exception was thrown while building Ruin: {}", (Object)this.getName());
            System.err.println("Faulty Template name: " + this.getName());
            e.printStackTrace();
            return world.getMinY() - 1;
        }
    }

    private int doBuildNested(Level world, RandomSource random, int xBase, int yBase, int zBase, int rotate, boolean is_player, boolean ignore_ceiling) {
        BlockState fill_block;
        int zDim;
        int z;
        int xDim;
        int x;
        boolean eastwest;
        ArrayList<RuinRuleProcess> laterun = new ArrayList<RuinRuleProcess>();
        ArrayList<RuinRuleProcess> lastrun = new ArrayList<RuinRuleProcess>();
        Iterator<RuinTemplateLayer> layeriter = this.layers.iterator();
        int y_off = -this.embed + (this.randomOffMax > this.randomOffMin ? random.nextInt(this.randomOffMax - this.randomOffMin) + this.randomOffMin : 0);
        int ceiling = world.getHeight();
        int yReturn = Math.max(Math.min(yBase + y_off, ceiling - this.height), world.getMinY());
        int y = yReturn - y_off;
        if (this.preventRotation) {
            rotate = 0;
        }
        if (((EventRuinTemplateSpawn)NeoForge.EVENT_BUS.post((Event)new EventRuinTemplateSpawn(world, this, xBase, yReturn, zBase, rotate, is_player, true))).isCancelled()) {
            RuinsMod.LOGGER.info("Forge Event came back cancelled, no spawn");
            return world.getMinY() - 1;
        }
        if (rotate == 1 || rotate == 3) {
            eastwest = true;
            x = xBase + this.l_off;
            xDim = this.length;
            z = zBase + this.w_off;
            zDim = this.width;
        } else {
            eastwest = false;
            x = xBase + this.w_off;
            xDim = this.width;
            z = zBase + this.l_off;
            zDim = this.length;
        }
        ArrayList<RuinTemplateRule> rules = this.variantRuleset.getVariants(random);
        if (this.leveling > 0 && this.lbuffer >= 0 && (fill_block = this.getLevelingFillBlock(world, xBase, yReturn, zBase)) != null) {
            this.levelSite(world, fill_block, xBase, yReturn, zBase, eastwest, random, rules.get(0));
        }
        while (layeriter.hasNext()) {
            RuinTemplateLayer curlayer = layeriter.next();
            for (int x0 = 0; x0 < this.width; ++x0) {
                for (int z0 = 0; z0 < this.length; ++z0) {
                    int rulenum = curlayer.getRuleAt(x0, z0);
                    int x1 = x0;
                    int z1 = z0;
                    switch (rotate) {
                        case 1: {
                            x1 = xDim - 1 - z0;
                            z1 = x0;
                            break;
                        }
                        case 2: {
                            x1 = xDim - 1 - x0;
                            z1 = zDim - 1 - z0;
                            break;
                        }
                        case 3: {
                            x1 = z0;
                            z1 = zDim - 1 - x0;
                            break;
                        }
                    }
                    RuinTemplateRule curRule = rules.get(rulenum);
                    curRule.doBlock(world, random, new BlockPos(x + x1, y + y_off, z + z1), rotate);
                }
            }
            ++y_off;
        }
        this.doLateRuns(world, random, laterun, lastrun);
        for (BonemealMarker bonemealMarker : this.bonemealMarkers) {
            int grows;
            BlockPos position = bonemealMarker.getPosition();
            BlockState state = world.getBlockState(position);
            Block growable = state.getBlock();
            RuinsMod.LOGGER.info("Now considering bonemeal flag at {}, block: {}", (Object)position, (Object)growable);
            if (!(growable instanceof BonemealableBlock)) continue;
            int count = bonemealMarker.getCount();
            BonemealableBlock igrowable = (BonemealableBlock)growable;
            for (grows = 0; grows < count && igrowable.isValidBonemealTarget((LevelReader)world, position, state); ++grows) {
                igrowable.performBonemeal((ServerLevel)world, world.random, position, state);
                state = world.getBlockState(position);
                growable = state.getBlock();
                if (!(growable instanceof BonemealableBlock)) break;
                igrowable = (BonemealableBlock)growable;
            }
            if (grows <= 0) continue;
            RuinsMod.LOGGER.info("Applied {} bonemeal at {}, now block: {}", (Object)grows, (Object)position, (Object)growable);
        }
        this.bonemealMarkers.clear();
        for (AdjoiningTemplateData ad : this.adjoiningTemplates) {
            RuinsMod.LOGGER.info("Considering to spawn adjoining {} of Ruin {}...", (Object)ad.adjoiningTemplate.getName(), (Object)this.getName());
            float randres = world.random.nextFloat() * 100.0f;
            if (randres < ad.spawnchance) {
                int targetX = xBase + ad.relativeX;
                int targetZ = zBase + ad.relativeZ;
                int newrot = world.random.nextInt(4);
                int targetY = ad.adjoiningTemplate.checkArea(world, targetX, yReturn, targetZ, newrot, ad.acceptableY);
                if (targetY > world.getMinY() && Math.abs(yReturn - targetY) <= ad.acceptableY) {
                    RuinsMod.LOGGER.info("Creating adjoining {} of Ruin {} at [{}|{}|{}], rot:{}", (Object)ad.adjoiningTemplate.getName(), (Object)this.getName(), (Object)targetX, (Object)targetY, (Object)targetZ, (Object)newrot);
                    ad.adjoiningTemplate.doBuild(world, random, targetX, targetY, targetZ, newrot, false, ignore_ceiling);
                    continue;
                }
                RuinsMod.LOGGER.info("Adjoining area around [{}|{}|{}] was rejected, targetY:{}, diff:{}", (Object)targetX, (Object)yReturn, (Object)targetZ, (Object)targetY, (Object)Math.abs(yReturn - targetY));
                continue;
            }
            RuinsMod.LOGGER.info("Spawnchance [%.2f] too low. Random got [%.2f], no spawn", (Object)Float.valueOf(ad.spawnchance), (Object)Float.valueOf(randres));
        }
        NeoForge.EVENT_BUS.post((Event)new EventRuinTemplateSpawn(world, this, xBase, yReturn, zBase, rotate, is_player, false));
        return yReturn;
    }

    private BlockState getLevelingFillBlock(Level world, int x, int y, int z) {
        BlockState fill_block = null;
        int y_end = Math.max(y - this.height, 0) - 1;
        for (int y_surface = y - 1; y_surface > y_end; --y_surface) {
            BlockPos pos = new BlockPos(x, y_surface, z);
            BlockState block = world.getBlockState(pos);
            if (this.isIgnoredBlock(block)) continue;
            if (!this.isAcceptableSurface(world, block, pos)) break;
            fill_block = block;
            break;
        }
        return fill_block;
    }

    private void doLateRuns(Level world, RandomSource random, ArrayList<RuinRuleProcess> laterun, ArrayList<RuinRuleProcess> lastrun) {
        for (RuinRuleProcess rp : laterun) {
            rp.doBlock(world, random);
        }
        for (RuinRuleProcess rp : lastrun) {
            rp.doBlock(world, random);
        }
    }

    private void levelSite(Level world, BlockState fillBlockID, int xBase, int y, int zBase, boolean eastwest, RandomSource random, RuinTemplateRule rule0) {
        int x = xBase + this.w_off - this.lbuffer;
        int z = zBase + this.l_off - this.lbuffer;
        int xDim = this.width + 2 * this.lbuffer;
        int zDim = this.length + 2 * this.lbuffer;
        if (eastwest) {
            x = xBase + this.l_off - this.lbuffer;
            z = zBase + this.w_off - this.lbuffer;
            xDim = this.length + 2 * this.lbuffer;
            zDim = this.width + 2 * this.lbuffer;
        }
        int lastX = x + xDim;
        int lastZ = z + zDim;
        int lastY = y + this.leveling;
        for (int xi = x; xi < lastX; ++xi) {
            for (int zi = z; zi < lastZ; ++zi) {
                int yi;
                for (yi = y - this.leveling; yi < y; ++yi) {
                    BlockPos pos = new BlockPos(xi, yi, zi);
                    if (!this.isIgnoredBlock(world.getBlockState(pos))) continue;
                    world.setBlock(pos, fillBlockID, 2);
                }
                for (yi = y; yi < lastY; ++yi) {
                    rule0.doBlock(world, random, new BlockPos(xi, yi, zi), 0);
                }
            }
        }
    }

    private void parseFile(ArrayList<String> lines) throws Exception {
        this.parseVariables(lines);
        Iterator<String> i = lines.iterator();
        int lineIndex = 0;
        int ruleIndex = 0;
        int groupIndex = 0;
        int groupSize = 0;
        int repeatCountPrevious = 0;
        int variantIndex = 0;
        ParserState parserState = ParserState.PRE_RULE_PHASE;
        while (i.hasNext()) {
            String line = i.next();
            ++lineIndex;
            if (line.startsWith("#") || line.isEmpty()) continue;
            if (line.startsWith("layer")) {
                if (repeatCountPrevious > 1) {
                    int ruleIndexPrevious = ruleIndex;
                    ruleIndex += (repeatCountPrevious - 1) * (ruleIndex - groupIndex + 1);
                    if (this.debugging) {
                        RuinsMod.LOGGER.info("template [{}] line [{}]: duplicating group from rules #{}-#{} ({} times) to create rules #{}-#{}", (Object)this.name, (Object)lineIndex, (Object)groupIndex, (Object)ruleIndexPrevious, (Object)repeatCountPrevious, (Object)(ruleIndexPrevious + 1), (Object)ruleIndex);
                    }
                    repeatCountPrevious = 0;
                }
                parserState = ParserState.POST_RULE_PHASE;
                ArrayList<String> layerlines = new ArrayList<String>();
                line = i.next();
                while (!line.startsWith("endlayer")) {
                    if (line.charAt(0) != '#') {
                        layerlines.add(line);
                    }
                    line = i.next();
                }
                this.layers.add(new RuinTemplateLayer(layerlines, this.width, this.length, this.variantRuleset.size()));
                continue;
            }
            Matcher matcher = patternRule.matcher(line);
            if (matcher.matches()) {
                if (parserState == ParserState.POST_RULE_PHASE) {
                    throw new Exception("Template file problem: A Rule was defined after a layer! Define all rules before the first layer!");
                }
                boolean isFirstRule = parserState == ParserState.PRE_RULE_PHASE;
                boolean hasRepeatCount = matcher.group(1) != null;
                int repeatCount = hasRepeatCount ? Integer.parseInt(matcher.group(1)) : 1;
                boolean hasName = matcher.group(2) != null;
                boolean isVariant = matcher.group(3).equals("^");
                int weight = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 1;
                RuinTemplateRule rule = new RuinTemplateRule(this, matcher.group(5), this.debugging);
                parserState = ParserState.RULE_PHASE;
                if (isVariant) {
                    if (isFirstRule) {
                        RuinsMod.LOGGER.error("template [{}] line [{}]: first rule must start a new variant group (i.e., use = instead of ^)", (Object)this.name, (Object)lineIndex);
                        throw new Exception("Template file problem: First rule cannot join nonexistent variant group!");
                    }
                    if (hasRepeatCount) {
                        RuinsMod.LOGGER.error("template [{}] line [{}]: only first rule variant in a group can have repeat count", (Object)this.name, (Object)lineIndex);
                        throw new Exception("Template file problem: Unexpected repeat count before variant rule group member!");
                    }
                    if (hasName) {
                        ++ruleIndex;
                        variantIndex = 1;
                        if (this.debugging) {
                            RuinsMod.LOGGER.info("template [{}] line [{}]: adding new rule #{} to variant group with rule #{}", (Object)this.name, (Object)lineIndex, (Object)ruleIndex, (Object)groupIndex);
                        }
                        this.variantRuleset.addVariantRule(weight, rule);
                        continue;
                    }
                    if (ruleIndex == groupIndex) {
                        ++groupSize;
                    } else if (variantIndex == groupSize && this.debugging) {
                        RuinsMod.LOGGER.info("template [{}] line [{}]: rule #{} has more variants than first rule in group (rule #{} with {} variants); excess will be ignored", (Object)this.name, (Object)lineIndex, (Object)ruleIndex, (Object)groupIndex, (Object)groupSize);
                    }
                    ++variantIndex;
                    if (this.debugging) {
                        RuinsMod.LOGGER.info("template [{}] line [{}]: adding variant #{} to rule #{}", (Object)this.name, (Object)lineIndex, (Object)variantIndex, (Object)ruleIndex);
                    }
                    this.variantRuleset.addVariant(weight, rule);
                    continue;
                }
                if (repeatCountPrevious > 1) {
                    int ruleIndexPrevious = ruleIndex;
                    ruleIndex += (repeatCountPrevious - 1) * (ruleIndex - groupIndex + 1);
                    if (this.debugging) {
                        RuinsMod.LOGGER.info("template [{}] line [{}]: duplicating variant group from rules #{}-#{} ({} times) to create rules #{}-#{}", (Object)this.name, (Object)lineIndex, (Object)groupIndex, (Object)ruleIndexPrevious, (Object)repeatCountPrevious, (Object)(ruleIndexPrevious + 1), (Object)ruleIndex);
                    }
                }
                groupIndex = ++ruleIndex;
                groupSize = 1;
                repeatCountPrevious = repeatCount;
                variantIndex = 1;
                if (isFirstRule) {
                    if (!hasName) {
                        if (hasRepeatCount) {
                            RuinsMod.LOGGER.error("template [{}] line [{}]: unnamed rule (alternate rule0) cannot have repeat count", (Object)this.name, (Object)lineIndex);
                            throw new Exception("Template file problem: Unexpected repeat count before unnamed rule!");
                        }
                        ruleIndex = 0;
                        groupIndex = 0;
                        if (this.debugging) {
                            RuinsMod.LOGGER.info("template [{}] line [{}]: alternate rule #0 specified", (Object)this.name, (Object)lineIndex);
                        }
                    } else {
                        if (this.debugging) {
                            RuinsMod.LOGGER.info("template [{}] line [{}]: creating default (ruins:null) rule #0", (Object)this.name, (Object)lineIndex);
                        }
                        this.variantRuleset.addVariantGroup(1, 1, new RuinTemplateRule(this, "{Name:\"ruins:null\"}"));
                    }
                } else if (!hasName) {
                    RuinsMod.LOGGER.error("template [{}] line [{}]: unnamed rule (alternate rule0) must appear before all other rules", (Object)this.name, (Object)lineIndex);
                    throw new Exception("Template file problem: Rule name missing!");
                }
                if (this.debugging) {
                    RuinsMod.LOGGER.info("template [{}] line [{}]: creating new rule #{}", (Object)this.name, (Object)lineIndex, (Object)ruleIndex);
                }
                this.variantRuleset.addVariantGroup(repeatCount, weight, rule);
                continue;
            }
            if (!patternRuleRaw.matcher(line).lookingAt()) continue;
            RuinsMod.LOGGER.error("template [{}] line [{}]: invalid rule syntax", (Object)this.name, (Object)lineIndex);
            throw new Exception("Template file problem: Cannot parse rule!");
        }
    }

    private void parseVariables(ArrayList<String> variables) throws Exception {
        if (installed_mods_ == null) {
            installed_mods_ = new HashSet<String>();
            ModList.get().getMods().forEach(mod -> installed_mods_.add(mod.getModId()));
        }
        HashSet included_biomes = new HashSet();
        HashSet excluded_biomes = new HashSet();
        for (String line : variables) {
            RuinTemplate adjTempl;
            String[] vals;
            block30: {
                String[] check;
                if (line.startsWith("#")) continue;
                if (line.startsWith("acceptable_target_blocks")) {
                    String[] check2 = line.split("=");
                    if (check2.length <= 1) continue;
                    this.acceptedSurfaces = this.fromString(check2[1]);
                    continue;
                }
                if (line.startsWith("unacceptable_target_blocks")) {
                    String[] check3 = line.split("=");
                    if (check3.length <= 1) continue;
                    this.deniedSurfaces = this.fromString(check3[1]);
                    continue;
                }
                if (line.startsWith("dimensionsToSpawnIn")) {
                    String[] check4 = line.split("=");
                    if (check4.length <= 1) continue;
                    Collections.addAll(this.acceptedDimensions, check4[1].split(","));
                    continue;
                }
                if (line.startsWith("dimensions")) {
                    String[] check5 = line.split("=");
                    check5 = check5[1].split(",");
                    this.height = Integer.parseInt(check5[0]);
                    this.width = Integer.parseInt(check5[1]);
                    this.length = Integer.parseInt(check5[2]);
                    continue;
                }
                if (line.startsWith("biomesToSpawnIn")) {
                    String[] check6 = line.split("=");
                    if (check6.length <= 1) continue;
                    Collections.addAll(included_biomes, check6[1].split(","));
                    continue;
                }
                if (line.startsWith("biomesToNotSpawnIn")) {
                    String[] check7 = line.split("=");
                    if (check7.length <= 1) continue;
                    Collections.addAll(excluded_biomes, check7[1].split(","));
                    continue;
                }
                if (line.startsWith("weight")) {
                    String[] check8 = line.split("=");
                    this.weight = Math.max(Double.parseDouble(check8[1]), 0.0);
                    continue;
                }
                if (line.startsWith("embed_into_distance")) {
                    String[] check9 = line.split("=");
                    this.embed = Integer.parseInt(check9[1]);
                    continue;
                }
                if (line.startsWith("allowable_overhang")) {
                    String[] check10 = line.split("=");
                    this.overhang = Integer.parseInt(check10[1]);
                    continue;
                }
                if (line.startsWith("max_leveling")) {
                    String[] check11 = line.split("=");
                    this.leveling = Integer.parseInt(check11[1]);
                    continue;
                }
                if (line.startsWith("leveling_buffer")) {
                    String[] check12 = line.split("=");
                    this.lbuffer = Integer.parseInt(check12[1]);
                    if (this.lbuffer <= 5) continue;
                    this.lbuffer = 5;
                    continue;
                }
                if (line.startsWith("preserve_water")) {
                    String[] check13 = line.split("=");
                    if (Integer.parseInt(check13[1]) != 1) continue;
                    this.preserveWater = true;
                    continue;
                }
                if (line.startsWith("preserve_lava")) {
                    String[] check14 = line.split("=");
                    if (Integer.parseInt(check14[1]) != 1) continue;
                    this.preserveLava = true;
                    continue;
                }
                if (line.startsWith("random_height_offset")) {
                    String[] check15 = line.split("=");
                    String[] bounds = check15[1].split(",");
                    this.randomOffMin = Integer.parseInt(bounds[0]);
                    this.randomOffMax = Math.max(this.randomOffMin, Integer.parseInt(bounds[1]));
                    continue;
                }
                if (line.startsWith("uniqueMinDistance")) {
                    String[] check16 = line.split("=");
                    this.uniqueMinDistance = Integer.parseInt(check16[1]);
                    continue;
                }
                if (line.startsWith("spawnMinDistance")) {
                    int value = Integer.parseInt(line.split("=")[1]);
                    this.spawnMinDistance = value > 0 ? value : 0;
                    continue;
                }
                if (line.startsWith("spawnMaxDistance")) {
                    int value = Integer.parseInt(line.split("=")[1]);
                    this.spawnMaxDistance = value > 0 ? value : Integer.MAX_VALUE;
                    continue;
                }
                if (line.startsWith("preventRotation")) {
                    this.preventRotation = Integer.parseInt(line.split("=")[1]) == 1;
                    continue;
                }
                if (line.startsWith("requiredMods")) {
                    String[] check17 = line.split("=");
                    if (check17.length <= 1) continue;
                    if (this.debugging) {
                        RuinsMod.LOGGER.info("checking requiredMods criterion for template \"{}\": specs=\"{}\"", (Object)this.name, (Object)check17[1]);
                    }
                    RuinVennCriterion criterion = null;
                    try {
                        criterion = RuinVennCriterion.parseExpression(check17[1]);
                    }
                    catch (RuntimeException exception) {
                        RuinsMod.LOGGER.error("template [{}]: invalid requiredMods expression [{}]", (Object)this.name, (Object)check17[1], (Object)exception);
                    }
                    if (criterion == null || criterion.isEmpty() || criterion.isSatisfiedBy(installed_mods_)) continue;
                    throw new IncompatibleModException(this.name);
                }
                if (!line.startsWith("adjoining_template") || (check = line.split("=")).length <= 1) continue;
                vals = check[1].split(";");
                File file = new File(RuinsMod.getMinecraftBaseDir(), "config/ruins_config/" + vals[0] + ".tml");
                if (!file.exists() || !file.canRead()) continue;
                adjTempl = null;
                try {
                    adjTempl = new RuinTemplate(file.getCanonicalPath(), file.getName(), false);
                }
                catch (IncompatibleModException e) {
                    if (!this.debugging) break block30;
                    RuinsMod.LOGGER.info("template \"" + this.name + "\" cannot install adjoining template", (Throwable)e);
                }
            }
            if (adjTempl == null) continue;
            AdjoiningTemplateData data = new AdjoiningTemplateData(this);
            data.adjoiningTemplate = adjTempl;
            data.relativeX = Integer.parseInt(vals[1]);
            data.acceptableY = Integer.parseInt(vals[2]);
            data.relativeZ = Integer.parseInt(vals[3]);
            data.spawnchance = vals.length > 4 ? Float.parseFloat(vals[4]) : 100.0f;
            this.adjoiningTemplates.add(data);
        }
        Registry biomeRegistryLookup = RuinsMod.getInstance().getLastLoadedLevel().registryAccess().lookupOrThrow(Registries.BIOME);
        Set biomeSet = biomeRegistryLookup.listElements().collect(Collectors.toSet());
        for (Holder.Reference biomeReference : biomeSet) {
            String biome_name2 = biomeReference.getKey().location().getPath();
            if (this.biomes.contains(biome_name2) || !included_biomes.contains(biome_name2)) continue;
            this.biomes.add(biome_name2);
        }
        if (this.debugging) {
            RuinsMod.LOGGER.info("final biomesToSpawnIn list for template \"{}\":", (Object)this.name);
            this.biomes.forEach(biome_name -> RuinsMod.LOGGER.info(" {}", biome_name));
            RuinsMod.LOGGER.info("");
        }
        if (this.acceptedSurfaces == null) {
            this.acceptedSurfaces = new BlockState[0];
        }
        if (this.deniedSurfaces == null) {
            this.deniedSurfaces = new BlockState[0];
        }
        this.w_off = this.width % 2 == 1 ? 0 - (this.width - 1) / 2 : 0 - this.width / 2;
        this.l_off = this.length % 2 == 1 ? 0 - (this.length - 1) / 2 : 0 - this.length / 2;
    }

    public void markBlockForBonemeal(BlockPos position, int count) {
        this.bonemealMarkers.add(new BonemealMarker(position, count));
    }

    private BlockState[] fromString(String input) {
        HashSet<BlockState> stateSet = new HashSet<BlockState>();
        List<CompoundTag> stateList = RuleStringNbtHelper.splitRuleByBrackets(input);
        if (stateList != null) {
            for (CompoundTag stateCompound : stateList) {
                BlockState state = RuleStringNbtHelper.blockStateFromCompound(stateCompound);
                if (state.getBlock() == Blocks.AIR) continue;
                stateSet.add(state);
            }
        }
        return stateSet.toArray(new BlockState[0]);
    }

    public boolean acceptsDimension(String dimension) {
        return this.acceptedDimensions.isEmpty() || dimension != null && !dimension.isEmpty() && this.acceptedDimensions.contains(dimension);
    }

    public String toString() {
        return "RuinTemplate " + this.getName();
    }

    private class VariantRuleset {
        private final ArrayList<VariantGroup> variantGroups = new ArrayList();

        VariantRuleset() {
        }

        public void addVariant(int weight, RuinTemplateRule variant) {
            this.variantGroups.get(this.variantGroups.size() - 1).addVariant(weight, variant);
        }

        public void addVariantRule(int weight, RuinTemplateRule variant) {
            this.variantGroups.get(this.variantGroups.size() - 1).addVariantRule(weight, variant);
        }

        public void addVariantGroup(int repeatCount, int weight, RuinTemplateRule variant) {
            this.variantGroups.add(new VariantGroup(repeatCount, weight, variant));
        }

        public ArrayList<RuinTemplateRule> getVariants(RandomSource random) {
            ArrayList<RuinTemplateRule> variants = new ArrayList<RuinTemplateRule>();
            for (VariantGroup variantGroup : this.variantGroups) {
                variants.addAll(variantGroup.getVariants(random, variants.size()));
            }
            return variants;
        }

        public int size() {
            int total = 0;
            for (VariantGroup variantGroup : this.variantGroups) {
                total += variantGroup.size();
            }
            return total;
        }

        private class VariantGroup {
            private final int repeatCount;
            private final ArrayList<VariantRule> variantRules;

            VariantGroup(int repeatCountSpec, int weight, RuinTemplateRule variant) {
                this.repeatCount = repeatCountSpec;
                this.variantRules = new ArrayList();
                this.addVariantRule(weight, variant);
            }

            public void addVariant(int weight, RuinTemplateRule variant) {
                this.variantRules.get(this.variantRules.size() - 1).addVariant(weight, variant);
            }

            public void addVariantRule(int weight, RuinTemplateRule variant) {
                this.variantRules.add(new VariantRule(weight, variant));
            }

            public ArrayList<RuinTemplateRule> getVariants(RandomSource random, int ruleIndexInitial) {
                ArrayList<RuinTemplateRule> variants = new ArrayList<RuinTemplateRule>();
                for (int i = 0; i < this.repeatCount; ++i) {
                    int selector = this.variantRules.get(0).getRandomSelector(random, ruleIndexInitial + variants.size());
                    for (VariantRule variantRule : this.variantRules) {
                        variants.add(variantRule.getVariant(selector, ruleIndexInitial + variants.size()));
                    }
                }
                return variants;
            }

            public int size() {
                return this.repeatCount * this.variantRules.size();
            }

            private class VariantRule {
                private final ArrayList<Integer> weights = new ArrayList();
                private final ArrayList<RuinTemplateRule> variants = new ArrayList();
                private int weightsTotal = 0;

                public VariantRule(int weight, RuinTemplateRule variant) {
                    this.addVariant(weight, variant);
                }

                public void addVariant(int weight, RuinTemplateRule variant) {
                    this.weights.add(weight);
                    this.weightsTotal += weight;
                    this.variants.add(variant);
                }

                public int getRandomSelector(RandomSource random, int ruleIndex) {
                    int selector = random.nextInt(this.weightsTotal);
                    if (RuinTemplate.this.debugging && this.weightsTotal > 1) {
                        RuinsMod.LOGGER.info("template [{}] rule [{}]: group selector drawn (from 1-{}) = {}", (Object)RuinTemplate.this.name, (Object)ruleIndex, (Object)this.weightsTotal, (Object)(selector + 1));
                    }
                    return selector;
                }

                public RuinTemplateRule getVariant(int selectorInitial, int ruleIndex) {
                    int index = this.variants.size() - 1;
                    if (selectorInitial < this.weightsTotal) {
                        index = 0;
                        int selector = selectorInitial;
                        while ((selector -= this.weights.get(index).intValue()) >= 0) {
                            ++index;
                        }
                    }
                    if (RuinTemplate.this.debugging && this.weightsTotal > 1) {
                        if (selectorInitial < this.weightsTotal) {
                            RuinsMod.LOGGER.info("template [{}] rule [{}]: variant #{} with weight {} chosen by selector = {}", (Object)RuinTemplate.this.name, (Object)ruleIndex, (Object)(index + 1), (Object)this.weights.get(index), (Object)(selectorInitial + 1));
                        } else {
                            RuinsMod.LOGGER.info("template [{}] rule [{}]: last variant #{} chosen by selector = {}", (Object)RuinTemplate.this.name, (Object)ruleIndex, (Object)(index + 1), (Object)(selectorInitial + 1));
                        }
                    }
                    return this.variants.get(index);
                }
            }
        }
    }

    private static class BonemealMarker {
        private final BlockPos position_;
        private final int count_;

        public BonemealMarker(BlockPos position, int count) {
            this.position_ = new BlockPos((Vec3i)position);
            this.count_ = count;
        }

        public BlockPos getPosition() {
            return new BlockPos((Vec3i)this.position_);
        }

        public int getCount() {
            return this.count_;
        }
    }

    private class AdjoiningTemplateData {
        RuinTemplate adjoiningTemplate;
        int relativeX;
        int acceptableY;
        int relativeZ;
        float spawnchance;

        private AdjoiningTemplateData(RuinTemplate ruinTemplate) {
        }
    }

    private static enum ParserState {
        PRE_RULE_PHASE,
        RULE_PHASE,
        POST_RULE_PHASE;

    }

    public static class IncompatibleModException
    extends RuntimeException {
        private static final long serialVersionUID = -6208915606622752271L;

        public IncompatibleModException(String template) {
            super("template \"" + template + "\" not installed due to incompatibility with other mods");
        }
    }
}

