/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinTemplate;
import atomicstryker.ruins.common.RuinsMod;
import atomicstryker.ruins.common.RuleStringNbtHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.apache.logging.log4j.util.Supplier;

public class RuinTemplateRule {
    private final BlockState[] blockStates;
    private final CompoundTag[] tileEntityData;
    private final double[] blockWeights;
    private final int[] blockBonemeals;
    private final RuinTemplate owner;
    private final boolean excessiveDebugging;
    private double blockWeightsTotal;
    private static final String PARAMETERS_TAG = "Ruins";
    private static final String NAME_TAG = "Name";
    private static final String NULL_BLOCK_NAME = "ruins:null";
    private static final String PARAMETER_WEIGHT_TAG = "weight";
    private static final String PARAMETER_BONEMEAL_TAG = "bonemeal";
    private static final String PARAMETER_ENTITY_TAG = "entity";

    public RuinTemplateRule(RuinTemplate r, String rule, boolean debug) {
        this.owner = r;
        this.excessiveDebugging = debug;
        List<CompoundTag> stateCompounds = RuleStringNbtHelper.splitRuleByBrackets(rule);
        if (stateCompounds == null || stateCompounds.isEmpty()) {
            RuinsMod.LOGGER.error("could not find any blockstates in rule {}", (Object)rule);
            this.blockStates = new BlockState[0];
            this.blockWeights = new double[0];
            this.blockBonemeals = new int[0];
            this.tileEntityData = new CompoundTag[0];
            return;
        }
        int numblocks = stateCompounds.size();
        this.blockStates = new BlockState[numblocks];
        this.blockWeights = new double[numblocks];
        this.blockBonemeals = new int[numblocks];
        this.tileEntityData = new CompoundTag[numblocks];
        this.blockWeightsTotal = 0.0;
        for (int i = 0; i < numblocks; ++i) {
            CompoundTag stateCompound = stateCompounds.get(i);
            double blockWeight = 1.0;
            int blockBonemeal = 0;
            CompoundTag blockEntity = null;
            if (stateCompound.contains(PARAMETERS_TAG, 10)) {
                CompoundTag parameters = stateCompound.getCompound(PARAMETERS_TAG);
                blockWeight = RuinTemplateRule.extractWeight(blockWeight, parameters);
                blockBonemeal = RuinTemplateRule.extractBonemeal(blockBonemeal, parameters);
                blockEntity = RuinTemplateRule.extractEntity(blockEntity, parameters);
                if (!parameters.isEmpty()) {
                    RuinsMod.LOGGER.warn("ignoring invalid Ruins parameters {} in rule {}", new Supplier[]{() -> parameters.getAllKeys().toString(), () -> rule});
                }
                stateCompound.remove(PARAMETERS_TAG);
            }
            this.blockWeights[i] = blockWeight;
            this.blockWeightsTotal += this.blockWeights[i];
            this.blockBonemeals[i] = blockBonemeal;
            if (stateCompound.getString(NAME_TAG).equals(NULL_BLOCK_NAME)) {
                this.blockStates[i] = null;
                this.tileEntityData[i] = null;
                if (!this.excessiveDebugging) continue;
                RuinsMod.LOGGER.info("rule alternative: {}, {}", (Object)(i + 1), (Object)NULL_BLOCK_NAME);
                continue;
            }
            this.blockStates[i] = RuleStringNbtHelper.blockStateFromCompound(stateCompound);
            this.tileEntityData[i] = RuleStringNbtHelper.tileEntityNBTFromCompound(blockEntity, stateCompound);
            if (!this.excessiveDebugging) continue;
            RuinsMod.LOGGER.info("rule alternative: {}, {}", (Object)(i + 1), (Object)this.blockStates[i].toString());
        }
    }

    RuinTemplateRule(RuinTemplate r, String rule) {
        this(r, rule, false);
    }

    private static double extractWeight(double defaultValue, CompoundTag parameters) {
        double value;
        double weight = defaultValue;
        if (parameters.contains(PARAMETER_WEIGHT_TAG, 99) && (value = parameters.getDouble(PARAMETER_WEIGHT_TAG)) >= 0.0) {
            weight = value;
            parameters.remove(PARAMETER_WEIGHT_TAG);
        }
        return weight;
    }

    private static int extractBonemeal(int defaultValue, CompoundTag parameters) {
        int value;
        int bonemeal = defaultValue;
        if (parameters.contains(PARAMETER_BONEMEAL_TAG, 3) && (value = parameters.getInt(PARAMETER_BONEMEAL_TAG)) >= 0) {
            bonemeal = value;
            parameters.remove(PARAMETER_BONEMEAL_TAG);
        }
        return bonemeal;
    }

    private static CompoundTag extractEntity(CompoundTag defaultValue, CompoundTag parameters) {
        CompoundTag entity = defaultValue;
        if (parameters.contains(PARAMETER_ENTITY_TAG, 10)) {
            entity = parameters.getCompound(PARAMETER_ENTITY_TAG).copy();
            entity.remove("id");
            entity.remove("x");
            entity.remove("y");
            entity.remove("z");
            parameters.remove(PARAMETER_ENTITY_TAG);
        }
        return entity;
    }

    private static Rotation getDirectionalRotation(int direction) {
        return switch (direction) {
            case 1 -> Rotation.CLOCKWISE_90;
            case 2 -> Rotation.CLOCKWISE_180;
            case 3 -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    public void doBlock(Level world, RandomSource random, BlockPos pos, int rotate) {
        int blocknum = this.getBlockNum(random);
        this.handleBlockSpawning(world, random, pos, blocknum, rotate);
    }

    private void handleBlockSpawning(Level world, RandomSource random, BlockPos pos, int blocknum, int rotate) {
        BlockState blockState = this.blockStates[blocknum];
        if (blockState != null) {
            BlockState rotatedState = blockState.rotate((LevelAccessor)world, pos, RuinTemplateRule.getDirectionalRotation(rotate));
            if (this.excessiveDebugging) {
                RuinsMod.LOGGER.info("About to place blockstate {} at pos {}", (Object)rotatedState.toString(), (Object)pos.toString());
            }
            this.realizeBlock(world, pos, rotatedState, this.tileEntityData[blocknum]);
            int bonemeal = this.blockBonemeals[blocknum];
            if (bonemeal > 0) {
                this.owner.markBlockForBonemeal(pos, bonemeal);
            }
        }
    }

    private int getBlockNum(RandomSource random) {
        int blockIndex = 0;
        double selector = random.nextDouble() * this.blockWeightsTotal;
        while (true) {
            double d;
            selector -= this.blockWeights[blockIndex];
            if (!(d >= 0.0)) break;
            ++blockIndex;
        }
        return blockIndex;
    }

    private void realizeBlock(Level world, BlockPos position, BlockState blockState, CompoundTag nbtTagCompound) {
        if (world != null && blockState != null) {
            boolean success;
            BlockEntity existing_entity = world.getBlockEntity(position);
            if (existing_entity != null) {
                world.setBlock(position, Blocks.AIR.defaultBlockState(), 3);
            }
            if (!(success = world.setBlock(position, blockState, 3)) && !world.getBlockState(position).is(blockState.getBlock())) {
                RuinsMod.LOGGER.error("world setBlock({}, {}) returned false, current blockstate: {}", (Object)position, (Object)blockState, (Object)world.getBlockState(position));
                return;
            }
            BlockEntity entity = world.getBlockEntity(position);
            if (nbtTagCompound != null) {
                if (entity == null) {
                    RuinsMod.LOGGER.error("no BlockEntity created from {}", (Object)blockState);
                    return;
                }
                entity.loadWithComponents(nbtTagCompound, (HolderLookup.Provider)world.registryAccess());
                if (entity instanceof RandomizableContainerBlockEntity) {
                    if (nbtTagCompound.contains("ForgeData")) {
                        nbtTagCompound = nbtTagCompound.getCompound("ForgeData");
                    }
                    if (nbtTagCompound.contains("LootTable")) {
                        String lootTable = nbtTagCompound.getString("LootTable");
                        long lootSeed = nbtTagCompound.getLong("LootTableSeed");
                        ResourceLocation lootResourceLocation = ResourceLocation.parse((String)lootTable);
                        RandomizableContainerBlockEntity tileEntityLockableLoot = (RandomizableContainerBlockEntity)entity;
                        for (ResourceKey lootTableResourceKey : BuiltInLootTables.all()) {
                            if (!lootTableResourceKey.location().equals((Object)lootResourceLocation)) continue;
                            tileEntityLockableLoot.setLootTable(lootTableResourceKey, lootSeed);
                            tileEntityLockableLoot.unpackLootTable(null);
                            break;
                        }
                    }
                }
            }
        }
    }
}

