/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.CommandParseTemplate;
import atomicstryker.ruins.common.CommandTestTemplate;
import atomicstryker.ruins.common.ConfigFolderPreparator;
import atomicstryker.ruins.common.FileHandler;
import atomicstryker.ruins.common.IProxy;
import atomicstryker.ruins.common.RuinGenerator;
import atomicstryker.ruins.common.RuinsClient;
import atomicstryker.ruins.common.RuinsServer;
import atomicstryker.ruins.common.RuleStringNbtHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ruins")
@EventBusSubscriber(modid="ruins", value={Dist.DEDICATED_SERVER})
public class RuinsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String TEMPLATE_PATH_MC_EXTRACTED = "config/ruins_config/";
    public static final String TEMPLATE_PATH_JAR = "ruins_config";
    public static final int DIR_NORTH = 0;
    public static final int DIR_EAST = 1;
    public static final int DIR_SOUTH = 2;
    public static final int DIR_WEST = 3;
    public static final String BIOME_ANY = "generic";
    static final String MOD_ID = "ruins";
    public static IProxy proxy = FMLEnvironment.dist.isClient() ? new RuinsClient() : new RuinsServer();
    private static RuinsMod instance = null;
    private final ConcurrentHashMap<ResourceLocation, WorldHandle> generatorMap;
    private long nextInfoTime;
    private Level lastLoadedLevel;

    public RuinsMod(IEventBus modEventBus) {
        instance = this;
        this.generatorMap = new ConcurrentHashMap();
        modEventBus.addListener(this::preInit);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new CommandParseTemplate());
        LOGGER.info("Ruins instance built, events registered");
    }

    public static RuinsMod getInstance() {
        return instance;
    }

    private static File getWorldSaveDir(Level iWorld) {
        if (iWorld instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)iWorld;
            try {
                for (Field declaredField : world.getChunkSource().getDataStorage().getClass().getDeclaredFields()) {
                    if (!declaredField.getType().equals(Path.class)) continue;
                    declaredField.setAccessible(true);
                    Path path = (Path)declaredField.get(world.getChunkSource().getDataStorage());
                    return path.toFile();
                }
                throw new RuntimeException("Ruins mod could not find field File DimensionDataStorage.dataFolder");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static File getMinecraftBaseDir() {
        return proxy.getBaseDir();
    }

    @SubscribeEvent
    public void onEnteringChunk(EntityEvent.EnteringSection event) {
        if (instance != null && event.getEntity() instanceof Player && !event.getEntity().level().isClientSide()) {
            WorldHandle wh;
            ServerLevel world;
            if (event.getEntity().level() instanceof ServerLevel) {
                world = (ServerLevel)event.getEntity().level();
                if (!world.structureManager().shouldGenerateStructures()) {
                    return;
                }
                wh = instance.getWorldHandle(world);
                if (wh == null || !wh.fileHandle.loaded || !wh.fileHandle.allowsDimension(world.dimension().location().getPath())) {
                    return;
                }
            } else {
                return;
            }
            int xMove = 0;
            int zMove = 0;
            if (event.getNewPos().x() > event.getOldPos().x()) {
                xMove = 1;
            } else if (event.getNewPos().x() < event.getOldPos().x()) {
                xMove = -1;
            }
            if (event.getNewPos().z() > event.getOldPos().z()) {
                zMove = 1;
            } else if (event.getNewPos().z() < event.getOldPos().z()) {
                zMove = -1;
            }
            if (xMove == 0 && zMove == 0) {
                return;
            }
            int projectedChunkX = event.getNewPos().x() + xMove * 7;
            int projectedChunkZ = event.getNewPos().z() + zMove * 7;
            for (int iterX = projectedChunkX - 2; iterX <= projectedChunkX + 2; ++iterX) {
                for (int iterZ = projectedChunkZ - 2; iterZ <= projectedChunkZ + 2; ++iterZ) {
                    int deltaZ;
                    int deltaX = iterX - event.getNewPos().x();
                    double euclidChunkDistance = Math.sqrt(deltaX * deltaX + (deltaZ = iterZ - event.getNewPos().z()) * deltaZ);
                    if (euclidChunkDistance < 5.0) continue;
                    this.inspectChunk(world, new ChunkPos(iterX, iterZ), wh);
                }
            }
        }
    }

    private void inspectChunk(ServerLevel world, ChunkPos chunkPos, WorldHandle worldHandle) {
        if (!world.hasChunk(chunkPos.x, chunkPos.z)) {
            return;
        }
        BlockPos ruinsMarkerBlockPos = new BlockPos(chunkPos.getMinBlockX(), world.getMinY(), chunkPos.getMinBlockZ());
        BlockState blockState = world.getBlockState(ruinsMarkerBlockPos);
        if (blockState.is(Blocks.BARRIER)) {
            return;
        }
        world.setBlock(ruinsMarkerBlockPos, Blocks.BARRIER.defaultBlockState(), 3);
        LOGGER.trace("Ruins generation for chunk {}", (Object)chunkPos);
        if (world.dimension().location().getPath().equals("the_nether")) {
            worldHandle.generator.generateNether((Level)world, world.random, chunkPos.getMinBlockX(), chunkPos.getMinBlockZ());
        } else {
            worldHandle.generator.generateNormal((Level)world, world.random, chunkPos.getMinBlockX(), chunkPos.getMinBlockZ());
        }
    }

    public void preInit(FMLCommonSetupEvent evt) {
        LOGGER.info("Ruins preInit");
        ConfigFolderPreparator.copyFromJarIfNotPresent(this, new File(RuinsMod.getMinecraftBaseDir(), TEMPLATE_PATH_MC_EXTRACTED));
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        LOGGER.info("Ruins registerCommands");
        evt.getDispatcher().register(CommandParseTemplate.BUILDER);
        evt.getDispatcher().register(CommandTestTemplate.BUILDER);
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack is;
        WorldHandle wh;
        if (event.getEntity().level() instanceof ServerLevel && (wh = this.getWorldHandle((ServerLevel)event.getEntity().level())) != null && wh.fileHandle.enableStick && (is = event.getEntity().getMainHandItem()).getItem() == Items.STICK && System.currentTimeMillis() > this.nextInfoTime) {
            this.nextInfoTime = System.currentTimeMillis() + 1000L;
            BlockEntity te = event.getEntity().level().getBlockEntity((BlockPos)event.getPosition().get());
            event.getEntity().displayClientMessage((Component)Component.literal((String)RuleStringNbtHelper.StringFromBlockState(event.getState(), te)), false);
        }
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        ItemStack is;
        WorldHandle wh;
        if (event.getPlayer() != null && event.getLevel() instanceof ServerLevel && (wh = this.getWorldHandle((ServerLevel)event.getLevel())) != null && wh.fileHandle.enableStick && (is = event.getPlayer().getMainHandItem()).getItem() == Items.STICK && System.currentTimeMillis() > this.nextInfoTime) {
            this.nextInfoTime = System.currentTimeMillis() + 1000L;
            BlockEntity te = event.getPlayer().level().getBlockEntity(event.getPos());
            event.getPlayer().displayClientMessage((Component)Component.literal((String)RuleStringNbtHelper.StringFromBlockState(event.getState(), te)), false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void eventWorldSave(LevelEvent.Save evt) {
        WorldHandle wh;
        if (evt.getLevel() instanceof ServerLevel && (wh = this.getWorldHandle((ServerLevel)evt.getLevel())) != null) {
            wh.generator.flushPosFile(((ServerLevel)evt.getLevel()).getServer().getWorldData().getLevelName());
        }
    }

    @SubscribeEvent
    public void onEntityEnteringChunk(EntityEvent.EnteringSection event) {
        if (event.getEntity() instanceof Player && !event.getEntity().level().isClientSide) {
            this.executeCommandBlockLogic(event);
        }
    }

    public Level getLastLoadedLevel() {
        return this.lastLoadedLevel;
    }

    private void executeCommandBlockLogic(EntityEvent.EnteringSection event) {
        ArrayList<CommandBlockEntity> tecblist = new ArrayList<CommandBlockEntity>();
        for (int xoffset = -4; xoffset <= 4; ++xoffset) {
            for (int zoffset = -4; zoffset <= 4; ++zoffset) {
                if (!event.getEntity().level().hasChunk(event.getNewPos().x() + xoffset, event.getNewPos().z() + zoffset)) continue;
                for (BlockEntity teo : event.getEntity().level().getChunk(event.getNewPos().x() + xoffset, event.getNewPos().z() + zoffset).getBlockEntities().values()) {
                    CommandBlockEntity tecb;
                    if (!(teo instanceof CommandBlockEntity) || !(tecb = (CommandBlockEntity)teo).getCommandBlock().getCommand().startsWith("RUINSTRIGGER ")) continue;
                    tecb.getCommandBlock().setCommand(tecb.getCommandBlock().getCommand().substring(13));
                    tecblist.add(tecb);
                }
            }
        }
        for (CommandBlockEntity tecb2 : tecblist) {
            tecb2.getCommandBlock().performCommand(event.getEntity().level());
            BlockPos pos = tecb2.getBlockPos();
            LOGGER.info("Ruins executed and killed Command Block at [{}]", (Object)pos);
            event.getEntity().level().removeBlock(pos, false);
        }
    }

    private WorldHandle getWorldHandle(ServerLevel world) {
        WorldHandle wh = null;
        if (!world.isClientSide()) {
            if (!this.generatorMap.containsKey(world.dimension().location())) {
                wh = new WorldHandle(this);
                this.initWorldHandle(wh, world);
                this.generatorMap.put(world.dimension().location(), wh);
            } else {
                wh = this.generatorMap.get(world.dimension().location());
            }
        }
        return wh;
    }

    private void initWorldHandle(WorldHandle worldHandle, ServerLevel world) {
        try {
            File worlddir = RuinsMod.getWorldSaveDir((Level)world);
            LOGGER.info("Ruins mod determines World Save Dir to be at: {}", (Object)worlddir);
            worldHandle.fileHandle = new FileHandler(worlddir, world.dimension().location());
            worldHandle.generator = new RuinGenerator(worldHandle.fileHandle, (Level)world);
            this.lastLoadedLevel = world;
        }
        catch (Exception e) {
            LOGGER.error("There was a problem loading the ruins mod:");
            LOGGER.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private class WorldHandle {
        FileHandler fileHandle;
        RuinGenerator generator;

        private WorldHandle(RuinsMod ruinsMod) {
        }
    }
}

