/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinsMod;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Level;

public class RuleStringNbtHelper {
    private static int throttleEntityWarning = 4;

    public static String StringFromBlockState(BlockState blockState, BlockEntity tileEntity) {
        CompoundTag tagCompound = NbtUtils.writeBlockState((BlockState)blockState);
        if (tileEntity != null) {
            CompoundTag parameters = new CompoundTag();
            CompoundTag tagTileEntity = tileEntity.saveWithFullMetadata((HolderLookup.Provider)tileEntity.getLevel().registryAccess());
            tagTileEntity.remove("id");
            tagTileEntity.remove("x");
            tagTileEntity.remove("y");
            tagTileEntity.remove("z");
            parameters.put("entity", (Tag)tagTileEntity);
            tagCompound.put("Ruins", (Tag)parameters);
        }
        return tagCompound.toString();
    }

    public static BlockState blockStateFromCompound(CompoundTag input) {
        CompoundTag nbtTagCompound = input.copy();
        nbtTagCompound.remove("ruinsTE");
        try {
            return NbtUtils.readBlockState((HolderGetter)RuinsMod.getInstance().getLastLoadedLevel().holderLookup(Registries.BLOCK), (CompoundTag)nbtTagCompound);
        }
        catch (Exception e) {
            RuinsMod.LOGGER.error("failed translating CompoundTag {} to block", (Object)nbtTagCompound, (Object)e);
            return Blocks.AIR.defaultBlockState();
        }
    }

    public static CompoundTag tileEntityNBTFromCompound(CompoundTag defaultValue, CompoundTag input) {
        CompoundTag teNbt = defaultValue;
        if (input.contains("ruinsTE", 10)) {
            Level level = throttleEntityWarning > 0 ? Level.WARN : Level.DEBUG;
            RuinsMod.LOGGER.log(level, "{ruinsTE:{...}} is deprecated; use {Ruins:{entity:{...}}} instead");
            if (throttleEntityWarning > 0 && --throttleEntityWarning < 1) {
                RuinsMod.LOGGER.warn("suppressing ruinsTE deprecation warnings; limit reached");
            }
            if (defaultValue == null) {
                teNbt = input.getCompound("ruinsTE").copy();
                teNbt.remove("id");
                teNbt.remove("x");
                teNbt.remove("y");
                teNbt.remove("z");
            }
        }
        return teNbt;
    }

    public static List<CompoundTag> splitRuleByBrackets(String rule) {
        ArrayList<CompoundTag> result = new ArrayList<CompoundTag>();
        int currentBracketStartIndex = 0;
        int bracketCounter = 0;
        char quote = '\u0000';
        for (int i = 0; i < rule.length(); ++i) {
            char c = rule.charAt(i);
            if (quote != '\u0000') {
                if (quote == c) {
                    quote = '\u0000';
                    continue;
                }
                if ('\\' != c) continue;
                ++i;
                continue;
            }
            if ('{' == c) {
                if (++bracketCounter != 1) continue;
                currentBracketStartIndex = i;
                continue;
            }
            if ('}' == c) {
                CompoundTag nbtTagCompound;
                if (--bracketCounter < 0) {
                    RuinsMod.LOGGER.error("Error in rule {} at character {}: unbalanced brackets!", (Object)rule, (Object)i);
                    return null;
                }
                if (bracketCounter != 0) continue;
                try {
                    nbtTagCompound = TagParser.parseTag((String)rule.substring(currentBracketStartIndex, i + 1));
                }
                catch (CommandSyntaxException e) {
                    RuinsMod.LOGGER.error("Error in rule {} starting at character {}: unbalanced brackets!", (Object)rule, (Object)currentBracketStartIndex);
                    return null;
                }
                result.add(nbtTagCompound);
                continue;
            }
            if ('\"' != c && '\'' != c) continue;
            quote = c;
        }
        if (quote != '\u0000') {
            RuinsMod.LOGGER.error("Error in rule {} unbalanced quotes!", (Object)rule);
            return null;
        }
        if (bracketCounter > 0) {
            RuinsMod.LOGGER.error("Error in rule {} unbalanced brackets!", (Object)rule);
            return null;
        }
        return result;
    }
}

