/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.world.clouds;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.resource.ResourceHandle;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.render.immediate.CloudRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;
    @Shadow
    private int ticks;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private CloudRenderer cloudRenderer;

    @Inject(method={"method_62205"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/CloudRenderer;render(ILnet/minecraft/client/CloudStatus;FLorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lnet/minecraft/world/phys/Vec3;F)V")}, require=0, cancellable=true)
    @Group(name="sodium$cloudsOverride", min=1, max=1)
    @Dynamic
    public void renderCloudsFabric(ResourceHandle<RenderTarget> resourceHandle, int cloudColor, CloudStatus cloudStatus, float cloudHeight, Matrix4f matModelView, Matrix4f matProjection, Vec3 camera, float partialTicks, CallbackInfo ci) {
        ci.cancel();
        this.sodium$renderClouds(matModelView, matProjection, cloudColor);
    }

    @Inject(method={"lambda$addCloudsPass$6"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/CloudRenderer;render(ILnet/minecraft/client/CloudStatus;FLorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lnet/minecraft/world/phys/Vec3;F)V")}, cancellable=true, require=0)
    @Group(name="sodium$cloudsOverride", min=1, max=1)
    @Dynamic
    public void renderCloudsNeo(ResourceHandle<?> resourcehandle, float p_365209_, Vec3 p_362985_, Matrix4f modelView, Matrix4f projectionMatrix, int color, CloudStatus p_364196_, float p_362337_, CallbackInfo ci) {
        ci.cancel();
        this.sodium$renderClouds(modelView, projectionMatrix, color);
    }

    @Unique
    private void sodium$renderClouds(Matrix4f matModelView, Matrix4f matProjection, int color) {
        if (this.cloudRenderer == null) {
            this.cloudRenderer = new CloudRenderer((ResourceProvider)this.minecraft.getResourceManager());
        }
        Camera camera = this.minecraft.gameRenderer.getMainCamera();
        ClientLevel level = Objects.requireNonNull(this.level);
        int ticks = this.ticks;
        float partialTicks = this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(false);
        this.cloudRenderer.render(camera, level, matProjection, matModelView, ticks, partialTicks, color);
    }

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="RETURN")})
    private void onReload(ResourceManager manager, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.reload((ResourceProvider)manager);
        }
    }

    @Inject(method={"allChanged()V"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.destroy();
            this.cloudRenderer = null;
        }
    }

    @Inject(method={"close"}, at={@At(value="RETURN")})
    private void onClose(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.destroy();
            this.cloudRenderer = null;
        }
    }
}

