/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.textures.mipmaps;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.NativeImage;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.client.util.NativeImageHelper;
import net.caffeinemc.mods.sodium.client.util.color.ColorSRGB;
import net.minecraft.client.renderer.texture.SpriteContents;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={SpriteContents.class})
public class SpriteContentsMixin {
    @Mutable
    @Shadow
    @Final
    private NativeImage originalImage;

    @WrapOperation(method={"<init>"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/texture/SpriteContents;originalImage:Lcom/mojang/blaze3d/platform/NativeImage;", opcode=181)})
    private void sodium$beforeGenerateMipLevels(SpriteContents instance, NativeImage nativeImage, Operation<Void> original) {
        SpriteContentsMixin.sodium$fillInTransparentPixelColors(nativeImage);
        original.call(new Object[]{instance, nativeImage});
    }

    @Unique
    private static void sodium$fillInTransparentPixelColors(NativeImage nativeImage) {
        long ppPixel = NativeImageHelper.getPointerRGBA(nativeImage);
        int pixelCount = nativeImage.getHeight() * nativeImage.getWidth();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalWeight = 0.0f;
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)pixelIndex * 4L;
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = ColorABGR.unpackAlpha(color);
            if (alpha == 0) continue;
            float weight = alpha;
            r += ColorSRGB.srgbToLinear(ColorABGR.unpackRed(color)) * weight;
            g += ColorSRGB.srgbToLinear(ColorABGR.unpackGreen(color)) * weight;
            b += ColorSRGB.srgbToLinear(ColorABGR.unpackBlue(color)) * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0f) {
            return;
        }
        int averageColor = ColorSRGB.linearToSrgb(r /= totalWeight, g /= totalWeight, b /= totalWeight, 0);
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = ColorABGR.unpackAlpha(color);
            if (alpha != 0) continue;
            MemoryUtil.memPutInt((long)pPixel, (int)averageColor);
        }
    }
}

