/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block;

import com.legacy.structure_gel.api.dimension.portal.GelPortalFinder;
import com.legacy.structure_gel.api.dimension.portal.GelPortalForcer;
import com.legacy.structure_gel.api.dimension.portal.GelPortalShape;
import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class GelPortalBlock
extends Block
implements Portal {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final int AABB_OFFSET = 2;
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public GelPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    public void tryIgnite(Level level, BlockPos pos) {
        Optional<GelPortalShape> optional;
        if (this.inPortalDimension((ResourceKey<Level>)level.dimension()) && (optional = this.getPortalFinder().findEmptyPortalShape((LevelAccessor)level, pos, Direction.Axis.X)).isPresent()) {
            optional.get().createPortalBlocks((LevelAccessor)level);
        }
    }

    public abstract MapCodec<? extends GelPortalBlock> codec();

    public abstract ResourceKey<Level> getDestination();

    public abstract ResourceKey<Level> getSource();

    public abstract GelPortalForcer.PortalCreator getPortalCreator();

    public abstract ResourceKey<PoiType> getPortalPoi();

    public abstract BlockState getFrameBlock();

    public abstract BlockState getIgnitionBlock();

    public boolean isFrame(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(this.getFrameBlock().getBlock());
    }

    public boolean canReplace(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isAir() || state.is((Block)this) || state.is(this.getIgnitionBlock().getBlock());
    }

    public GelPortalFinder getPortalFinder() {
        return new GelPortalFinder(this);
    }

    public GelPortalSize getSizeRules() {
        return GelPortalSize.DEFAULT;
    }

    public GelPortalForcer getPortalForcer(ServerLevel from) {
        return new GelPortalForcer(from, this);
    }

    public boolean inPortalDimension(ResourceKey<Level> levelKey) {
        return levelKey == this.getSource() || levelKey == this.getDestination();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderPortal(GuiGraphics graphics, float alpha) {
        if (alpha < 1.0f) {
            alpha *= alpha;
            alpha *= alpha;
            alpha = alpha * 0.8f + 0.2f;
        }
        int i = ARGB.white((float)alpha);
        TextureAtlasSprite textureatlassprite = this.getPortalTexture();
        graphics.blitSprite(RenderType::guiTexturedOverlay, textureatlassprite, 0, 0, graphics.guiWidth(), graphics.guiHeight(), i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getPortalTexture() {
        Minecraft mc = Minecraft.getInstance();
        return mc.getBlockRenderer().getBlockModelShaper().getParticleIcon(this.defaultBlockState());
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance getTriggerSound() {
        return SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvents.PORTAL_TRIGGER, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)0.25f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundInstance getTravelSound() {
        return SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvents.PORTAL_TRAVEL, (float)(new Random().nextFloat() * 0.4f + 0.8f), (float)0.25f);
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(true)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        int n;
        Block block = Blocks.NETHER_PORTAL;
        if (block instanceof Portal) {
            Portal portal = (Portal)block;
            return portal.getPortalTransitionTime(level, entity);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = Math.max(0, level.getGameRules().getInt(player.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        } else {
            n = 0;
        }
        return n;
    }

    public Vec3i getExitOffset(BlockState entryPortal, BlockPos entryPortalPos, ServerLevel level, Entity entity) {
        return Vec3i.ZERO;
    }

    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos entryPos) {
        BlockState portal = level.getBlockState(entryPos);
        Vec3i exitOffset = portal.is((Block)this) ? this.getExitOffset(portal, entryPos, level, entity) : Vec3i.ZERO;
        ResourceKey<Level> destKey = level.dimension() == this.getDestination() ? this.getSource() : this.getDestination();
        ServerLevel destination = level.getServer().getLevel(destKey);
        if (destination == null) {
            return null;
        }
        double teleportScale = DimensionType.getTeleportationScale((DimensionType)level.dimensionType(), (DimensionType)destination.dimensionType());
        int searchRadius = Math.max((int)(16.0 * teleportScale), 16);
        WorldBorder worldborder = destination.getWorldBorder();
        BlockPos exitPos = worldborder.clampToBounds((entity.getX() + (double)exitOffset.getX()) * teleportScale, entity.getY() + (double)exitOffset.getY(), (entity.getZ() + (double)exitOffset.getZ()) * teleportScale);
        return GelPortalBlock.getExitPortal(destination, entity, entryPos, exitPos, searchRadius, worldborder, this.getPortalForcer(destination));
    }

    @Nullable
    protected static TeleportTransition getExitPortal(ServerLevel level, Entity entity, BlockPos entryPos, BlockPos exitPos, int searchRadius, WorldBorder worldBorder, GelPortalForcer portalForcer) {
        TeleportTransition.PostTeleportTransition postTeleport;
        BlockUtil.FoundRectangle rectangle;
        Optional<BlockPos> closetPortal = portalForcer.findClosestPortalPosition(exitPos, searchRadius, worldBorder);
        if (closetPortal.isPresent()) {
            BlockPos blockpos = closetPortal.get();
            BlockState portalState = level.getBlockState(blockpos);
            rectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)portalState.getValue(AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p -> level.getBlockState(p) == portalState);
            postTeleport = TeleportTransition.PLAY_PORTAL_SOUND.then(e -> e.placePortalTicket(blockpos));
        } else {
            Direction.Axis axis = entity.level().getBlockState(entryPos).getOptionalValue(AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> createdPortal = portalForcer.createPortal(portalForcer, exitPos, axis);
            if (createdPortal.isEmpty()) {
                StructureGelMod.LOGGER.error("Unable to create a portal, likely target out of worldborder", new Object[0]);
                return null;
            }
            rectangle = createdPortal.get();
            postTeleport = TeleportTransition.PLAY_PORTAL_SOUND.then(TeleportTransition.PLACE_PORTAL_TICKET);
        }
        return GelPortalBlock.getDimensionTransitionFromExit(entity, entryPos, rectangle, level, postTeleport);
    }

    protected static TeleportTransition getDimensionTransitionFromExit(Entity entity, BlockPos entryPos, BlockUtil.FoundRectangle rect, ServerLevel level, TeleportTransition.PostTeleportTransition postTeleport) {
        Vec3 relativePos;
        Direction.Axis axis;
        BlockState state = entity.level().getBlockState(entryPos);
        if (state.hasProperty(AXIS)) {
            axis = (Direction.Axis)state.getValue(AXIS);
            BlockUtil.FoundRectangle blockutil$foundrectangle = BlockUtil.getLargestRectangleAround((BlockPos)entryPos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p -> entity.level().getBlockState(p) == state);
            relativePos = entity.getRelativePortalPosition(axis, blockutil$foundrectangle);
        } else {
            axis = Direction.Axis.X;
            relativePos = new Vec3(0.5, 0.0, 0.0);
        }
        return GelPortalBlock.createDimensionTransition(level, rect, axis, relativePos, entity, postTeleport);
    }

    protected static TeleportTransition createDimensionTransition(ServerLevel level, BlockUtil.FoundRectangle rect, Direction.Axis axis, Vec3 relativePos, Entity entity, TeleportTransition.PostTeleportTransition postTeleport) {
        BlockPos blockpos = rect.minCorner;
        BlockState blockstate = level.getBlockState(blockpos);
        Direction.Axis direction$axis = blockstate.getOptionalValue(AXIS).orElse(Direction.Axis.X);
        double d0 = rect.axis1Size;
        double d1 = rect.axis2Size;
        EntityDimensions entitydimensions = entity.getDimensions(entity.getPose());
        int i = axis == direction$axis ? 0 : 90;
        double d2 = (double)entitydimensions.width() / 2.0 + (d0 - (double)entitydimensions.width()) * relativePos.x();
        double d3 = (d1 - (double)entitydimensions.height()) * relativePos.y();
        double d4 = 0.5 + relativePos.z();
        boolean flag = direction$axis == Direction.Axis.X;
        Vec3 vec3 = new Vec3((double)blockpos.getX() + (flag ? d2 : d4), (double)blockpos.getY() + d3, (double)blockpos.getZ() + (flag ? d4 : d2));
        Vec3 vec31 = PortalShape.findCollisionFreePosition((Vec3)vec3, (ServerLevel)level, (Entity)entity, (EntityDimensions)entitydimensions);
        return new TeleportTransition(level, vec31, Vec3.ZERO, (float)i, 0.0f, Relative.union((Set[])new Set[]{Relative.DELTA, Relative.ROTATION}), postTeleport);
    }

    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccss, BlockPos pos, Direction updateDir, BlockPos updatePos, BlockState updateState, RandomSource rand) {
        Direction.Axis updateAxis = updateDir.getAxis();
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        boolean flag = axis != updateAxis && updateAxis.isHorizontal();
        return !flag && !updateState.is((Block)this) && !this.getPortalFinder().findAnyShape((BlockGetter)level, pos, axis).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, tickAccss, pos, updateDir, updatePos, updateState, rand);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.getValue(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos blockPos, BlockState state, boolean copyData) {
        return ItemStack.EMPTY;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public record GelPortalSize(int minWidth, int maxWidth, int minHeight, int maxHeight) {
        public static final GelPortalSize DEFAULT = new GelPortalSize(2, 21, 3, 21);
    }
}

