/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.dimension.portal;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.api.dimension.portal.GelPortalShape;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableInt;

public class GelPortalFinder {
    private GelPortalBlock.GelPortalSize size = GelPortalBlock.GelPortalSize.DEFAULT;
    final GelPortalBlock portal;
    final BlockBehaviour.StatePredicate isFrame;
    final BlockBehaviour.StatePredicate canReplace;

    public GelPortalFinder(GelPortalBlock portal) {
        this(portal, portal::isFrame, portal::canReplace);
    }

    public GelPortalFinder(GelPortalBlock portal, BlockBehaviour.StatePredicate isFrame, BlockBehaviour.StatePredicate canReplace) {
        this.portal = portal;
        this.isFrame = isFrame;
        this.canReplace = canReplace;
        this.size = portal.getSizeRules();
    }

    public GelPortalBlock.GelPortalSize sizeRules() {
        return this.size;
    }

    public GelPortalBlock portal() {
        return this.portal;
    }

    public Optional<GelPortalShape> findEmptyPortalShape(LevelAccessor level, BlockPos bottomLeft, Direction.Axis axis) {
        return this.findPortalShape(level, bottomLeft, shape -> shape.isValid() && shape.numberOfPortalBlocks() == 0, axis);
    }

    public Optional<GelPortalShape> findPortalShape(LevelAccessor level, BlockPos bottomLeft, Predicate<GelPortalShape> predicate, Direction.Axis axis) {
        Optional<GelPortalShape> optional = Optional.of(this.findAnyShape((BlockGetter)level, bottomLeft, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(this.findAnyShape((BlockGetter)level, bottomLeft, direction$axis)).filter(predicate);
    }

    public GelPortalShape findAnyShape(BlockGetter level, BlockPos pos, Direction.Axis axis) {
        Direction direction = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        BlockPos blockpos = this.calculateBottomLeft(level, direction, pos);
        if (blockpos == null) {
            return new GelPortalShape(axis, 0, direction, pos, 0, 0, this);
        }
        int width = this.calculateWidth(level, blockpos, direction);
        if (width == 0) {
            return new GelPortalShape(axis, 0, direction, blockpos, 0, 0, this);
        }
        MutableInt mutableint = new MutableInt();
        int height = this.calculateHeight(level, blockpos, direction, width, mutableint);
        return new GelPortalShape(axis, mutableint.getValue(), direction, blockpos, width, height, this);
    }

    @Nullable
    private BlockPos calculateBottomLeft(BlockGetter level, Direction dir, BlockPos pos) {
        int i = Math.max(level.getMinY(), pos.getY() - this.size.maxHeight());
        while (pos.getY() > i && this.isEmpty(level.getBlockState(pos.below()), level, pos.below())) {
            pos = pos.below();
        }
        Direction direction = dir.getOpposite();
        int j = this.getDistanceUntilEdgeAboveFrame(level, pos, direction) - 1;
        return j < 0 ? null : pos.relative(direction, j);
    }

    private int calculateWidth(BlockGetter level, BlockPos pos, Direction dir) {
        int width = this.getDistanceUntilEdgeAboveFrame(level, pos, dir);
        return width >= this.size.minWidth() && width <= this.size.maxWidth() ? width : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockGetter level, BlockPos pos, Direction dir) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= this.size.maxWidth(); ++i) {
            blockpos$mutableblockpos.set((Vec3i)pos).move(dir, i);
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!this.isEmpty(blockstate, level, (BlockPos)blockpos$mutableblockpos)) {
                if (!this.isFrame.test(blockstate, level, (BlockPos)blockpos$mutableblockpos)) break;
                return i;
            }
            BlockState blockstate1 = level.getBlockState((BlockPos)blockpos$mutableblockpos.move(Direction.DOWN));
            if (!this.isFrame.test(blockstate1, level, (BlockPos)blockpos$mutableblockpos)) break;
        }
        return 0;
    }

    private int calculateHeight(BlockGetter level, BlockPos pos, Direction dir, int width, MutableInt portalCount) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int height = this.getDistanceUntilTop(level, pos, dir, blockpos$mutableblockpos, width, portalCount);
        return height >= this.size.minHeight() && height <= this.size.maxHeight() && this.hasTopFrame(level, pos, dir, blockpos$mutableblockpos, width, height) ? height : 0;
    }

    private boolean hasTopFrame(BlockGetter level, BlockPos pos, Direction dir, BlockPos.MutableBlockPos mutPos, int width, int height) {
        for (int i = 0; i < width; ++i) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = mutPos.set((Vec3i)pos).move(Direction.UP, height).move(dir, i);
            if (this.isFrame.test(level.getBlockState((BlockPos)blockpos$mutableblockpos), level, (BlockPos)blockpos$mutableblockpos)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(BlockGetter level, BlockPos pos, Direction dir, BlockPos.MutableBlockPos mutPos, int width, MutableInt portalCount) {
        for (int i = 0; i < this.size.maxHeight(); ++i) {
            mutPos.set((Vec3i)pos).move(Direction.UP, i).move(dir, -1);
            if (!this.isFrame.test(level.getBlockState((BlockPos)mutPos), level, (BlockPos)mutPos)) {
                return i;
            }
            mutPos.set((Vec3i)pos).move(Direction.UP, i).move(dir, width);
            if (!this.isFrame.test(level.getBlockState((BlockPos)mutPos), level, (BlockPos)mutPos)) {
                return i;
            }
            for (int j = 0; j < width; ++j) {
                mutPos.set((Vec3i)pos).move(Direction.UP, i).move(dir, j);
                BlockState blockstate = level.getBlockState((BlockPos)mutPos);
                if (!this.isEmpty(blockstate, level, (BlockPos)mutPos)) {
                    return i;
                }
                if (!blockstate.is((Block)this.portal)) continue;
                portalCount.increment();
            }
        }
        return this.size.maxHeight();
    }

    private boolean isEmpty(BlockState state, BlockGetter level, BlockPos pos) {
        return this.canReplace.test(state, level, pos);
    }
}

