/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.dimension.portal;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;

public class GelPortalForcer {
    public final ServerLevel level;
    public final ResourceKey<PoiType> portalPoi;
    public final BlockState frameBlock;
    public final GelPortalBlock portalBlock;
    public final PortalCreator portalCreator;

    public GelPortalForcer(ServerLevel level, GelPortalBlock portal) {
        this(level, portal, portal.getPortalPoi(), portal.getFrameBlock(), portal.getPortalCreator());
    }

    public GelPortalForcer(ServerLevel level, GelPortalBlock portal, ResourceKey<PoiType> portalPoi, BlockState frameBlock, PortalCreator portalCreator) {
        this.level = level;
        this.portalBlock = portal;
        this.portalPoi = portalPoi;
        this.frameBlock = frameBlock;
        this.portalCreator = portalCreator;
    }

    public Optional<BlockPos> findClosestPortalPosition(BlockPos exitPos, int searchRadius, WorldBorder worldBorder) {
        PoiManager poiManager = this.level.getPoiManager();
        poiManager.ensureLoadedAndValid((LevelReader)this.level, exitPos, searchRadius);
        return poiManager.getInSquare(poi -> poi.is(this.portalPoi), exitPos, searchRadius, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(arg_0 -> ((WorldBorder)worldBorder).isWithinBounds(arg_0)).filter(p -> this.level.getBlockState(p).hasProperty(GelPortalBlock.AXIS)).min(Comparator.comparingDouble(p -> p.distSqr((Vec3i)exitPos)).thenComparingInt(Vec3i::getY));
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(GelPortalForcer portalForcer, BlockPos pos, Direction.Axis axis) {
        return this.portalCreator.create(this, pos, axis);
    }

    @FunctionalInterface
    public static interface PortalCreator {
        public static final PortalCreator NETHER_LOGIC = new NetherPortalCreator(70, false);
        public static final PortalCreator SURFACE_BIASED = new NetherPortalCreator(70, true);

        public Optional<BlockUtil.FoundRectangle> create(GelPortalForcer var1, BlockPos var2, Direction.Axis var3);

        public static class NetherPortalCreator
        implements PortalCreator {
            protected final int defaultHeight;
            protected final boolean alwaysOnTopBlock;

            public NetherPortalCreator(int defaultHeight, boolean alwaysOnTopBlock) {
                this.defaultHeight = defaultHeight;
                this.alwaysOnTopBlock = alwaysOnTopBlock;
            }

            @Override
            public Optional<BlockUtil.FoundRectangle> create(GelPortalForcer portalForcer, BlockPos pos, Direction.Axis axis) {
                Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
                ServerLevel level = portalForcer.level;
                FoundPortalSpot found = this.findPosition(portalForcer, pos, axis, direction, level);
                return this.createPortal(portalForcer, pos, found.foundPos, found.dist, axis, direction, level, UnaryOperator.identity());
            }

            protected FoundPortalSpot findPosition(GelPortalForcer portalForcer, BlockPos pos, Direction.Axis axis, Direction direction, ServerLevel level) {
                double dist = -1.0;
                BlockPos foundPos = null;
                double alternativeDist = -1.0;
                BlockPos alternativeFoundPos = null;
                WorldBorder worldBorder = level.getWorldBorder();
                int maxHeight = Math.min(level.getMaxY(), level.getMinY() + level.getLogicalHeight() - 1);
                int portalWidth = 1;
                BlockPos.MutableBlockPos mutablePos = pos.mutable();
                GelPortalBlock.GelPortalSize size = portalForcer.portalBlock.getSizeRules();
                int minWidth = size.minWidth();
                int minHeight = size.minHeight();
                block0: for (BlockPos.MutableBlockPos searchPos : BlockPos.spiralAround((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
                    int surfaceHeight = Math.min(maxHeight, level.getHeight(Heightmap.Types.MOTION_BLOCKING, searchPos.getX(), searchPos.getZ()));
                    if (!worldBorder.isWithinBounds((BlockPos)searchPos) || !worldBorder.isWithinBounds((BlockPos)searchPos.move(direction, portalWidth))) continue;
                    searchPos.move(direction.getOpposite(), portalWidth);
                    for (int h = surfaceHeight; h >= level.getMinY(); --h) {
                        int hDelta;
                        searchPos.setY(h);
                        if (!this.canPortalReplaceBlock(level, searchPos)) continue;
                        int hCopy = h;
                        while (h > level.getMinY() && (this.canPortalReplaceBlock(level, searchPos.move(Direction.DOWN)) || this.shouldIgnoreForHeight(level, (BlockPos)searchPos))) {
                            --h;
                        }
                        if (h + 4 > maxHeight || (hDelta = hCopy - h) > 0 && hDelta < 3) continue;
                        searchPos.setY(h);
                        if (!this.canHostFrame(level, (BlockPos)searchPos, mutablePos, direction, 0, minWidth, minHeight)) continue;
                        double distToStart = pos.distSqr((Vec3i)searchPos);
                        if (this.canHostFrame(level, (BlockPos)searchPos, mutablePos, direction, -1, minWidth, minHeight) && this.canHostFrame(level, (BlockPos)searchPos, mutablePos, direction, 1, minWidth, minHeight) && (dist == -1.0 || dist > distToStart)) {
                            dist = distToStart;
                            foundPos = searchPos.immutable();
                            if (this.alwaysOnTopBlock) break block0;
                        }
                        if (dist != -1.0 || alternativeDist != -1.0 && !(alternativeDist > distToStart)) continue;
                        alternativeDist = distToStart;
                        alternativeFoundPos = searchPos.immutable();
                    }
                }
                if (dist == -1.0 && alternativeDist != -1.0) {
                    foundPos = alternativeFoundPos;
                    dist = alternativeDist;
                }
                return new FoundPortalSpot(foundPos, dist);
            }

            protected Optional<BlockUtil.FoundRectangle> createPortal(GelPortalForcer portalForcer, BlockPos pos, BlockPos foundPos, double dist, Direction.Axis axis, Direction direction, ServerLevel level, UnaryOperator<BlockState> portalState) {
                WorldBorder worldBorder = level.getWorldBorder();
                int maxHeight = Math.min(level.getMaxY(), level.getMinY() + level.getLogicalHeight() - 1);
                BlockPos.MutableBlockPos mutablePos = pos.mutable();
                GelPortalBlock.GelPortalSize size = portalForcer.portalBlock.getSizeRules();
                int minWidth = size.minWidth();
                int minHeight = size.minHeight();
                boolean shouldMakePlatform = false;
                if (dist == -1.0) {
                    int heighest = maxHeight - 9;
                    int lowest = Math.max(level.getMinY() + 1, this.getDefaultHeight());
                    if (heighest < lowest) {
                        return Optional.empty();
                    }
                    foundPos = new BlockPos(pos.getX() - direction.getStepX() * 1, Mth.clamp((int)pos.getY(), (int)lowest, (int)heighest), pos.getZ() - direction.getStepZ() * 1).immutable();
                    foundPos = worldBorder.clampToBounds(foundPos);
                    shouldMakePlatform = true;
                }
                if (shouldMakePlatform || this.alwaysOnTopBlock && this.isOverWater(level, foundPos.immutable(), direction)) {
                    Direction direction1 = direction.getClockWise();
                    for (int i = -1; i < 2; ++i) {
                        for (int w = 0; w < minWidth; ++w) {
                            for (int y = -1; y < minHeight; ++y) {
                                BlockState state = y < 0 ? portalForcer.frameBlock : Blocks.AIR.defaultBlockState();
                                mutablePos.setWithOffset((Vec3i)foundPos, w * direction.getStepX() + i * direction1.getStepX(), y, w * direction.getStepZ() + i * direction1.getStepZ());
                                level.setBlockAndUpdate((BlockPos)mutablePos, state);
                            }
                        }
                    }
                }
                for (int w = -1; w < minWidth + 1; ++w) {
                    for (int y = -1; y < minHeight + 1; ++y) {
                        if (w != -1 && w != minWidth && y != -1 && y != minHeight) continue;
                        mutablePos.setWithOffset((Vec3i)foundPos, w * direction.getStepX(), y, w * direction.getStepZ());
                        level.setBlock((BlockPos)mutablePos, portalForcer.frameBlock, 3);
                    }
                }
                BlockState portal = (BlockState)portalState.apply((BlockState)portalForcer.portalBlock.defaultBlockState().setValue(GelPortalBlock.AXIS, (Comparable)axis));
                for (int w = 0; w < minWidth; ++w) {
                    for (int y = 0; y < minHeight; ++y) {
                        mutablePos.setWithOffset((Vec3i)foundPos, w * direction.getStepX(), y, w * direction.getStepZ());
                        level.setBlock((BlockPos)mutablePos, portal, 18);
                    }
                }
                return Optional.of(new BlockUtil.FoundRectangle(foundPos.immutable(), minWidth, minHeight));
            }

            public boolean isOverWater(ServerLevel level, BlockPos pos, Direction direction) {
                return level.getBlockState(pos.below()).liquid() && level.getBlockState(pos.below().relative(direction)).liquid();
            }

            public boolean canPortalReplaceBlock(ServerLevel level, BlockPos.MutableBlockPos pos) {
                BlockState state = level.getBlockState((BlockPos)pos);
                return state.canBeReplaced() && state.getFluidState().isEmpty();
            }

            public boolean canHostFrame(ServerLevel level, BlockPos searchPos, BlockPos.MutableBlockPos mutablePos, Direction dir, int offsetScale, int minWidth, int minHeight) {
                Direction direction = dir.getClockWise();
                for (int i = -1; i < minWidth + 1; ++i) {
                    for (int y = -1; y < minHeight + 1; ++y) {
                        mutablePos.setWithOffset((Vec3i)searchPos, dir.getStepX() * i + direction.getStepX() * offsetScale, y, dir.getStepZ() * i + direction.getStepZ() * offsetScale);
                        if (y < 0 && !this.alwaysOnTopBlock && !level.getBlockState((BlockPos)mutablePos).isSolid()) {
                            return false;
                        }
                        if (y < 0 || this.canPortalReplaceBlock(level, mutablePos)) continue;
                        return false;
                    }
                }
                return true;
            }

            public int getDefaultHeight() {
                return this.defaultHeight;
            }

            public boolean shouldIgnoreForHeight(ServerLevel level, BlockPos pos) {
                if (!this.alwaysOnTopBlock) {
                    return false;
                }
                BlockState state = level.getBlockState(pos);
                return state.is(BlockTags.LEAVES) || state.is(BlockTags.LOGS) || level.isEmptyBlock(pos) || state.getCollisionShape((BlockGetter)level, pos).isEmpty() && !state.liquid();
            }

            public record FoundPortalSpot(BlockPos foundPos, double dist) {
            }
        }
    }
}

