/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.events;

import com.legacy.structure_gel.core.StructureGelMod;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;

public class RegisterArmorTrimTexturesEvent
extends Event
implements IModBusEvent {
    private static final String darkerSuffix = "_darker";
    private final Set<ResourceLocation> armorPatterns;
    private final Set<ResourceLocation> patterns;
    private final Map<String, ResourceLocation> trimMaterials;
    private final Map<ResourceKey<TrimMaterial>, Integer> materialLight;

    public RegisterArmorTrimTexturesEvent(Set<ResourceLocation> armorPatterns, Set<ResourceLocation> patterns, Map<String, ResourceLocation> trimMaterials, Map<ResourceKey<TrimMaterial>, Integer> materialLight) {
        this.armorPatterns = armorPatterns;
        this.patterns = patterns;
        this.trimMaterials = trimMaterials;
        this.materialLight = materialLight;
    }

    public void registerPatternSprite(ResourceKey<TrimPattern> trimPattern) {
        this.registerPatternSprite(trimPattern.location());
    }

    public void registerPatternSprite(ResourceLocation trimPattern) {
        if (!this.armorPatterns.add(trimPattern)) {
            StructureGelMod.LOGGER.warn("Registered an armor trim pattern sprite that overrides an existing pattern. " + String.valueOf(trimPattern), new Object[0]);
        }
    }

    public void registerSprite(ResourceLocation trimPattern) {
        if (!this.patterns.add(trimPattern)) {
            StructureGelMod.LOGGER.warn("Registered an armor trim pattern sprite that overrides an existing pattern. " + String.valueOf(trimPattern), new Object[0]);
        }
    }

    public void registerMaterialSprite(ResourceKey<TrimMaterial> materialID, boolean withDarker) {
        this.registerMaterialSprite(materialID.location().getPath(), materialID.location(), withDarker);
    }

    public void registerMaterialSprite(String assetName, ResourceLocation materialID, boolean withDarker) {
        if (this.trimMaterials.put(assetName, materialID) != null) {
            StructureGelMod.LOGGER.warn("Registered an armor trim material palette that overrides an existing palette. asset_name=" + assetName + ", material_id=" + String.valueOf(materialID), new Object[0]);
        }
        if (withDarker && this.trimMaterials.put(assetName + darkerSuffix, materialID.withSuffix(darkerSuffix)) != null) {
            StructureGelMod.LOGGER.warn("Registered an armor trim material palette that overrides an existing palette. asset_name=" + assetName + "_darker, material_id=" + String.valueOf(materialID.withSuffix(darkerSuffix)), new Object[0]);
        }
    }

    public void registerMaterialBrightness(ResourceKey<TrimMaterial> material, int brightness) {
        this.materialLight.put(material, brightness);
    }
}

