/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.data.tags.FilterHolderSet;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.api.structure.GridStructurePlacement;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureRegistrar<S extends Structure> {
    private final ResourceLocation registryName;
    private final Supplier<StructureType<S>> structureType;
    private final Map<String, Registrar.Pointer<S>> structures;
    private final Map<String, Registrar.Static<StructurePieceType>> pieceTypes;
    private final Registrar.Pointer<StructureSet> structureSet;

    protected StructureRegistrar(Builder<S> builder) {
        this.registryName = builder.registryName;
        String modID = this.registryName.getNamespace();
        RegistrarHandler typeHandler = RegistrarHandler.getOrCreate(Registries.STRUCTURE_TYPE, modID);
        RegistrarHandler pieceHandler = RegistrarHandler.getOrCreate(Registries.STRUCTURE_PIECE, modID);
        RegistrarHandler structureHandler = RegistrarHandler.getOrCreate(Registries.STRUCTURE, modID);
        RegistrarHandler setHandler = RegistrarHandler.getOrCreate(Registries.STRUCTURE_SET, modID);
        this.structureType = !builder.existingType ? typeHandler.createStatic(ResourceKey.create((ResourceKey)Registries.STRUCTURE_TYPE, (ResourceLocation)this.registryName), builder.type) : builder.type;
        this.pieceTypes = builder.pieceTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> pieceHandler.createStatic(ResourceKey.create((ResourceKey)Registries.STRUCTURE_PIECE, (ResourceLocation)StructureRegistrar.createName(this.registryName, (String)e.getKey())), (Supplier)e.getValue())));
        this.structures = builder.structureBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> structureHandler.createPointer(ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)StructureRegistrar.createName(this.registryName, (String)e.getKey())), ((StructureBuilder)e.getValue())::build)));
        this.structureSet = setHandler.createPointer(ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)this.registryName), bootstrapContext -> {
            ArrayList structureWeights = new ArrayList();
            HolderGetter structureRegistry = bootstrapContext.lookup(Registries.STRUCTURE);
            builder.structureBuilders.forEach((name, structureBuilder) -> {
                Optional structure = this.structures.get(name).getHolder(structureRegistry);
                if (structure.isPresent()) {
                    Holder holder = (Holder)structure.get();
                    structureWeights.add(StructureSet.entry((Holder)holder, (int)structureBuilder.weight));
                }
            });
            StructurePlacement placement = builder.structurePlacement.apply((BootstrapContext<?>)bootstrapContext);
            if (placement == null) {
                throw new NullPointerException("Cannot register " + String.valueOf(this.registryName) + " without having a StructurePlacement set. If this used to be a GelStructure, GridStructurePlacement replaces that system.");
            }
            return new StructureSet(structureWeights, placement);
        });
        builder.structureBuilders.forEach((name, structureBuilder) -> {
            Registrar.Pointer<S> registrar = this.structures.get(name);
            if (registrar != null) {
                ResourceKey key = registrar.getKey();
                if (structureBuilder.dimensions != null) {
                    StructureAccessHelper.addValidDimensions(key, structureBuilder.dimensions);
                }
                if (structureBuilder.lakeProof) {
                    StructureAccessHelper.setLakeProof(key);
                }
            }
        });
    }

    public static <S extends Structure> Builder<S> builder(ResourceLocation registryName, Supplier<StructureType<S>> structureType) {
        return new Builder<S>(registryName, structureType, false);
    }

    public static <S extends Structure> Builder<S> existingTypeBuilder(ResourceLocation registryName, Supplier<StructureType<S>> structureType) {
        return new Builder<S>(registryName, structureType, true);
    }

    public static Builder<ExtendedJigsawStructure> jigsawBuilder(ResourceLocation registryName) {
        return StructureRegistrar.existingTypeBuilder(registryName, SGRegistry.StructureTypes.EXTENDED_JIGSAW);
    }

    public StructureType<S> getType() {
        return this.structureType.get();
    }

    public Map<String, Registrar.Static<StructurePieceType>> getPieceTypes() {
        return this.pieceTypes;
    }

    @Nullable
    public Registrar.Static<StructurePieceType> getPieceType(String name) {
        return this.getPieceTypes().get(name);
    }

    public Registrar.Static<StructurePieceType> getPieceType() throws IllegalArgumentException {
        if (this.getPieceTypes().size() == 1) {
            return (Registrar.Static)this.getPieceTypes().values().toArray()[0];
        }
        throw new IllegalArgumentException(String.format("The structure %s has more than one piece type associated with it. A String must be passed to define which one to get.", this.registryName));
    }

    public Map<String, Registrar.Pointer<S>> getStructures() {
        return this.structures;
    }

    @Nullable
    public Registrar.Pointer<Structure> getStructure(String name) {
        return this.getStructureExact(name);
    }

    @Nullable
    public Registrar.Pointer<Structure> getStructure() throws IllegalArgumentException {
        return this.getStructureExact();
    }

    @Nullable
    public Registrar.Pointer<S> getStructureExact(String name) {
        return this.getStructures().get(name);
    }

    @Nullable
    public Registrar.Pointer<S> getStructureExact() throws IllegalArgumentException {
        Map<String, Registrar.Pointer<S>> structures = this.getStructures();
        int size = structures.size();
        if (size == 1) {
            return (Registrar.Pointer)structures.values().toArray()[0];
        }
        if (size < 1) {
            return null;
        }
        throw new IllegalArgumentException(String.format("The structure %s has more than one configured structure feature associated with it. A String must be passed to define which one to get.", this.registryName));
    }

    @Nullable
    public Registrar.Pointer<StructureSet> getStructureSet() {
        return this.structureSet;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    private static ResourceLocation createName(ResourceLocation name, String suffix) {
        return suffix.isEmpty() ? name : ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)(name.getPath() + "_" + suffix));
    }

    public static class Builder<S extends Structure> {
        private final ResourceLocation registryName;
        @Nullable
        private final Supplier<StructureType<S>> type;
        private final boolean existingType;
        private final Map<String, StructureBuilder<S>> structureBuilders = new HashMap<String, StructureBuilder<S>>();
        private final Map<String, Supplier<StructurePieceType>> pieceTypes = new HashMap<String, Supplier<StructurePieceType>>();
        private Function<BootstrapContext<?>, StructurePlacement> structurePlacement;

        private Builder(ResourceLocation registryName, @Nullable Supplier<StructureType<S>> type, boolean existingType) {
            this.registryName = registryName;
            this.type = type;
            this.existingType = existingType;
            this.structurePlacement = c -> GridStructurePlacement.builder(16, 0.8f).build(this.registryName);
        }

        public StructureBuilder<S> pushStructure(BiFunction<BootstrapContext<?>, Structure.StructureSettings, S> structureFactory) {
            return this.pushStructure("", structureFactory);
        }

        public StructureBuilder<S> pushStructure(String name, BiFunction<BootstrapContext<?>, Structure.StructureSettings, S> structureFactory) {
            return new StructureBuilder<S>(this, structureFactory, name);
        }

        public StructureBuilder<S> pushStructure(BiFunction<BootstrapContext<?>, Structure.StructureSettings, S> structureFactory, Consumer<StructureBuilder<S>> builderConsumer) {
            return this.pushStructure("", structureFactory, builderConsumer);
        }

        public StructureBuilder<S> pushStructure(String name, BiFunction<BootstrapContext<?>, Structure.StructureSettings, S> structureFactory, Consumer<StructureBuilder<S>> builderConsumer) {
            StructureBuilder<S> structureBuilder = this.pushStructure(name, structureFactory);
            builderConsumer.accept(structureBuilder);
            return structureBuilder;
        }

        public StructureBuilder<S> pushStructure(Function<Structure.StructureSettings, S> structureFactory) {
            return this.pushStructure("", (BootstrapContext<?> c, Structure.StructureSettings s) -> (Structure)structureFactory.apply((Structure.StructureSettings)s));
        }

        public StructureBuilder<S> pushStructure(String name, Function<Structure.StructureSettings, S> structureFactory) {
            return this.pushStructure(name, (BootstrapContext<?> c, Structure.StructureSettings s) -> (Structure)structureFactory.apply((Structure.StructureSettings)s));
        }

        public StructureBuilder<S> pushStructure(Function<Structure.StructureSettings, S> structureFactory, Consumer<StructureBuilder<S>> builderConsumer) {
            return this.pushStructure("", (BootstrapContext<?> c, Structure.StructureSettings s) -> (Structure)structureFactory.apply((Structure.StructureSettings)s), builderConsumer);
        }

        public StructureBuilder<S> pushStructure(String name, Function<Structure.StructureSettings, S> structureFactory, Consumer<StructureBuilder<S>> builderConsumer) {
            return this.pushStructure(name, (BootstrapContext<?> c, Structure.StructureSettings s) -> (Structure)structureFactory.apply((Structure.StructureSettings)s));
        }

        private Builder<S> addStructureBuilder(StructureBuilder<S> structureBuilder) throws IllegalArgumentException {
            if (this.structureBuilders.put(structureBuilder.name, structureBuilder) != null) {
                throw new IllegalArgumentException(this.errMsg("added a Structure under an existing name \"" + structureBuilder.name + "\""));
            }
            return this;
        }

        public Builder<S> addPiece(String name, Supplier<StructurePieceType> pieceType) throws IllegalArgumentException {
            if (this.pieceTypes.put(name, pieceType) != null) {
                throw new IllegalArgumentException(this.errMsg("added a StructurePieceType under an existing name \"" + name + "\""));
            }
            return this;
        }

        public Builder<S> addPiece(Supplier<StructurePieceType> pieceType) throws IllegalArgumentException {
            return this.addPiece("", pieceType);
        }

        public Builder<S> placement(Supplier<StructurePlacement> structurePlacement) {
            return this.placement((BootstrapContext<?> c) -> (StructurePlacement)structurePlacement.get());
        }

        public Builder<S> placement(Function<BootstrapContext<?>, StructurePlacement> structurePlacement) {
            this.structurePlacement = structurePlacement;
            return this;
        }

        public StructureRegistrar<S> build() throws IllegalStateException {
            if (this.structureBuilders.isEmpty()) {
                throw new IllegalStateException(this.errMsg("has no Structure"));
            }
            return new StructureRegistrar(this);
        }

        private String errMsg(String msg) {
            return "The StructureRegistrar.Builder \"" + String.valueOf(this.registryName) + "\" " + msg;
        }
    }

    public static class StructureBuilder<S extends Structure> {
        private final Builder<S> parentBuilder;
        private final String name;
        private final BiFunction<BootstrapContext<?>, Structure.StructureSettings, S> structureFactory;
        private Function<BootstrapContext<?>, HolderSet<Biome>> biomes = c -> c.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_OVERWORLD);
        private TerrainAdjustment terrainAdjustment = TerrainAdjustment.NONE;
        private GenerationStep.Decoration generationStep = GenerationStep.Decoration.SURFACE_STRUCTURES;
        private Map<MobCategory, Supplier<StructureSpawnOverride>> spawns = new HashMap<MobCategory, Supplier<StructureSpawnOverride>>();
        private int weight = 1;
        @Nullable
        private Collection<ResourceKey<Level>> dimensions = null;
        private boolean lakeProof = true;

        private StructureBuilder(Builder<S> parentBuilder, BiFunction<BootstrapContext<?>, Structure.StructureSettings, S> structureFactory, String name) {
            this.parentBuilder = parentBuilder;
            this.structureFactory = structureFactory;
            this.name = name;
        }

        public final StructureBuilder<S> biomes(Function<BootstrapContext<?>, HolderSet<Biome>> biomes) {
            this.biomes = biomes;
            return this;
        }

        public final StructureBuilder<S> biomes(Supplier<FilterHolderSet.Builder<Biome>> biomes) {
            return this.biomes((BootstrapContext<?> c) -> ((FilterHolderSet.Builder)biomes.get()).build(c.lookup(Registries.BIOME)));
        }

        @SafeVarargs
        public final StructureBuilder<S> biomes(ResourceKey<Biome> ... biomes) {
            return this.biomes((BootstrapContext<?> c) -> HolderSet.direct(Arrays.stream(biomes).map(arg_0 -> ((HolderGetter)c.lookup(Registries.BIOME)).getOrThrow(arg_0)).toList()));
        }

        public final StructureBuilder<S> biomes(TagKey<Biome> tagKey) {
            return this.biomes((BootstrapContext<?> c) -> c.lookup(Registries.BIOME).getOrThrow(tagKey));
        }

        public final StructureBuilder<S> spawns(MobCategory category, Supplier<StructureSpawnOverride> spawnPool) {
            this.spawns.put(category, spawnPool);
            return this;
        }

        public final StructureBuilder<S> spawns(MobCategory category, StructureSpawnOverride.BoundingBoxType boundingBoxType, Supplier<List<MobSpawnSettings.SpawnerData>> spawns) {
            return this.spawns(category, () -> new StructureSpawnOverride(boundingBoxType, WeightedRandomList.create((List)((List)spawns.get()))));
        }

        public final StructureBuilder<S> noSpawns(StructureSpawnOverride.BoundingBoxType boundingBoxType, MobCategory ... categories) {
            for (MobCategory category : categories.length == 0 ? MobCategory.values() : categories) {
                this.spawns(category, boundingBoxType, () -> Collections.emptyList());
            }
            return this;
        }

        public final StructureBuilder<S> terrainAdjustment(TerrainAdjustment terrainAdjustment) {
            this.terrainAdjustment = terrainAdjustment;
            return this;
        }

        public final StructureBuilder<S> generationStep(GenerationStep.Decoration generationStep) {
            this.generationStep = generationStep;
            return this;
        }

        public final StructureBuilder<S> weight(int weight) {
            this.weight = weight;
            return this;
        }

        @SafeVarargs
        public final StructureBuilder<S> dimensions(ResourceKey<Level> ... dimensions) {
            this.dimensions = List.of(dimensions);
            return this;
        }

        public final StructureBuilder<S> lakeProof(boolean lakeProof) {
            this.lakeProof = lakeProof;
            return this;
        }

        public final Builder<S> popStructure() throws IllegalStateException {
            this.parentBuilder.addStructureBuilder(this);
            return this.parentBuilder;
        }

        private S build(BootstrapContext<?> context) {
            return (S)((Structure)this.structureFactory.apply(context, new Structure.StructureSettings(this.biomes.apply(context), this.spawns.entrySet().stream().filter(e -> ((Supplier)e.getValue()).get() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> (StructureSpawnOverride)((Supplier)e.getValue()).get())), this.generationStep, this.terrainAdjustment)));
        }
    }
}

