/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapabilityType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public interface JigsawCapability {
    public static final Codec<JigsawCapability> CODEC = StructureGelRegistries.JIGSAW_TYPE.byNameCodec().dispatch(JigsawCapability::getType, JigsawCapabilityType::codec);

    public JigsawCapabilityType<?> getType();

    default public boolean canPlace(Structure.GenerationContext generationContext, BlockPos placementPos, ExtendedJigsawStructure.PlaceContext placeContext) {
        return true;
    }

    default public IPieceFactory getPieceFactory() {
        return IPieceFactory.VANILLA;
    }

    default public void modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, Structure.GenerationContext context) {
    }

    public static final class Vanilla
    implements JigsawCapability {
        public static final Vanilla INSTANCE = new Vanilla();
        public static final MapCodec<Vanilla> CODEC = MapCodec.unit((Object)INSTANCE);

        @Override
        public JigsawCapabilityType<?> getType() {
            return null;
        }

        public String toString() {
            return "Vanilla Capability";
        }
    }
}

