/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.processor;

import com.legacy.structure_gel.api.block.gel.StructureGelBlock;
import com.legacy.structure_gel.api.data.tags.SGTags;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class RemoveGelStructureProcessor
extends StructureProcessor {
    public static final RemoveGelStructureProcessor INSTANCE = new RemoveGelStructureProcessor();
    public static final MapCodec<RemoveGelStructureProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    private RemoveGelStructureProcessor() {
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader level, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo existing, StructureTemplate.StructureBlockInfo placed, StructurePlaceSettings settings) {
        if (placed.state().is(SGTags.BlockTags.GEL)) {
            BlockState blockState;
            BlockPos blockPos = placed.pos();
            Block block = placed.state().getBlock();
            if (block instanceof StructureGelBlock) {
                StructureGelBlock gel = (StructureGelBlock)block;
                blockState = gel.getReplacementState();
            } else {
                blockState = Blocks.AIR.defaultBlockState();
            }
            return new StructureTemplate.StructureBlockInfo(blockPos, blockState, null);
        }
        return placed.state().is(Blocks.AIR) ? null : placed;
    }

    protected StructureProcessorType<?> getType() {
        return SGRegistry.Processors.REMOVE_FILLER.get();
    }
}

