/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.DynamicSpawnerBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DynamicSpawnerBlock
extends BaseEntityBlock {
    public static final MapCodec<DynamicSpawnerBlock> CODEC = DynamicSpawnerBlock.simpleCodec(DynamicSpawnerBlock::new);

    public DynamicSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DynamicSpawnerBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DynamicSpawnerBlockEntity) {
            DynamicSpawnerBlockEntity spawner = (DynamicSpawnerBlockEntity)blockEntity;
            if (player.canUseGameMasterBlocks()) {
                if (level.isClientSide) {
                    StructureGelMod.proxy.openDynamicSpawnerScreen(spawner);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return DynamicSpawnerBlock.createTickerHelper(type, SGRegistry.BlockEntities.DYNAMIC_SPAWNER.get(), (BlockEntityTicker)(level.isClientSide ? DynamicSpawnerBlockEntity::clientTick : DynamicSpawnerBlockEntity::serverTick));
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity breaker, ItemStack tool) {
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof DynamicSpawnerBlockEntity) {
            DynamicSpawnerBlockEntity spawner = (DynamicSpawnerBlockEntity)blockEntity2;
            DynamicSpawnerBlockEntity.ExpRange range = spawner.getExpRange();
            int min = range.min;
            int max = range.max;
            int r = (max - min) / 2 + 1;
            RandomSource rand = level.getRandom();
            return min + rand.nextInt(r) + rand.nextInt(r);
        }
        return Blocks.SPAWNER.getExpDrop(Blocks.SPAWNER.defaultBlockState(), level, pos, blockEntity, breaker, tool);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lore, TooltipFlag showAdvanced) {
        if (Screen.hasShiftDown()) {
            lore.add((Component)Component.translatable((String)"info.structure_gel.dynamic_spawner_description").withStyle(ChatFormatting.GRAY));
        } else {
            lore.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"info.structure_gel.hold_shift")));
            CustomData beData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (beData != null) {
                lore.add((Component)SGText.NEW_LINE);
                CompoundTag beTag = beData.copyTag();
                String typeName = beTag.getString("SpawnerID");
                if (!typeName.isBlank()) {
                    lore.add((Component)SGText.BULLET_POINT.copy().withStyle(ChatFormatting.GRAY).append((Component)SGText.TYPE_LABEL.copy().withStyle(SGText.VALUE_LABEL_STYLE)).append((Component)Component.literal((String)(": " + typeName))));
                }
                if (beTag.contains("exp_range", 10)) {
                    DynamicSpawnerBlockEntity.ExpRange range = DynamicSpawnerBlockEntity.ExpRange.load(beTag.getCompound("exp_range"));
                    lore.add((Component)SGText.BULLET_POINT.copy().withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"gui.structure_gel.dynamic_spawner.exp_range").withStyle(SGText.VALUE_LABEL_STYLE)).append((Component)Component.literal((String)(": " + range.min + " - " + range.max))));
                }
            }
        }
    }
}

