/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block_entity;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.SGBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DataHandlerBlockEntity
extends SGBlockEntity {
    private WeightedRandomList<RawHandler> handlers = WeightedRandomList.create();
    private Component name = null;
    private boolean useGravity = false;
    private boolean markPostProcessing = false;
    private Vec3 offset = Vec3.ZERO;
    public static final String HANDLERS_KEY = "handlers";
    public static final String USE_GRAVITY_KEY = "use_gravity";
    public static final String MARK_POST_PROCESSING_KEY = "mark_post_processing";
    public static final String OFFSET_KEY = "offset";
    public static final String CUSTOM_NAME_KEY = "CustomName";

    public DataHandlerBlockEntity(BlockPos pos, BlockState state) {
        super(SGRegistry.BlockEntities.DATA_HANDLER.get(), pos, state);
    }

    public WeightedRandomList<RawHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(WeightedRandomList<RawHandler> handlers) {
        this.handlers = handlers;
        this.setChanged();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public void setCustomName(@Nullable Component name) {
        this.name = name;
    }

    public boolean useGravity() {
        return this.useGravity;
    }

    public void setUseGravity(boolean useGravity) {
        this.useGravity = useGravity;
    }

    public boolean shouldMarkPostProcessing() {
        return this.markPostProcessing;
    }

    public void setMarkPostProcessing(boolean markPostProcessing) {
        this.markPostProcessing = markPostProcessing;
    }

    public Vec3 getOffset() {
        return this.offset;
    }

    public void setOffset(Vec3 offset) {
        this.offset = offset;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        ListTag listTag = new ListTag();
        for (RawHandler handler : this.handlers.unwrap()) {
            CompoundTag handlerTag = new CompoundTag();
            handler.trySave(handlerTag);
            listTag.add((Object)handlerTag);
        }
        tag.put(HANDLERS_KEY, (Tag)listTag);
        if (this.name != null) {
            tag.putString(CUSTOM_NAME_KEY, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)lookup));
        }
        tag.putBoolean(USE_GRAVITY_KEY, this.useGravity);
        tag.putBoolean(MARK_POST_PROCESSING_KEY, this.markPostProcessing);
        CompoundTag offsetTag = new CompoundTag();
        offsetTag.putDouble("x", this.offset.x);
        offsetTag.putDouble("y", this.offset.y);
        offsetTag.putDouble("z", this.offset.z);
        tag.put(OFFSET_KEY, (Tag)offsetTag);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.handlers = DataHandlerBlockEntity.loadAllHandlers(tag);
        this.name = tag.contains(CUSTOM_NAME_KEY, 8) ? Component.Serializer.fromJson((String)tag.getString(CUSTOM_NAME_KEY), (HolderLookup.Provider)lookup) : null;
        this.useGravity = tag.getBoolean(USE_GRAVITY_KEY);
        this.markPostProcessing = tag.getBoolean(MARK_POST_PROCESSING_KEY);
        this.offset = DataHandlerBlockEntity.loadOffset(tag);
    }

    public static WeightedRandomList<RawHandler> loadAllHandlers(CompoundTag tag) {
        ArrayList<RawHandler> handlers = new ArrayList<RawHandler>();
        Optional<RawHandler> legacyHandler = RawHandler.tryLoad(tag);
        if (legacyHandler.isPresent()) {
            handlers.add(legacyHandler.get());
        }
        handlers.addAll(DataHandlerBlockEntity.readHandlerList(tag));
        return WeightedRandomList.create(handlers);
    }

    public static boolean loadUseGravity(CompoundTag tag) {
        return tag.getBoolean(USE_GRAVITY_KEY);
    }

    public static boolean loadMarkPostProcessing(CompoundTag tag) {
        return tag.getBoolean(MARK_POST_PROCESSING_KEY);
    }

    public static Vec3 loadOffset(CompoundTag tag) {
        CompoundTag offsetTag = tag.getCompound(OFFSET_KEY);
        return new Vec3(offsetTag.getDouble("x"), offsetTag.getDouble("y"), offsetTag.getDouble("z"));
    }

    private static List<RawHandler> readHandlerList(CompoundTag tag) {
        ArrayList<RawHandler> handlerList = new ArrayList<RawHandler>();
        if (tag.contains(HANDLERS_KEY, 9)) {
            ListTag listTag = tag.getList(HANDLERS_KEY, 10);
            for (Tag t : listTag) {
                CompoundTag handlerTag;
                Optional<RawHandler> handler;
                if (!(t instanceof CompoundTag) || !(handler = RawHandler.tryLoad(handlerTag = (CompoundTag)t)).isPresent()) continue;
                handlerList.add(handler.get());
            }
        }
        return handlerList;
    }

    public record RawHandler(Weight weight, ResourceLocation typeName, LinkedHashMap<String, String> dataEntries) implements WeightedEntry
    {
        public static final RawHandler EMPTY = new RawHandler(Weight.of((int)1), ResourceLocation.withDefaultNamespace((String)""), new LinkedHashMap<String, String>());
        public static final String WEIGHT_KEY = "weight";
        public static final String TYPE_KEY = "type";
        public static final String ENTRIES_KEY = "entries";

        public static Optional<RawHandler> tryLoad(CompoundTag tag) {
            ResourceLocation type = RawHandler.readType(tag);
            if (type == null) {
                return Optional.empty();
            }
            int weight = tag.contains(WEIGHT_KEY, 3) ? tag.getInt(WEIGHT_KEY) : 1;
            LinkedHashMap<String, String> data = RawHandler.readDataEntries(tag);
            return Optional.of(new RawHandler(Weight.of((int)weight), type, data));
        }

        @Nullable
        private static ResourceLocation readType(CompoundTag tag) {
            String str;
            ResourceLocation name;
            if (tag.contains(TYPE_KEY, 8) && (name = ResourceLocation.tryParse((String)(str = tag.getString(TYPE_KEY)))) != null) {
                return name;
            }
            return null;
        }

        private static LinkedHashMap<String, String> readDataEntries(CompoundTag tag) {
            LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
            CompoundTag dataTag = tag.getCompound(ENTRIES_KEY);
            for (String key : dataTag.getAllKeys()) {
                entries.put(key, dataTag.getString(key));
            }
            return entries;
        }

        public void trySave(CompoundTag tag) {
            if (this.typeName.getPath().isEmpty()) {
                return;
            }
            if (this.weight.asInt() != 1) {
                tag.putInt(WEIGHT_KEY, this.weight.asInt());
            }
            if (this.typeName != null) {
                tag.putString(TYPE_KEY, this.typeName.toString());
            }
            CompoundTag dataTag = new CompoundTag();
            for (Map.Entry<String, String> entry : this.dataEntries.entrySet()) {
                String value = entry.getValue();
                if (value.isEmpty()) continue;
                dataTag.putString(entry.getKey(), entry.getValue());
            }
            tag.put(ENTRIES_KEY, (Tag)dataTag);
        }

        @Nullable
        public DataHandler<?> tryBake(BlockPos pos, LevelReader level) {
            try {
                if (this.typeName != null) {
                    DataHandlerType type = (DataHandlerType)StructureGelRegistries.DATA_HANDLER_TYPE.getValue(this.typeName);
                    if (type != null) {
                        return type.create(type.getDataParser((HolderLookup.Provider)level.registryAccess()).parse(this.dataEntries, level));
                    }
                    StructureGelMod.LOGGER.error("{} is not a registered DataHandlerType", this.typeName);
                } else {
                    StructureGelMod.LOGGER.error("\type\" was null for the DataHandlerBlockEntity at {}", pos);
                }
            }
            catch (Exception e) {
                StructureGelMod.LOGGER.error("Couldn't deserialize DataHandler from {}", pos);
                StructureGelMod.LOGGER.error(e, new Object[0]);
            }
            return null;
        }

        public Weight getWeight() {
            return this.weight;
        }
    }
}

