/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block_entity;

import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.core.block_entity.SGBlockEntity;
import com.legacy.structure_gel.core.dynamic_spawner.DynamicSpawner;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DynamicSpawnerBlockEntity
extends SGBlockEntity
implements Spawner {
    public static final String SPAWNER_ID_KEY = "SpawnerID";
    public static final String SPAWNER_KEY = "Spawner";
    public static final String EXP_RANGE_KEY = "exp_range";
    private ResourceLocation spawnerID = SGRegistry.DynamicSpawnerTypes.DEFAULT.getName();
    private final DynamicSpawner spawner = new DynamicSpawner(){

        public Either<BlockEntity, Entity> getOwner() {
            return Either.left((Object)((Object)DynamicSpawnerBlockEntity.this));
        }
    };
    private ExpRange expRange = ExpRange.VANILLA;

    public DynamicSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super(SGRegistry.BlockEntities.DYNAMIC_SPAWNER.get(), pos, state);
    }

    public void setSpawner(DynamicSpawnerType type, HolderLookup.Provider lookup) {
        ResourceLocation newName = StructureGelRegistries.DYNAMIC_SPAWNER_TYPE.getKey((Object)type);
        if (newName != null && !newName.equals((Object)this.spawnerID)) {
            this.spawnerID = newName;
            this.spawner.copyFrom(type.create(lookup));
        }
    }

    public void setEntityId(EntityType<?> entityType, RandomSource random) {
    }

    public ResourceLocation getSpawnerID() {
        return this.spawnerID;
    }

    public void setExpRange(ExpRange maxInclusive) {
        this.expRange = maxInclusive;
        this.setChanged();
    }

    public ExpRange getExpRange() {
        return this.expRange;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        if (tag.contains(SPAWNER_ID_KEY, 8)) {
            ResourceLocation typeName = ResourceLocation.parse((String)tag.getString(SPAWNER_ID_KEY));
            if (tag.contains(SPAWNER_KEY, 10)) {
                this.spawnerID = typeName;
                this.spawner.load(this.level, this.worldPosition, tag.getCompound(SPAWNER_KEY));
            } else {
                this.setSpawner((DynamicSpawnerType)StructureGelRegistries.DYNAMIC_SPAWNER_TYPE.getValue(typeName), lookup);
            }
        }
        if (tag.contains(EXP_RANGE_KEY, 10)) {
            this.expRange = ExpRange.load(tag.getCompound(EXP_RANGE_KEY));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        if (this.spawnerID != null) {
            tag.putString(SPAWNER_ID_KEY, this.spawnerID.toString());
        }
        tag.put(EXP_RANGE_KEY, (Tag)this.expRange.save());
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (b, r) -> {
            CompoundTag tag = this.saveWithoutMetadata((HolderLookup.Provider)r);
            CompoundTag spawnerTag = this.spawner.save(new CompoundTag());
            tag.put(SPAWNER_KEY, (Tag)spawnerTag);
            return tag;
        });
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, DynamicSpawnerBlockEntity blockEntity) {
        blockEntity.spawner.clientTick(level, pos);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DynamicSpawnerBlockEntity blockEntity) {
        blockEntity.spawner.serverTick((ServerLevel)level, pos);
    }

    public boolean triggerEvent(int paramA, int paramB) {
        return this.spawner.onEventTriggered(this.level, paramA) ? true : super.triggerEvent(paramA, paramB);
    }

    public DynamicSpawner getSpawner() {
        return this.spawner;
    }

    public static class ExpRange {
        public static final String MIN_KEY = "min";
        public static final String MAX_KEY = "max";
        public static final ExpRange VANILLA = new ExpRange(15, 43);
        public final int min;
        public final int max;

        public ExpRange(int minInclusive, int maxInclusive) {
            this.min = Math.max(0, minInclusive);
            this.max = Math.max(this.min, maxInclusive);
        }

        public static ExpRange load(CompoundTag tag) {
            if (tag.contains(MIN_KEY, 3) && tag.contains(MAX_KEY, 3)) {
                return new ExpRange(tag.getInt(MIN_KEY), tag.getInt(MAX_KEY));
            }
            return VANILLA;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.putInt(MIN_KEY, this.min);
            tag.putInt(MAX_KEY, this.max);
            return tag;
        }
    }
}

