/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block_entity;

import com.legacy.structure_gel.api.block.gel.GelSpreadBehavior;
import com.legacy.structure_gel.api.block.gel.GelSpreadRestriction;
import com.legacy.structure_gel.api.block.gel.StructureGelBlock;
import com.legacy.structure_gel.core.block.GelSpreaderBlock;
import com.legacy.structure_gel.core.block_entity.SGBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class GelSpreaderBlockEntity
extends SGBlockEntity {
    private Direction.Axis axis = Direction.Axis.Y;
    private ItemStack placedBy = ItemStack.EMPTY;
    private ResourceKey<Block> gelKey = SGRegistry.Blocks.RED_GEL.getKey();
    @Nullable
    private StructureGelBlock gel;
    static final String GEL_KEY = "gel";
    private List<BlockPos> modifiedPositions = new ArrayList<BlockPos>();

    public GelSpreaderBlockEntity(BlockPos pos, BlockState state) {
        super(SGRegistry.BlockEntities.GEL_SPREADER.get(), pos, state);
        this.axis = (Direction.Axis)state.getValue(GelSpreaderBlock.AXIS);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString(GEL_KEY, this.gelKey.location().toString());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ResourceLocation gelName;
        super.loadAdditional(tag, registries);
        if (tag.contains(GEL_KEY, 8) && (gelName = ResourceLocation.tryParse((String)tag.getString(GEL_KEY))) != null) {
            this.gelKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)gelName);
        }
    }

    public void applyProperties(ItemStack stack, RegistryAccess registries) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.placedBy = stack.copy();
            this.setGel(registries.lookupOrThrow(Registries.BLOCK).getResourceKey((Object)blockItem.getBlock()));
        }
    }

    public StructureGelBlock getGel(HolderLookup.Provider registries) {
        if (this.gel == null) {
            Object object = registries.lookupOrThrow(Registries.BLOCK).getOrThrow(this.gelKey).value();
            if (object instanceof StructureGelBlock) {
                StructureGelBlock gel;
                this.gel = gel = (StructureGelBlock)((Object)object);
            } else {
                throw new IllegalStateException("The block " + String.valueOf(this.gelKey.location()) + " must be of type " + String.valueOf(SGRegistry.BlockTypes.GEL.getKey().location()));
            }
        }
        return this.gel;
    }

    public void setGel(Optional<ResourceKey<Block>> key) {
        if (key.isEmpty()) {
            return;
        }
        this.gelKey = key.get();
        this.gel = null;
    }

    private void tick(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.modifiedPositions.isEmpty()) {
            this.modifiedPositions.add(pos);
        }
        ArrayList<BlockPos> newlyPlaced = new ArrayList<BlockPos>();
        StructureGelBlock gel = this.getGel((HolderLookup.Provider)level.registryAccess());
        GelSpreadBehavior spreadBehavior = gel.getSpreadBehavior();
        List<GelSpreadRestriction> restrictions = gel.getSpreadRestrictions();
        Optional<Direction.Axis> axis = Optional.of(this.axis);
        for (BlockPos placedPos : this.modifiedPositions) {
            GelSpreadBehavior.Context context = new GelSpreadBehavior.Context(placedPos, axis);
            spreadBehavior.getSpreadOffsets(context).stream().map(arg_0 -> ((BlockPos)context.spreadFrom()).offset(arg_0)).filter(spreadPos -> {
                GelSpreadRestriction.Context rContext = new GelSpreadRestriction.Context((LevelReader)level, pos, this.placedBy, (BlockPos)spreadPos);
                for (GelSpreadRestriction r : restrictions) {
                    if (r.isPermitted(rContext)) continue;
                    return false;
                }
                return true;
            }).forEach(spreadPos -> {
                if (level.getBlockState(spreadPos).isAir() && this.placeGel(level, gel, (BlockPos)spreadPos)) {
                    newlyPlaced.add((BlockPos)spreadPos);
                }
            });
        }
        this.modifiedPositions = newlyPlaced;
        if (this.modifiedPositions.isEmpty()) {
            this.placeGel(level, gel, pos);
        }
    }

    private boolean placeGel(ServerLevel level, Block gel, BlockPos pos) {
        return StructureGelBlock.placeGel(level, gel, pos);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GelSpreaderBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            blockEntity.tick((ServerLevel)level, pos, state);
        }
    }
}

