/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client;

import com.legacy.structure_gel.core.util.Internal;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Internal
public class ClientUtil {
    public static final Map<ResourceKey<? extends Registry<?>>, List<ResourceKey<?>>> REGISTRY_KEYS = new HashMap();
    public static Map<ResourceKey<TrimMaterial>, Integer> materialLight = new HashMap<ResourceKey<TrimMaterial>, Integer>();

    public static int getMaterialBrightness(ArmorTrim trim) {
        Optional key = trim.material().unwrapKey();
        if (key.isPresent()) {
            return materialLight.getOrDefault(key.get(), -1);
        }
        return -1;
    }

    public static BlockHitResult rayTrace(Level level, Player player) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        float pi = (float)Math.PI;
        float radian = pi / 180.0f;
        float pitch = player.getXRot() * radian;
        float yaw = player.getYRot() * radian;
        float cosYaw = Mth.cos((float)(-yaw - pi));
        float sinYaw = Mth.sin((float)(-yaw - pi));
        float cosPitch = -Mth.cos((float)(-pitch));
        float sinPitch = Mth.sin((float)(-pitch));
        double playerReach = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
        Vec3 endPos = eyePos.add((double)(sinYaw * cosPitch) * playerReach, (double)sinPitch * playerReach, (double)(cosYaw * cosPitch) * playerReach);
        return level.clip(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
    }

    public static void renderName(Component displayName, BlockGetter level, BlockPos pos, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (mc.getEntityRenderDispatcher().distanceToSqr((Entity)mc.player) <= 4096.0) {
            poseStack.pushPose();
            Vec3 offset = null;
            Direction offsetDir = null;
            for (Direction dir : Direction.orderedByNearest((Entity)Minecraft.getInstance().player)) {
                BlockPos normal = new BlockPos(dir.getOpposite().getUnitVec3i());
                if (!level.getBlockState(pos.offset((Vec3i)normal)).isAir()) continue;
                offset = Vec3.atCenterOf((Vec3i)normal);
                offsetDir = dir;
                break;
            }
            if (offset == null || level.getBlockState(pos.above()).isAir() && offsetDir.getAxis().isHorizontal()) {
                offset = BlockPos.ZERO.above().getCenter();
            }
            poseStack.translate(offset.x(), offset.y(), offset.z());
            poseStack.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
            poseStack.scale(-0.025f, -0.025f, 0.025f);
            Matrix4f lastMatrix = poseStack.last().pose();
            Font fontRenderer = mc.font;
            float backgroundOpacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int alpha = (int)(backgroundOpacity * 255.0f) << 24;
            float centerString = -fontRenderer.width((FormattedText)displayName) / 2;
            fontRenderer.drawInBatch(displayName, centerString, 0.0f, 0x20FFFFFF, false, lastMatrix, buffer, Font.DisplayMode.SEE_THROUGH, alpha, packedLight);
            fontRenderer.drawInBatch(displayName, centerString, 0.0f, -1, false, lastMatrix, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.popPose();
        }
    }
}

