/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers;

import com.legacy.structure_gel.api.util.Positions;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.client.SGRenderType;
import com.legacy.structure_gel.core.client.renderers.BuildingToolRenderers;
import com.legacy.structure_gel.core.client.renderers.IRenderBase;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.SmartBoundingBox;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class BuildingToolRenderer
implements IRenderBase {
    protected static final Map<BuildingToolMode, Supplier<BuildingToolRenderer>> RENDERERS = new HashMap<BuildingToolMode, Supplier<BuildingToolRenderer>>();
    @Nullable
    protected static BuildingToolMode currentMode = null;
    @Nullable
    private static BuildingToolRenderer instance = null;
    private static boolean shouldClear = false;
    @Nullable
    protected BlockPos pos;
    @Nullable
    protected BlockPos hitPos;
    @Nullable
    protected Direction hitFace;
    @Nullable
    protected Vec3 hitVec;
    protected boolean hitBlock = false;
    private final VertexBuffer lineBuffer = new VertexBuffer(BufferUsage.STATIC_WRITE);
    protected boolean needsCompiled = true;
    private boolean lineBufferEmpty = true;
    protected Vec3i renderPos = Vec3i.ZERO;
    private final Tesselator tesselator = new Tesselator();
    @Nullable
    private CompletableFuture<RenderResult> futureRender = null;
    private RenderInfo lastRenderInfo = new RenderInfo();

    protected BuildingToolRenderer() {
    }

    private static void updateRenderedMode(@Nullable ItemStack stack) {
        BuildingToolMode newMode;
        BuildingToolMode buildingToolMode = newMode = stack != null && stack.is((Item)SGRegistry.Items.BUILDING_TOOL.get()) ? BuildingToolItem.getMode(stack) : null;
        if (currentMode != newMode || instance == null) {
            currentMode = newMode;
            if (instance != null) {
                instance.close();
            }
            instance = currentMode == null ? null : RENDERERS.getOrDefault(currentMode, () -> null).get();
        }
    }

    public static void render(Minecraft mc, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
        LocalPlayer player;
        if (shouldClear) {
            shouldClear = false;
            if (instance != null) {
                instance.close();
            }
            instance = null;
        }
        if ((player = mc.player) != null && player.isCreative()) {
            Pair<InteractionHand, ItemStack> tool = BuildingToolItem.getBuildingTool((Player)player);
            if (tool == null) {
                BuildingToolRenderer.updateRenderedMode(null);
                return;
            }
            ItemStack toolStack = (ItemStack)tool.getSecond();
            BuildingToolRenderer.updateRenderedMode(toolStack);
            if (instance != null && !toolStack.isEmpty()) {
                instance.updateData(mc, toolStack);
                Vec3i camPos = Positions.vec3i(camX, camY, camZ);
                if (instance.shouldRender(camPos)) {
                    if (BuildingToolRenderer.instance.needsCompiled && BuildingToolRenderer.instance.compile((Minecraft)mc, (LocalPlayer)player, (ItemStack)toolStack, (double)camX, (double)camY, (double)camZ).isFinished) {
                        BuildingToolRenderer.instance.needsCompiled = false;
                    }
                    instance.render(mc, player, toolStack, modelViewMatrix, projectionMatrix, camX, camY, camZ);
                }
            }
        }
    }

    protected RenderInfo compile(Minecraft mc, LocalPlayer player, ItemStack stack, double camX, double camY, double camZ) {
        if (SGConfig.CLIENT.threadBuildingTool()) {
            if (this.futureRender == null) {
                this.lastRenderInfo.isFinished = false;
                this.futureRender = CompletableFuture.supplyAsync(() -> {
                    PoseStack poseStack = new PoseStack();
                    BufferBuilder buffBuilder = this.tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
                    RenderInfo renderInfo = new RenderInfo();
                    this.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
                    MeshData mesh = buffBuilder.build();
                    return new RenderResult(renderInfo, mesh);
                }, (Executor)Util.backgroundExecutor());
            }
            if (this.futureRender != null && this.futureRender.isDone()) {
                try {
                    this.lineBuffer.bind();
                    RenderResult result = this.futureRender.get();
                    result.renderInfo().isFinished = true;
                    MeshData mesh = result.mesh;
                    if (mesh != null) {
                        this.lineBuffer.upload(mesh);
                        this.lineBufferEmpty = false;
                    } else {
                        this.lineBufferEmpty = true;
                    }
                    this.futureRender = null;
                    VertexBuffer.unbind();
                    this.renderPos = result.renderInfo().renderPos;
                    this.lastRenderInfo = result.renderInfo();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            this.lineBuffer.bind();
            PoseStack poseStack = new PoseStack();
            BufferBuilder buffBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            RenderInfo renderInfo = new RenderInfo();
            this.compileInfo(mc, stack, poseStack, buffBuilder, camX, camY, camZ, renderInfo);
            MeshData mesh = buffBuilder.build();
            if (mesh != null) {
                this.lineBuffer.upload(mesh);
                this.lineBufferEmpty = false;
            } else {
                this.lineBufferEmpty = true;
            }
            VertexBuffer.unbind();
            this.renderPos = renderInfo.renderPos;
            renderInfo.isFinished = true;
            this.lastRenderInfo = renderInfo;
        }
        return this.lastRenderInfo;
    }

    protected void render(Minecraft mc, LocalPlayer player, ItemStack stack, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
        if (!this.lineBufferEmpty) {
            this.drawWithRenderType(SGRenderType.worldWireframe(true), this.lineBuffer, modelViewMatrix, projectionMatrix, (float)this.renderPos.getX() - (float)camX, (float)this.renderPos.getY() - (float)camY, (float)this.renderPos.getZ() - (float)camZ);
        }
    }

    protected void drawWithRenderType(RenderType renderType, VertexBuffer buffer, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float xOffset, float yOffset, float zOffset) {
        renderType.setupRenderState();
        CompiledShaderProgram shader = RenderSystem.getShader();
        if (shader != null) {
            if (shader.MODEL_OFFSET != null) {
                shader.MODEL_OFFSET.set(xOffset, yOffset, zOffset);
            }
            buffer.bind();
            buffer.drawWithShader(modelViewMatrix, projectionMatrix, shader);
            if (shader.MODEL_OFFSET != null) {
                shader.MODEL_OFFSET.set(0.0f, 0.0f, 0.0f);
            }
            VertexBuffer.unbind();
        }
        renderType.clearRenderState();
    }

    protected static Collection<BlockPos> mapPosesTo(Collection<BlockPos> poses, Vec3i renderPos) {
        ArrayList<BlockPos> newPoses = new ArrayList<BlockPos>(poses.size());
        int x = renderPos.getX();
        int y = renderPos.getY();
        int z = renderPos.getZ();
        for (BlockPos pos : poses) {
            newPoses.add(pos.offset(-x, -y, -z));
        }
        return newPoses;
    }

    protected boolean shouldRender(Vec3i camPos) {
        return true;
    }

    protected void updateData(Minecraft mc, ItemStack stack) {
        Vec3 hVec;
        boolean hBlock;
        Direction hDir;
        BlockPos hPos;
        HitResult hitResult = mc.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult bHitResult = (BlockHitResult)hitResult;
            hPos = bHitResult.getBlockPos();
            hDir = bHitResult.getDirection();
            hBlock = bHitResult.getType() == HitResult.Type.BLOCK;
        } else {
            hPos = null;
            hDir = null;
            hBlock = false;
        }
        if (this.hitPos != null && !this.hitPos.equals((Object)hPos) || hPos != null && !hPos.equals((Object)this.hitPos) || this.hitPos == null != (hPos == null) || hDir != this.hitFace || hBlock != this.hitBlock) {
            this.hitPos = hPos;
            this.hitFace = hDir;
            this.hitBlock = hBlock;
            this.needsCompiled = true;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult bHitResult = (BlockHitResult)hitResult;
            hVec = bHitResult.getLocation();
        } else {
            hVec = null;
        }
        if (this.hitVec != null && !this.hitVec.equals((Object)hVec) || hVec != null && !hVec.equals((Object)this.hitVec)) {
            this.hitVec = hVec;
            this.needsCompiled = true;
        }
    }

    protected abstract void compileInfo(Minecraft var1, ItemStack var2, PoseStack var3, BufferBuilder var4, double var5, double var7, double var9, RenderInfo var11);

    protected void close() {
        this.lineBuffer.close();
    }

    public static void needsUpdated() {
        if (instance != null) {
            BuildingToolRenderer.instance.needsCompiled = true;
        }
    }

    public static void clear() {
        shouldClear = true;
    }

    static {
        BuildingToolRenderers.init();
    }

    protected static class RenderInfo {
        boolean isFinished = false;
        Vec3i renderPos = Vec3i.ZERO;
        boolean renderFlagA = true;

        protected RenderInfo() {
        }
    }

    protected record RenderResult(RenderInfo renderInfo, MeshData mesh) {
    }

    protected static abstract class ForCorners
    extends BuildingToolRenderer {
        protected boolean selectionChanged = false;
        protected boolean itemChanged = false;
        private ItemStack oldStack = ItemStack.EMPTY;
        boolean wasHoldingShift = false;
        @Nullable
        SmartBoundingBox.CornerType oldCorner = null;
        @Nullable
        protected BlockPos secondPos;
        private final VertexBuffer targetBuffer = new VertexBuffer(BufferUsage.STATIC_WRITE);
        private boolean targetBufferEmpty = true;

        protected ForCorners() {
        }

        @Override
        protected boolean shouldRender(Vec3i camPos) {
            return true;
        }

        @Override
        protected void updateData(Minecraft mc, ItemStack stack) {
            super.updateData(mc, stack);
            Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
            Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
            boolean pos0Flag = this.arePosesDifferent(pos0, this.pos);
            boolean pos1Flag = this.arePosesDifferent(pos1, this.secondPos);
            SmartBoundingBox.CornerType corner = BuildingToolItem.getSelectedCorner(stack);
            boolean isHoldingShift = mc.player.isShiftKeyDown();
            this.pos = pos0.orElse(null);
            this.secondPos = pos1.orElse(null);
            if (pos0Flag || pos1Flag || this.wasHoldingShift != isHoldingShift || this.oldCorner != corner) {
                this.needsCompiled = true;
            }
            this.selectionChanged = pos0Flag || pos1Flag || this.oldCorner != corner;
            this.itemChanged = this.oldStack == null != (stack == null) || this.oldStack != null && !ItemStack.matches((ItemStack)this.oldStack, (ItemStack)stack);
            this.wasHoldingShift = isHoldingShift;
            this.oldCorner = corner;
            this.oldStack = stack.copy();
        }

        private boolean arePosesDifferent(Optional<BlockPos> opPos, BlockPos compareTo) {
            return opPos.isPresent() ? !opPos.get().equals((Object)compareTo) : compareTo != null;
        }

        protected abstract float[] getOutlineRGB();

        @Override
        protected void compileInfo(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, RenderInfo renderInfo) {
            boolean hasPosA = this.pos != null;
            boolean hasPosB = this.secondPos != null;
            float selectionPointAlpha = 0.5f;
            Vec3i renderPos = this.renderPos;
            renderInfo.renderFlagA = false;
            if (hasPosA && !hasPosB) {
                renderPos = this.pos;
                IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, BoundingBox.fromCorners((Vec3i)Vec3i.ZERO, (Vec3i)Vec3i.ZERO), 0.75f, 0.0f, 0.0f, selectionPointAlpha);
            }
            if (!hasPosA && hasPosB) {
                renderPos = this.secondPos;
                IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, BoundingBox.fromCorners((Vec3i)Vec3i.ZERO, (Vec3i)Vec3i.ZERO), 0.0f, 0.0f, 0.75f, selectionPointAlpha);
            }
            if (hasPosA && hasPosB) {
                SmartBoundingBox.CornerType selectedCorner = BuildingToolItem.getSelectedCorner(stack);
                float[] rgb = this.getOutlineRGB();
                BoundingBox bb = BoundingBox.fromCorners((Vec3i)this.pos, (Vec3i)this.secondPos);
                renderPos = new Vec3i(bb.minX(), bb.minY(), bb.minZ());
                double pointWidth = 0.53;
                Vec3 pointWidthVec = new Vec3(pointWidth, pointWidth, pointWidth);
                Vec3 posA = Vec3.atCenterOf((Vec3i)this.pos.subtract(renderPos));
                Vec3 posB = Vec3.atCenterOf((Vec3i)this.secondPos.subtract(renderPos));
                double cornerWidth = 0.3;
                Vec3 cornerWidthVec = new Vec3(cornerWidth, cornerWidth, cornerWidth);
                double range = 10.0;
                Vec3 lookVec = mc.player.getLookAngle();
                Vec3 playerPos = mc.player.getEyePosition();
                Vec3 rp = new Vec3((double)renderPos.getX(), (double)renderPos.getY(), (double)renderPos.getZ());
                boolean hasAllCorners = this.hasAllCorners();
                SmartBoundingBox bounds = SmartBoundingBox.fromCorners((Vec3i)Positions.blockPos((Position)posA), (Vec3i)Positions.blockPos((Position)posB));
                for (SmartBoundingBox.Corner corner : hasAllCorners ? bounds.allCorners() : bounds.selectionPointCorners()) {
                    Vec3i cornerPos = corner.getPoint();
                    Vec3 c = new Vec3((double)cornerPos.getX(), (double)cornerPos.getY(), (double)cornerPos.getZ());
                    AABB aabb = new AABB(c.subtract(cornerWidthVec).add(rp), c.add(cornerWidthVec).add(rp));
                    if (selectedCorner != corner.type && !aabb.clip(playerPos, playerPos.add(lookVec.multiply(range, range, range))).isPresent()) continue;
                    IRenderBase.makeBox(poseStack, (VertexConsumer)buffBuilder, c.subtract(cornerWidthVec), c.add(cornerWidthVec), 0.0f, 0.7f, 0.3f, 0.5f);
                    renderInfo.renderFlagA = true;
                    break;
                }
                if (hasAllCorners) {
                    IRenderBase.makeBox(poseStack, (VertexConsumer)buffBuilder, posA.subtract(pointWidthVec), posA.add(pointWidthVec), 0.75f, 0.0f, 0.0f, selectionPointAlpha);
                    IRenderBase.makeBox(poseStack, (VertexConsumer)buffBuilder, posB.subtract(pointWidthVec), posB.add(pointWidthVec), 0.0f, 0.0f, 0.75f, selectionPointAlpha);
                } else {
                    IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, BlockPos.containing((Position)posA), 0.75f, 0.0f, 0.0f, selectionPointAlpha);
                    IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, BlockPos.containing((Position)posB), 0.0f, 0.0f, 0.75f, selectionPointAlpha);
                }
                if (hasAllCorners) {
                    IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, BoundingBox.fromCorners((Vec3i)Vec3i.ZERO, (Vec3i)bb.getLength()), rgb[0], rgb[1], rgb[2], 0.3f);
                    if (selectedCorner != null) {
                        double boxWidth = 0.508;
                        Vec3 boxWidthVec = new Vec3(boxWidth, boxWidth, boxWidth);
                        IRenderBase.makeBox(poseStack, (VertexConsumer)buffBuilder, Vec3.atCenterOf((Vec3i)Vec3i.ZERO).subtract(boxWidthVec), Vec3.atCenterOf((Vec3i)bb.getLength()).add(boxWidthVec), rgb[0], rgb[1], rgb[2], 0.1f);
                    }
                }
            }
            renderInfo.renderPos = renderPos;
        }

        protected boolean hasAllCorners() {
            BuildingToolMode.ForCorners cornerMode;
            BuildingToolMode buildingToolMode = currentMode;
            return buildingToolMode instanceof BuildingToolMode.ForCorners && (cornerMode = (BuildingToolMode.ForCorners)buildingToolMode).hasAllCorners();
        }

        protected void compileTarget(Minecraft mc, ItemStack stack, PoseStack poseStack, BufferBuilder buffBuilder, double camX, double camY, double camZ, RenderInfo renderInfo) {
            if (currentMode == BuildingToolModes.CLONE && this.pos != null && this.secondPos != null) {
                return;
            }
            if (renderInfo.renderFlagA) {
                return;
            }
            if (this.hitPos != null) {
                boolean posA = !mc.player.isShiftKeyDown();
                float[] color = new float[]{posA ? 0.75f : 0.0f, 0.0f, posA ? 0.0f : 0.75f};
                float selectionPointAlpha = 0.3f;
                if (mc.level.getBlockState(this.hitPos).isAir()) {
                    double min = 0.15;
                    double max = 0.85;
                    IRenderBase.makeBox(poseStack, (VertexConsumer)buffBuilder, new Vec3(min, min, min), new Vec3(max, max, max), color[0], color[1], color[2], selectionPointAlpha);
                } else {
                    double min = 0.01;
                    double max = 0.99;
                    IRenderBase.makeLineBox(poseStack, (VertexConsumer)buffBuilder, min, min, min, max, max, max, color[0], color[1], color[2], selectionPointAlpha);
                }
            }
        }

        @Override
        protected RenderInfo compile(Minecraft mc, LocalPlayer player, ItemStack stack, double camX, double camY, double camZ) {
            RenderInfo ret = super.compile(mc, player, stack, camX, camY, camZ);
            this.targetBuffer.bind();
            PoseStack poseStack = new PoseStack();
            BufferBuilder buffBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            this.compileTarget(mc, stack, poseStack, buffBuilder, camX, camY, camZ, ret);
            MeshData mesh = buffBuilder.build();
            if (mesh != null) {
                this.targetBuffer.upload(mesh);
                this.targetBufferEmpty = false;
            } else {
                this.targetBufferEmpty = true;
            }
            VertexBuffer.unbind();
            return ret;
        }

        @Override
        protected void render(Minecraft mc, LocalPlayer player, ItemStack stack, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
            BlockPos camPos = mc.gameRenderer.getMainCamera().getBlockPosition();
            int dist = 300;
            if (this.pos != null && this.pos.closerThan((Vec3i)camPos, (double)dist) || this.secondPos != null && this.secondPos.closerThan((Vec3i)camPos, (double)dist)) {
                super.render(mc, player, stack, modelViewMatrix, projectionMatrix, camX, camY, camZ);
            }
            if (!this.targetBufferEmpty && this.hitPos != null) {
                this.drawWithRenderType(SGRenderType.worldWireframe(true), this.targetBuffer, modelViewMatrix, projectionMatrix, (float)this.hitPos.getX() - (float)camX, (float)this.hitPos.getY() - (float)camY, (float)this.hitPos.getZ() - (float)camZ);
            }
        }

        @Override
        protected void close() {
            super.close();
            this.targetBuffer.close();
        }
    }
}

