/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public interface IRenderBase {
    public static final byte DOWN = (byte)(1 << Direction.DOWN.get3DDataValue());
    public static final byte UP = (byte)(1 << Direction.UP.get3DDataValue());
    public static final byte NORTH = (byte)(1 << Direction.NORTH.get3DDataValue());
    public static final byte SOUTH = (byte)(1 << Direction.SOUTH.get3DDataValue());
    public static final byte WEST = (byte)(1 << Direction.WEST.get3DDataValue());
    public static final byte EAST = (byte)(1 << Direction.EAST.get3DDataValue());
    public static final byte ALL = (byte)(DOWN + UP + NORTH + SOUTH + WEST + EAST);
    public static final byte[] DIRECTION_FLAGS = new byte[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    public static final Vec3 ONE = new Vec3(1.0, 1.0, 1.0);

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BlockPos pos, float r, float g, float b, float a) {
        IRenderBase.makeLineBox(poseStack, vertexCon, BoundingBox.fromCorners((Vec3i)pos, (Vec3i)pos), 0.0, r, g, b, a);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BoundingBox bounds, float r, float g, float b) {
        IRenderBase.makeLineBox(poseStack, vertexCon, bounds, 0.0, r, g, b);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BoundingBox bounds, float r, float g, float b, float a) {
        IRenderBase.makeLineBox(poseStack, vertexCon, bounds, 0.0, r, g, b, a);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BoundingBox bounds, double expand, float r, float g, float b) {
        IRenderBase.makeLineBox(poseStack, vertexCon, bounds, expand, r, g, b, 1.0f);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BoundingBox bounds, double expand, float r, float g, float b, float a) {
        IRenderBase.makeLineBox(poseStack, vertexCon, (double)bounds.minX() - expand, (double)bounds.minY() - expand, (double)bounds.minZ() - expand, (double)(bounds.maxX() + 1) + expand, (double)(bounds.maxY() + 1) + expand, (double)(bounds.maxZ() + 1) + expand, r, g, b, a);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, double nX, double nY, double nZ, double xX, double xY, double xZ, float r, float g, float b, float a) {
        new LineBoxBuilder(new Vec3(nX, nY, nZ), new Vec3(xX, xY, xZ)).rgba(r, g, b, a).build(poseStack, vertexCon);
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, AABB bounds, float r, float g, float b, float a) {
        IRenderBase.makeBox(poseStack, vertexCon, bounds.minX, bounds.minY, bounds.minZ, bounds.maxX, bounds.maxY, bounds.maxZ, r, g, b, a);
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, Vec3 pos, float r, float g, float b, float a) {
        IRenderBase.makeBox(poseStack, vertexCon, pos, pos.add(ONE), r, g, b, a);
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, Vec3 from, Vec3 to, float r, float g, float b, float a) {
        IRenderBase.makeBox(poseStack, vertexCon, from.x(), from.y(), from.z(), to.x(), to.y(), to.z(), r, g, b, a);
    }

    private static int comparePoses(Vec3 renderPos, Vec3 camPos, BlockPos p1, BlockPos p2) {
        return Double.compare(renderPos.add(Vec3.atCenterOf((Vec3i)p2)).distanceToSqr(camPos), renderPos.add(Vec3.atCenterOf((Vec3i)p1)).distanceToSqr(camPos));
    }

    public static void highlightVoxelShapes(PoseStack poseStack, VertexConsumer vertexCon, Vec3i renderPos, Map<BlockPos, VoxelShape> shapes, float r, float g, float b, float a) {
        IRenderBase.highlightVoxelShapes(poseStack, vertexCon, Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), renderPos, shapes, r, g, b, a);
    }

    public static void highlightVoxelShapes(PoseStack poseStack, VertexConsumer vertexCon, Vec3 camPos, Vec3i renderPos, Map<BlockPos, VoxelShape> shapes, float r, float g, float b, float a) {
        Vec3 renderVec = Vec3.atCenterOf((Vec3i)renderPos);
        shapes.entrySet().stream().sorted((e1, e2) -> IRenderBase.comparePoses(renderVec, camPos, (BlockPos)e1.getKey(), (BlockPos)e2.getKey())).forEach(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            VoxelShape shape = (VoxelShape)entry.getValue();
            Direction[] dirs = Direction.values();
            boolean isBlockShape = shape == Shapes.block();
            shape.forAllBoxes((sx, sy, sz, smx, smy, smz) -> {
                byte culled = 0;
                if (isBlockShape) {
                    for (Direction d : dirs) {
                        BlockPos relative = pos.relative(d);
                        if (shapes.get(relative) != Shapes.block()) continue;
                        culled = (byte)(culled + DIRECTION_FLAGS[d.get3DDataValue()]);
                    }
                }
                if (culled < ALL) {
                    double extend = 0.005;
                    int x = pos.getX();
                    int y = pos.getY();
                    int z = pos.getZ();
                    IRenderBase.makeBox(poseStack, vertexCon, (double)x + sx - ((culled & WEST) != 0 ? 0.0 : extend), (double)y + sy - ((culled & DOWN) != 0 ? 0.0 : extend), (double)z + sz - ((culled & NORTH) != 0 ? 0.0 : extend), (double)x + smx + ((culled & EAST) != 0 ? 0.0 : extend), (double)y + smy + ((culled & UP) != 0 ? 0.0 : extend), (double)z + smz + ((culled & SOUTH) != 0 ? 0.0 : extend), r, g, b, a, culled);
                }
            });
        });
    }

    public static void highlightBlocks(PoseStack poseStack, VertexConsumer vertexCon, Vec3i renderPos, Collection<BlockPos> poses, float r, float g, float b, float a) {
        ArrayList<Pair> toRender = new ArrayList<Pair>();
        Direction[] dirs = Direction.values();
        for (BlockPos pos : poses) {
            byte culled = 0;
            for (Direction d : dirs) {
                if (!poses.contains(pos.relative(d))) continue;
                culled = (byte)(culled + DIRECTION_FLAGS[d.get3DDataValue()]);
            }
            if (culled >= ALL) continue;
            toRender.add(Pair.of((Object)pos, (Object)culled));
        }
        Vec3 renderVec = Vec3.atCenterOf((Vec3i)renderPos);
        Vec3 camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        toRender.sort((p1, p2) -> IRenderBase.comparePoses(renderVec, camPos, (BlockPos)p1.getFirst(), (BlockPos)p2.getFirst()));
        int size = toRender.size();
        for (int i = 0; i < size; ++i) {
            Pair pair = (Pair)toRender.get(i);
            BlockPos pos = (BlockPos)pair.getFirst();
            byte culled = (Byte)pair.getSecond();
            double extend = 0.005;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            IRenderBase.makeBox(poseStack, vertexCon, (double)x - ((culled & WEST) != 0 ? 0.0 : extend), (double)y - ((culled & DOWN) != 0 ? 0.0 : extend), (double)z - ((culled & NORTH) != 0 ? 0.0 : extend), (double)(x + 1) + ((culled & EAST) != 0 ? 0.0 : extend), (double)(y + 1) + ((culled & UP) != 0 ? 0.0 : extend), (double)(z + 1) + ((culled & SOUTH) != 0 ? 0.0 : extend), r, g, b, a, culled);
        }
    }

    public static void highlightBlockPos(PoseStack poseStack, VertexConsumer vertexCon, Vec3i renderPos, Collection<BlockPos> poses, float r, float g, float b, float a) {
        double inner = 0.25;
        double outer = 1.0 - inner;
        Vec3 renderVec = Vec3.atCenterOf((Vec3i)renderPos);
        Vec3 camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        ArrayList<BlockPos> sorted = new ArrayList<BlockPos>(poses);
        sorted.sort((p1, p2) -> IRenderBase.comparePoses(renderVec, camPos, p1, p2));
        int size = sorted.size();
        for (int i = 0; i < size; ++i) {
            BlockPos pos = (BlockPos)sorted.get(i);
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            IRenderBase.makeBox(poseStack, vertexCon, (double)x + inner, (double)y + inner, (double)z + inner, (double)x + outer, (double)y + outer, (double)z + outer, r, g, b, a);
        }
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a, byte culled) {
        IRenderBase.makeBox(poseStack, vertexCon, (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, r, g, b, a, culled);
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a) {
        IRenderBase.makeBox(poseStack, vertexCon, (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, r, g, b, a, (byte)0);
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, float mnX, float mnY, float mnZ, float mxX, float mxY, float mxZ, float r, float g, float b, float a, byte culled) {
        Matrix4f matrix4f = poseStack.last().pose();
        float ew = 0.7f;
        float ns = 0.9f;
        float down = 0.5f;
        float dR = r * down;
        float dG = g * down;
        float dB = b * down;
        float ewR = r * ew;
        float ewG = g * ew;
        float ewB = b * ew;
        float nsR = r * ns;
        float nsG = g * ns;
        float nsB = b * ns;
        if ((culled & WEST) == 0) {
            vertexCon.addVertex(matrix4f, mnX, mnY, mnZ).setColor(ewR, ewG, ewB, a);
            vertexCon.addVertex(matrix4f, mnX, mnY, mxZ).setColor(ewR, ewG, ewB, a);
            vertexCon.addVertex(matrix4f, mnX, mxY, mxZ).setColor(ewR, ewG, ewB, a);
            vertexCon.addVertex(matrix4f, mnX, mxY, mnZ).setColor(ewR, ewG, ewB, a);
        }
        if ((culled & SOUTH) == 0) {
            vertexCon.addVertex(matrix4f, mnX, mnY, mxZ).setColor(nsR, nsG, nsB, a);
            vertexCon.addVertex(matrix4f, mxX, mnY, mxZ).setColor(nsR, nsG, nsB, a);
            vertexCon.addVertex(matrix4f, mxX, mxY, mxZ).setColor(nsR, nsG, nsB, a);
            vertexCon.addVertex(matrix4f, mnX, mxY, mxZ).setColor(nsR, nsG, nsB, a);
        }
        if ((culled & EAST) == 0) {
            vertexCon.addVertex(matrix4f, mxX, mnY, mxZ).setColor(ewR, ewG, ewB, a);
            vertexCon.addVertex(matrix4f, mxX, mnY, mnZ).setColor(ewR, ewG, ewB, a);
            vertexCon.addVertex(matrix4f, mxX, mxY, mnZ).setColor(ewR, ewG, ewB, a);
            vertexCon.addVertex(matrix4f, mxX, mxY, mxZ).setColor(ewR, ewG, ewB, a);
        }
        if ((culled & NORTH) == 0) {
            vertexCon.addVertex(matrix4f, mxX, mnY, mnZ).setColor(nsR, nsG, nsB, a);
            vertexCon.addVertex(matrix4f, mnX, mnY, mnZ).setColor(nsR, nsG, nsB, a);
            vertexCon.addVertex(matrix4f, mnX, mxY, mnZ).setColor(nsR, nsG, nsB, a);
            vertexCon.addVertex(matrix4f, mxX, mxY, mnZ).setColor(nsR, nsG, nsB, a);
        }
        if ((culled & DOWN) == 0) {
            vertexCon.addVertex(matrix4f, mnX, mnY, mnZ).setColor(dR, dG, dB, a);
            vertexCon.addVertex(matrix4f, mxX, mnY, mnZ).setColor(dR, dG, dB, a);
            vertexCon.addVertex(matrix4f, mxX, mnY, mxZ).setColor(dR, dG, dB, a);
            vertexCon.addVertex(matrix4f, mnX, mnY, mxZ).setColor(dR, dG, dB, a);
        }
        if ((culled & UP) == 0) {
            vertexCon.addVertex(matrix4f, mnX, mxY, mnZ).setColor(r, g, b, a);
            vertexCon.addVertex(matrix4f, mnX, mxY, mxZ).setColor(r, g, b, a);
            vertexCon.addVertex(matrix4f, mxX, mxY, mxZ).setColor(r, g, b, a);
            vertexCon.addVertex(matrix4f, mxX, mxY, mnZ).setColor(r, g, b, a);
        }
    }

    public static class LineBoxBuilder {
        final Vec3 negativeCorner;
        final Vec3 positiveCorner;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        double width = 0.04;

        public LineBoxBuilder(Vec3 negativeCorner, Vec3 positiveCorner) {
            this.negativeCorner = negativeCorner;
            this.positiveCorner = positiveCorner;
        }

        public LineBoxBuilder(BlockPos pos) {
            this(BoundingBox.fromCorners((Vec3i)pos, (Vec3i)pos));
        }

        public LineBoxBuilder(BoundingBox bounds) {
            this(new Vec3((double)bounds.minX(), (double)bounds.minY(), (double)bounds.minZ()), new Vec3((double)(bounds.maxX() + 1), (double)(bounds.maxY() + 1), (double)(bounds.maxZ() + 1)));
        }

        public LineBoxBuilder rgb(float r, float g, float b) {
            return this.rgba(r, g, b, this.a);
        }

        public LineBoxBuilder rgba(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public LineBoxBuilder lineWidth(double width) {
            this.width = width;
            return this;
        }

        public void build(PoseStack poseStack, VertexConsumer vertexCon) {
            byte topCulls = (byte)(UP + DOWN);
            byte sideCulls = (byte)(WEST + EAST);
            double nX = this.negativeCorner.x;
            double nY = this.negativeCorner.y;
            double nZ = this.negativeCorner.z;
            double xX = this.positiveCorner.x;
            double xY = this.positiveCorner.y;
            double xZ = this.positiveCorner.z;
            IRenderBase.makeBox(poseStack, vertexCon, nX - this.width, nY + this.width, nZ - this.width, nX + this.width, xY - this.width, nZ + this.width, this.r, this.g, this.b, this.a, topCulls);
            IRenderBase.makeBox(poseStack, vertexCon, nX - this.width, nY + this.width, xZ - this.width, nX + this.width, xY - this.width, xZ + this.width, this.r, this.g, this.b, this.a, topCulls);
            IRenderBase.makeBox(poseStack, vertexCon, xX - this.width, nY + this.width, nZ - this.width, xX + this.width, xY - this.width, nZ + this.width, this.r, this.g, this.b, this.a, topCulls);
            IRenderBase.makeBox(poseStack, vertexCon, xX - this.width, nY + this.width, xZ - this.width, xX + this.width, xY - this.width, xZ + this.width, this.r, this.g, this.b, this.a, topCulls);
            IRenderBase.makeBox(poseStack, vertexCon, nX + this.width, xY - this.width, nZ - this.width, xX - this.width, xY + this.width, nZ + this.width, this.r, this.g, this.b, this.a, sideCulls);
            IRenderBase.makeBox(poseStack, vertexCon, nX + this.width, xY - this.width, xZ - this.width, xX - this.width, xY + this.width, xZ + this.width, this.r, this.g, this.b, this.a, sideCulls);
            IRenderBase.makeBox(poseStack, vertexCon, nX - this.width, xY - this.width, nZ - this.width, nX + this.width, xY + this.width, xZ + this.width, this.r, this.g, this.b, this.a);
            IRenderBase.makeBox(poseStack, vertexCon, xX - this.width, xY - this.width, nZ - this.width, xX + this.width, xY + this.width, xZ + this.width, this.r, this.g, this.b, this.a);
            IRenderBase.makeBox(poseStack, vertexCon, nX + this.width, nY - this.width, nZ - this.width, xX - this.width, nY + this.width, nZ + this.width, this.r, this.g, this.b, this.a, sideCulls);
            IRenderBase.makeBox(poseStack, vertexCon, nX + this.width, nY - this.width, xZ - this.width, xX - this.width, nY + this.width, xZ + this.width, this.r, this.g, this.b, this.a, sideCulls);
            IRenderBase.makeBox(poseStack, vertexCon, nX - this.width, nY - this.width, nZ - this.width, nX + this.width, nY + this.width, xZ + this.width, this.r, this.g, this.b, this.a);
            IRenderBase.makeBox(poseStack, vertexCon, xX - this.width, nY - this.width, nZ - this.width, xX + this.width, nY + this.width, xZ + this.width, this.r, this.g, this.b, this.a);
        }
    }
}

