/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen.building_tool;

import com.legacy.structure_gel.api.client.gui.LayeredScreen;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.client.SGSprites;
import com.legacy.structure_gel.core.client.renderers.BuildingToolRenderer;
import com.legacy.structure_gel.core.client.screen.building_tool.EditPaletteScreen;
import com.legacy.structure_gel.core.client.screen.building_tool.EditSelectionScreen;
import com.legacy.structure_gel.core.client.widget.MultiWidget;
import com.legacy.structure_gel.core.client.widget.OnTooltip;
import com.legacy.structure_gel.core.client.widget.PanelSelectionButton;
import com.legacy.structure_gel.core.client.widget.PropertyEditBox;
import com.legacy.structure_gel.core.client.widget.PropertyImageButton;
import com.legacy.structure_gel.core.client.widget.TexturedEditBox;
import com.legacy.structure_gel.core.client.widget.TooltipSpriteButton;
import com.legacy.structure_gel.core.data_components.BlockPalette;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.legacy.structure_gel.core.network.bi_directional.UpdateBuildingToolPacket;
import com.legacy.structure_gel.core.network.c_to_s.ActionHistoryPacket;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BuildingToolScreen
extends LayeredScreen {
    protected static final Component GO_BACK_TEXT = Component.translatable((String)"info.structure_gel.building_tool.go_back");
    protected static final String GO_BACK_DESC = "info.structure_gel.building_tool.go_back.description";
    public static final String UNDO_KEY = "info.structure_gel.building_tool.undo";
    protected static final Component UNDO_TEXT = Component.translatable((String)"info.structure_gel.building_tool.undo");
    protected static final String UNDO_DESC = "info.structure_gel.building_tool.undo.description";
    public static final String REDO_KEY = "info.structure_gel.building_tool.redo";
    protected static final Component REDO_TEXT = Component.translatable((String)"info.structure_gel.building_tool.redo");
    protected static final String REDO_DESC = "info.structure_gel.building_tool.redo.description";
    public static final String COPY_KEY = "info.structure_gel.building_tool.copy";
    public static final String PASTE_KEY = "info.structure_gel.building_tool.paste";
    public static final String DELETE_KEY = "info.structure_gel.building_tool.delete";
    protected static final Component SELECT_POS_1_TEXT = Component.translatable((String)"info.structure_gel.building_tool.select_pos_1");
    protected static final String SELECT_POS_1_DESC = "info.structure_gel.building_tool.select_pos_1.description";
    protected static final Component SELECT_POS_2_TEXT = Component.translatable((String)"info.structure_gel.building_tool.select_pos_2");
    protected static final String SELECT_POS_2_DESC = "info.structure_gel.building_tool.select_pos_2.description";
    protected static final Component EDIT_SELECTION_TEXT = Component.translatable((String)"info.structure_gel.building_tool.edit_selection");
    protected static final String EDIT_SELECTION_DESC = "info.structure_gel.building_tool.edit_selection.description";
    protected static final Component BLOCK_PALETTE_TEXT = Component.translatable((String)"info.structure_gel.building_tool.block_palette");
    protected static final String BLOCK_PALETTE_DESC = "info.structure_gel.building_tool.block_palette.description";
    public static final int TEXT_COLOR = 0xCDCDCD;
    public static final int HOVERED_TEXT_COLOR = 0xFFFFFF;
    public static final int PROPERTIES_START_Y = 80;
    public static final int PROPERTIES_SPACING_Y = 30;
    private final List<RadialSlice> radialSlices = (List)Util.make(new ArrayList(8), list -> {
        float d = 22.5f;
        int i = 45;
        list.add(new RadialSlice(360.0f - d, d, SGSprites.RADIAL_CARDINAL, BuildingToolModes.EXTEND));
        list.add(new RadialSlice(d, d += (float)i, SGSprites.RADIAL_DIAGONAL, BuildingToolModes.FLOOD));
        list.add(new RadialSlice(d, d += (float)i, SGSprites.RADIAL_CARDINAL, BuildingToolModes.FILL));
        list.add(new RadialSlice(d, d += (float)i, SGSprites.RADIAL_DIAGONAL, BuildingToolModes.LINE));
        list.add(new RadialSlice(d, d += (float)i, SGSprites.RADIAL_CARDINAL, BuildingToolModes.CLONE));
        list.add(new RadialSlice(d, d += (float)i, SGSprites.RADIAL_DIAGONAL, BuildingToolModes.MOVE));
        list.add(new RadialSlice(d, d += (float)i, SGSprites.RADIAL_CARDINAL, BuildingToolModes.REPLACE));
        list.add(new RadialSlice(d, d += (float)i, SGSprites.RADIAL_DIAGONAL, BuildingToolModes.SHAPE));
    });
    protected final ItemStack stack;
    protected final InteractionHand hand;
    protected BuildingToolMode mode = BuildingToolModes.NONE;
    protected final Map<ToolModeProperty<?>, Object> properties = new HashMap();
    protected Optional<BlockPos> selectedPosA = Optional.empty();
    protected Optional<BlockPos> selectedPosB = Optional.empty();
    protected boolean usedEditSelectionScreen = false;
    protected boolean clearPoses = false;
    private Optional<WeightedRandomList<WeightedEntry.Wrapper<BlockState>>> palette = Optional.empty();
    protected Optional<ItemStack> selectedStateRender = Optional.empty();
    protected int hoveredRadial = -1;
    protected int selectedRadial = -1;
    protected int tick = 0;
    protected final List<Renderable> widgetsToRender = new ArrayList<Renderable>(2);
    protected final MultiWidget propertiesWidget = new MultiWidget();
    protected PropertyEditBox<Integer> reachDistanceWidget;
    protected PropertyImageButton<ToolModeProperty.BooleanProperty> blockUpdateWidget;
    public static int lastScreenState = 0;
    private Optional<DescriptionRenderer> descriptionRenderer = Optional.empty();
    private int itemStackRenderIndex = 0;

    public BuildingToolScreen(ItemStack stack, InteractionHand hand) {
        super((Component)Component.empty());
        this.stack = stack;
        this.hand = hand;
        this.mode = BuildingToolItem.getMode(stack);
        this.setupProperties(this.mode);
        for (int i = 0; i < this.radialSlices.size(); ++i) {
            if (this.radialSlices.get((int)i).mode != this.mode) continue;
            this.selectedRadial = i;
            break;
        }
        this.selectedPosA = BuildingToolItem.getPos(stack, 0);
        this.selectedPosB = BuildingToolItem.getPos(stack, 1);
    }

    protected void init() {
        if (this.palette.isEmpty()) {
            this.palette = Optional.of(BuildingToolItem.getPalette(this.stack, (LevelReader)this.minecraft.level).blocks());
        }
        this.widgetsToRender.clear();
        int undoH = 16;
        int undoW = 25;
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(centerX - 187, centerY - 100, undoW, undoH, SGSprites.UNDO_BUTTON, button -> SGPacketHandler.sendToServer(ActionHistoryPacket.undo(false)), UNDO_TEXT).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, UNDO_TEXT, UNDO_DESC, ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).getDefaultInstance().getHoverName(), SGText.keybindString((KeyMapping)ClientProxy.UNDO_KEY.get())))));
        this.widgetsToRender.add((Renderable)this.addWidget(new TooltipSpriteButton(centerX - 158, centerY - 100, undoW, undoH, SGSprites.REDO_BUTTON, button -> SGPacketHandler.sendToServer(ActionHistoryPacket.redo(false)), REDO_TEXT).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)button, REDO_TEXT, REDO_DESC, ((BuildingToolItem)((Object)((Object)SGRegistry.Items.BUILDING_TOOL.get()))).getDefaultInstance().getHoverName(), SGText.keybindString((KeyMapping)ClientProxy.REDO_KEY.get())))));
        this.addWidget(this.propertiesWidget);
        this.setupPropertiesWidgets(this.mode);
        int leftPropY = 80;
        ToolModeProperty.NumberProp<Integer> reachProp = ToolModeProperty.REACH_DISTANCE;
        String oldReach = this.reachDistanceWidget == null ? Integer.toString(BuildingToolItem.getReachDistanceModifier(this.stack)) : this.reachDistanceWidget.getValue();
        this.reachDistanceWidget = this.addWidget(new PropertyEditBox<Integer>(this.minecraft.font, centerX + 110, centerY - leftPropY, reachProp, BuildingToolItem.getReachDistanceModifier(this.stack)));
        this.reachDistanceWidget.setValue((Integer)((Object)oldReach));
        this.reachDistanceWidget.onTooltip((box, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)box, reachProp.getNameComponent(), List.of(Pair.of((Object)"info.structure_gel.building_tool.property_range", (Object)new Object[]{((Integer)reachProp.min()).toString(), ((Integer)reachProp.max()).toString()}), Pair.of((Object)reachProp.getDescKey(), (Object)new Object[0]))));
        ToolModeProperty.SelectionProp<ToolModeProperty.BooleanProperty> blockUpdateProp = ToolModeProperty.CAUSE_BLOCK_UPDATES;
        ToolModeProperty.BooleanProperty oldBlockUpdate = this.blockUpdateWidget == null ? ToolModeProperty.BooleanProperty.from(BuildingToolItem.causesBlockUpdates(this.stack)) : this.blockUpdateWidget.getSelectedValue();
        this.blockUpdateWidget = this.addWidget(new PropertyImageButton<ToolModeProperty.BooleanProperty>(centerX + 110, centerY - (leftPropY -= 30), SGSprites.BUILDING_TOOL_BUTTON, b -> {}, blockUpdateProp.getNameComponent(), blockUpdateProp, oldBlockUpdate));
        this.blockUpdateWidget.onTooltip((box, poseStack, mouseX, mouseY) -> this.renderDescription((GuiEventListener)box, blockUpdateProp.getNameComponent(), List.of(Pair.of((Object)blockUpdateProp.getDescKey(), (Object)new Object[0]))));
        leftPropY -= 30;
        this.updateRenderStack();
    }

    private void setupProperties(BuildingToolMode mode) {
        this.properties.clear();
        if (BuildingToolItem.getMode(this.stack).equals(this.mode)) {
            for (ToolModeProperty<?> property : mode.getProperties().values()) {
                this.properties.put(property, BuildingToolItem.getProperty(this.stack, property));
            }
        } else {
            for (ToolModeProperty<?> property : mode.getProperties().values()) {
                this.properties.put(property, property.getDefaultValue());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setupPropertiesWidgets(BuildingToolMode mode) {
        centerX = this.width / 2;
        centerY = this.height / 2;
        this.propertiesWidget.clear();
        if (mode instanceof BuildingToolMode.ForCorners) {
            setPosW = 20;
            buttonSpread = setPosW + 8;
            this.propertiesWidget.addListener(new TooltipSpriteButton(centerX + 150 - buttonSpread, centerY - 104, setPosW, setPosW, SGSprites.SET_POS_0, (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$setupPropertiesWidgets$8(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((BuildingToolScreen)this), BuildingToolScreen.SELECT_POS_1_TEXT).onTooltip((OnTooltip<TooltipSpriteButton>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Lnet/minecraft/client/gui/GuiGraphics;II)V, lambda$setupPropertiesWidgets$9(com.legacy.structure_gel.core.client.widget.TooltipSpriteButton net.minecraft.client.gui.GuiGraphics int int ), (Lcom/legacy/structure_gel/core/client/widget/TooltipSpriteButton;Lnet/minecraft/client/gui/GuiGraphics;II)V)((BuildingToolScreen)this)));
            this.propertiesWidget.addListener(new TooltipSpriteButton(centerX + 150, centerY - 104, setPosW, setPosW, SGSprites.SET_POS_1, (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$setupPropertiesWidgets$10(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((BuildingToolScreen)this), BuildingToolScreen.SELECT_POS_2_TEXT).onTooltip((OnTooltip<TooltipSpriteButton>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Lnet/minecraft/client/gui/GuiGraphics;II)V, lambda$setupPropertiesWidgets$11(com.legacy.structure_gel.core.client.widget.TooltipSpriteButton net.minecraft.client.gui.GuiGraphics int int ), (Lcom/legacy/structure_gel/core/client/widget/TooltipSpriteButton;Lnet/minecraft/client/gui/GuiGraphics;II)V)((BuildingToolScreen)this)));
            editButton = new TooltipSpriteButton(centerX + 150 + buttonSpread, centerY - 104, setPosW, setPosW, SGSprites.EDIT_SELECTION, (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$setupPropertiesWidgets$12(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((BuildingToolScreen)this), BuildingToolScreen.EDIT_SELECTION_TEXT).onTooltip((OnTooltip<TooltipSpriteButton>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Lnet/minecraft/client/gui/GuiGraphics;II)V, lambda$setupPropertiesWidgets$13(com.legacy.structure_gel.core.client.widget.TooltipSpriteButton net.minecraft.client.gui.GuiGraphics int int ), (Lcom/legacy/structure_gel/core/client/widget/TooltipSpriteButton;Lnet/minecraft/client/gui/GuiGraphics;II)V)((BuildingToolScreen)this));
            this.propertiesWidget.addListener(editButton);
        }
        y = 80;
        for (Map.Entry<String, ToolModeProperty<?>> entry : mode.getProperties().entrySet()) {
            prop = entry.getValue();
            currentVal = this.properties.get(prop);
            if (!(prop instanceof ToolModeProperty.SelectionProp)) ** GOTO lbl-1000
            selectionProp = (ToolModeProperty.SelectionProp)prop;
            if (currentVal instanceof StringRepresentable) {
                if (currentVal instanceof ToolModeProperty.IPanelSelection) {
                    panelProp = (ToolModeProperty.IPanelSelection)currentVal;
                    panelButton = new PanelSelectionButton<ToolModeProperty.IPanelSelection>(centerX - 210, centerY - y, SGSprites.BUILDING_TOOL_BUTTON, (PropertyImageButton.OnPress<PropertyImageButton<T>>)LambdaMetafactory.metafactory(null, null, null, (Lcom/legacy/structure_gel/core/client/widget/PropertyImageButton;)V, lambda$setupPropertiesWidgets$14(com.legacy.structure_gel.core.client.widget.PropertyImageButton ), (Lcom/legacy/structure_gel/core/client/widget/PropertyImageButton;)V)((BuildingToolScreen)this), prop.getNameComponent(), selectionProp, panelProp);
                    panelButton.onTooltip((OnTooltip<TooltipSpriteButton>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Lnet/minecraft/client/gui/GuiGraphics;II)V, lambda$setupPropertiesWidgets$15(com.legacy.structure_gel.core.item.building_tool.ToolModeProperty com.legacy.structure_gel.core.client.widget.TooltipSpriteButton net.minecraft.client.gui.GuiGraphics int int ), (Lcom/legacy/structure_gel/core/client/widget/TooltipSpriteButton;Lnet/minecraft/client/gui/GuiGraphics;II)V)((BuildingToolScreen)this, prop));
                    this.propertiesWidget.addListener(panelButton);
                    this.propertiesWidget.addListener(1, panelButton.getPanel());
                } else {
                    this.propertiesWidget.addListener(new PropertyImageButton<StringRepresentable>(centerX - 210, centerY - y, SGSprites.BUILDING_TOOL_BUTTON, (PropertyImageButton.OnPress<PropertyImageButton<T>>)LambdaMetafactory.metafactory(null, null, null, (Lcom/legacy/structure_gel/core/client/widget/PropertyImageButton;)V, lambda$setupPropertiesWidgets$16(com.legacy.structure_gel.core.client.widget.PropertyImageButton ), (Lcom/legacy/structure_gel/core/client/widget/PropertyImageButton;)V)((BuildingToolScreen)this), prop.getNameComponent(), selectionProp, (StringRepresentable)currentVal).onTooltip((OnTooltip<TooltipSpriteButton>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Lnet/minecraft/client/gui/GuiGraphics;II)V, lambda$setupPropertiesWidgets$17(com.legacy.structure_gel.core.item.building_tool.ToolModeProperty com.legacy.structure_gel.core.client.widget.TooltipSpriteButton net.minecraft.client.gui.GuiGraphics int int ), (Lcom/legacy/structure_gel/core/client/widget/TooltipSpriteButton;Lnet/minecraft/client/gui/GuiGraphics;II)V)((BuildingToolScreen)this, prop)));
                }
            } else lbl-1000:
            // 2 sources

            {
                editBox = new PropertyEditBox<Object>(this.minecraft.font, centerX - 210, centerY - y, prop, currentVal);
                editBox.setResponder((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$setupPropertiesWidgets$18(com.legacy.structure_gel.core.item.building_tool.ToolModeProperty java.lang.String ), (Ljava/lang/String;)V)((BuildingToolScreen)this, prop));
                editBox.onTooltip((OnTooltip<TexturedEditBox>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Lnet/minecraft/client/gui/GuiGraphics;II)V, lambda$setupPropertiesWidgets$19(com.legacy.structure_gel.core.item.building_tool.ToolModeProperty com.legacy.structure_gel.core.client.widget.TexturedEditBox net.minecraft.client.gui.GuiGraphics int int ), (Lcom/legacy/structure_gel/core/client/widget/TexturedEditBox;Lnet/minecraft/client/gui/GuiGraphics;II)V)((BuildingToolScreen)this, prop));
                this.propertiesWidget.addListener(editBox);
            }
            y -= 30;
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = graphics.pose();
        if (lastScreenState == 1) {
            this.minecraft.setScreen((Screen)new EditSelectionScreen(this));
            return;
        }
        float mixedTick = (float)this.tick + this.minecraft.getDeltaTracker().getGameTimeDeltaPartialTick(true);
        float animationTime = 2.5f;
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        double xCoord = mouseX - this.width / 2;
        double yCoord = this.height - mouseY - this.height / 2;
        double theta = Math.atan2(xCoord, yCoord) * 57.29577951308232;
        if (theta < 0.0) {
            theta = 360.0 + theta;
        }
        double dist = Math.sqrt(xCoord * xCoord + yCoord * yCoord);
        if (mixedTick < animationTime) {
            float scale = mixedTick / animationTime;
            float invscale = 1.0f - scale;
            poseStack.pushPose();
            poseStack.translate((float)(this.width / 2) * invscale, (float)(this.height / 2) * invscale, 0.0f);
            poseStack.scale(scale, scale, scale);
        }
        this.hoveredRadial = -1;
        for (int i = this.radialSlices.size() - 1; i > -1; --i) {
            boolean wrapAround;
            RadialSlice slice = this.radialSlices.get(i);
            boolean isCardinal = i % 2 == 0;
            boolean hovered = false;
            float minDegree = slice.minDegree;
            float maxDegree = slice.maxDegree;
            boolean bl = wrapAround = minDegree > maxDegree;
            if ((wrapAround ? (theta > 180.0 ? theta > (double)minDegree : theta > (double)(minDegree - 360.0f)) && (theta > 180.0 ? theta < (double)(maxDegree + 360.0f) : theta < (double)maxDegree) : theta > (double)minDegree && theta < (double)maxDegree) && dist > 30.0 && dist < 110.0) {
                hovered = true;
                this.hoveredRadial = i;
            }
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate((float)centerX, (float)centerY, 0.0f);
            float animTime = 7.0f;
            float scale = Mth.clamp((float)(mixedTick / animTime), (float)0.0f, (float)1.0f);
            scale = (float)(Math.sin((double)scale * 2.355) * 1.4);
            pose.mulPose(Axis.ZP.rotationDegrees((float)(45 * i + (!isCardinal ? -45 : 0))));
            float innerPercent = isCardinal ? 0.8f : 0.6f;
            float scaledPercent = 1.0f - innerPercent;
            Vec3 sliceMove = isCardinal ? new Vec3(0.0, -60.0, 0.0) : new Vec3(50.0, -50.0, 0.0);
            pose.translate(sliceMove.multiply((double)innerPercent, (double)innerPercent, (double)innerPercent).add(sliceMove.multiply((double)scaledPercent, (double)scaledPercent, (double)scaledPercent).multiply((double)scale, (double)scale, (double)scale)));
            int size = isCardinal ? 80 : 100;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blitSprite(RenderType::guiTextured, slice.sprite.get(this.selectedRadial != i, hovered), -size / 2, -size / 2, size, size);
            pose.popPose();
            pose.pushPose();
            pose.translate((float)centerX, (float)centerY, 0.0f);
            float rot = 45 * i;
            pose.mulPose(Axis.ZP.rotationDegrees(rot));
            innerPercent = isCardinal ? 0.5f : 0.3f;
            scaledPercent = 1.0f - innerPercent;
            Vec3 iconMove = new Vec3(0.0, -68.0, 0.0);
            pose.translate(iconMove.multiply((double)innerPercent, (double)innerPercent, (double)innerPercent).add(iconMove.multiply((double)scaledPercent, (double)scaledPercent, (double)scaledPercent).multiply((double)scale, (double)scale, (double)scale)));
            pose.mulPose(Axis.ZP.rotationDegrees(-rot));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hoveredRadial != i && this.selectedRadial != i) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            }
            graphics.blit(RenderType::guiTextured, slice.mode.getIconTexture(), -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
            pose.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (dist < 21.0) {
            this.hoveredRadial = -2;
        }
        graphics.blitSprite(RenderType::guiTextured, SGSprites.RADIAL_CENTER.get(true, dist < 21.0 && this.mode.hasBlockPalette()), centerX - 20, centerY - 20, 40, 40);
        this.widgetsToRender.forEach(widget -> {
            widget.render(graphics, mouseX, mouseY, partialTick);
            RenderSystem.enableBlend();
        });
        this.propertiesWidget.render(graphics, mouseX, mouseY, partialTick);
        this.reachDistanceWidget.render(graphics, mouseX, mouseY, partialTick);
        RenderSystem.enableBlend();
        this.blockUpdateWidget.render(graphics, mouseX, mouseY, partialTick);
        if (this.hoveredRadial >= 0) {
            BuildingToolMode mode = this.radialSlices.get((int)this.hoveredRadial).mode;
            this.renderDescription(mouseX, mode.getComponent(), mode.getDescKey(), mode.getDescArgs());
        } else if (this.hoveredRadial == -2 && this.mode.hasBlockPalette()) {
            this.renderDescription(mouseX, BLOCK_PALETTE_TEXT, BLOCK_PALETTE_DESC, SGText.keybindString(this.minecraft.options.keyPickItem), BuildingToolItem.getPaletteString(this.getPalette()));
        }
        if (this.selectedStateRender.isPresent() && this.mode.hasBlockPalette()) {
            graphics.renderItem(this.selectedStateRender.get(), centerX - 8, centerY - 8);
        }
        if (this.descriptionRenderer.isPresent()) {
            this.descriptionRenderer.get().render(graphics);
            this.descriptionRenderer = Optional.empty();
        }
        if (mixedTick < animationTime) {
            poseStack.popPose();
        }
    }

    private void renderDescription(GuiEventListener widget, Component title, String descriptionKey, Object ... descriptionArgs) {
        this.renderDescription(widget, title, List.of(Pair.of((Object)descriptionKey, (Object)descriptionArgs)));
    }

    private void renderDescription(GuiEventListener widget, Component title, List<Pair<String, Object[]>> descriptionKeys) {
        this.renderDescription(widget.getRectangle().position().x(), title, descriptionKeys);
    }

    private void renderDescription(int x, Component title, String descriptionKey, Object ... descriptionArgs) {
        this.renderDescription(x, title, List.of(Pair.of((Object)descriptionKey, (Object)descriptionArgs)));
    }

    private void renderDescription(int x, Component title, List<Pair<String, Object[]>> descriptionKeys) {
        this.descriptionRenderer = Optional.of(new DescriptionRenderer(this, x, title, descriptionKeys));
    }

    public void updateRenderStack() {
        Optional<Object> stack = Optional.empty();
        List statesList = this.getPalette().unwrap();
        if (statesList.isEmpty()) {
            stack = Optional.of(Items.BUCKET.getDefaultInstance());
        } else {
            int i = this.itemStackRenderIndex % statesList.size();
            stack = Optional.of(BuildingToolItem.getItemForBlock((BlockState)((WeightedEntry.Wrapper)statesList.get(i)).data(), (LevelReader)this.minecraft.level));
        }
        this.selectedStateRender = stack;
        ++this.itemStackRenderIndex;
    }

    public void tick() {
        if (this.tick % 20 == 0) {
            this.updateRenderStack();
        }
        ++this.tick;
    }

    public Optional<ItemStack> getItemForBlock(String val) {
        try {
            return Optional.of(BuildingToolItem.getItemForBlock(BlockStateParser.parseForBlock((HolderLookup)this.minecraft.level.holderLookup(Registries.BLOCK), (String)val, (boolean)false).blockState(), (LevelReader)this.minecraft.level));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickType) {
        if (Screen.hasControlDown() && ((KeyMapping)ClientProxy.UNDO_KEY.get()).getKey().getValue() == clickType) {
            SGPacketHandler.sendToServer(ActionHistoryPacket.undo(true));
            return true;
        }
        if (Screen.hasControlDown() && ((KeyMapping)ClientProxy.REDO_KEY.get()).getKey().getValue() == clickType) {
            SGPacketHandler.sendToServer(ActionHistoryPacket.redo(true));
            return true;
        }
        if (((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get()).getKey().getValue() == clickType) {
            this.close();
            return true;
        }
        if (this.hoveredRadial == -2 && this.mode.hasBlockPalette()) {
            if (clickType == 0) {
                BuildingToolScreen.playClickSound();
                this.minecraft.setScreen((Screen)new EditPaletteScreen(this));
                return true;
            }
            if (clickType == 2) {
                BuildingToolScreen.playClickSound();
                this.setPalette((WeightedRandomList<WeightedEntry.Wrapper<BlockState>>)WeightedRandomList.create());
                this.updateRenderStack();
                return true;
            }
        } else if (this.hoveredRadial > -1) {
            this.setMode(this.hoveredRadial);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickType);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean pressedEnter;
        InputConstants.Key key = InputConstants.Type.KEYSYM.getOrCreate(keyCode);
        boolean bl = pressedEnter = keyCode == 257 || keyCode == 335;
        if (((KeyMapping)ClientProxy.UNDO_KEY.get()).isActiveAndMatches(key)) {
            SGPacketHandler.sendToServer(ActionHistoryPacket.undo(true));
            return true;
        }
        if (((KeyMapping)ClientProxy.REDO_KEY.get()).isActiveAndMatches(key)) {
            SGPacketHandler.sendToServer(ActionHistoryPacket.redo(true));
            return true;
        }
        if (this.minecraft.options.keyDrop.isActiveAndMatches(key)) {
            BuildingToolScreen.playClickSound();
            this.minecraft.setScreen((Screen)new EditSelectionScreen(this));
        }
        if (this.minecraft.options.keyInventory.isActiveAndMatches(key) || ((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get()).isActiveAndMatches(key) || pressedEnter) {
            this.close();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void setMode(int radial) {
        BuildingToolMode newMode = this.radialSlices.get((int)radial).mode;
        BuildingToolScreen.playClickSound();
        if (this.mode != newMode) {
            this.mode = newMode;
            this.selectedRadial = radial;
            this.setupProperties(this.mode);
            this.setupPropertiesWidgets(this.mode);
        } else {
            this.close();
        }
    }

    public void close() {
        this.minecraft.setScreen(null);
        this.onClose();
    }

    @Override
    public void onClose() {
        BuildingToolRenderer.needsUpdated();
        Minecraft mc = this.minecraft;
        LocalPlayer player = mc.player;
        ItemStack stack = this.stack;
        if (stack.is((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            BuildingToolItem.setMode(stack, this.mode);
            for (Map.Entry<ToolModeProperty<?>, Object> entry : this.properties.entrySet()) {
                ToolModeProperty<?> prop = entry.getKey();
                BuildingToolItem.setProperty(stack, prop, entry.getValue());
            }
            BuildingToolMode buildingToolMode = this.mode;
            if (buildingToolMode instanceof BuildingToolMode.ForCorners) {
                BuildingToolMode.ForCorners cornerMode = (BuildingToolMode.ForCorners)buildingToolMode;
                if (this.selectedPosA.isPresent()) {
                    cornerMode.setPositionA((Player)player, this.selectedPosA.get(), stack, !this.usedEditSelectionScreen);
                }
                if (this.selectedPosB.isPresent()) {
                    cornerMode.setPositionB((Player)player, this.selectedPosB.get(), stack, !this.usedEditSelectionScreen);
                }
            }
            if (this.clearPoses) {
                this.mode.clearPoses(stack, (Player)player);
            }
            BlockPalette palette = BlockPalette.of(this.getPalette());
            BuildingToolItem.setPalette(stack, palette);
            player.swing(this.hand);
            int n = (Integer)ToolModeProperty.REACH_DISTANCE.read(this.reachDistanceWidget.getValue());
            BuildingToolItem.setReachDistanceModifier(stack, n);
            boolean causeBlockUpdates = this.blockUpdateWidget.getSelectedValue().value();
            BuildingToolItem.setCausesBlockUpdates(stack, causeBlockUpdates);
            this.mode.onSelect(stack, (Level)mc.level, (Player)player);
            SGPacketHandler.sendToServer(UpdateBuildingToolPacket.builder().hand(this.hand).mode(this.mode).properties(this.properties).posA(this.selectedPosA).posB(this.selectedPosB).clearPoses(this.clearPoses).palette(palette).reachDistance(n).causeBlockUpdates(causeBlockUpdates).build());
        }
        lastScreenState = 0;
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static void playClickSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public WeightedRandomList<WeightedEntry.Wrapper<BlockState>> getPalette() {
        return this.palette.orElse((WeightedRandomList<WeightedEntry.Wrapper<BlockState>>)WeightedRandomList.create());
    }

    public void setPalette(@Nullable WeightedRandomList<WeightedEntry.Wrapper<BlockState>> palette) {
        this.palette = Optional.ofNullable(palette);
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$19(ToolModeProperty prop, TexturedEditBox box, GuiGraphics poseStack, int mouseX, int mouseY) {
        if (prop instanceof ToolModeProperty.NumberProp) {
            ToolModeProperty.NumberProp numProp = (ToolModeProperty.NumberProp)prop;
            this.renderDescription((GuiEventListener)box, prop.getNameComponent(), List.of(Pair.of((Object)"info.structure_gel.building_tool.property_range", (Object)new Object[]{numProp.min().toString(), numProp.max().toString()}), Pair.of((Object)prop.getDescKey(), (Object)new Object[0])));
        } else {
            this.renderDescription((GuiEventListener)box, prop.getNameComponent(), prop.getDescKey(), new Object[0]);
        }
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$18(ToolModeProperty prop, String s) {
        this.properties.put(prop, prop.read(s));
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$17(ToolModeProperty prop, TooltipSpriteButton button, GuiGraphics poseStack, int mouseX, int mouseY) {
        this.renderDescription((GuiEventListener)button, prop.getNameComponent(), prop.getDescKey(), new Object[0]);
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$16(PropertyImageButton button) {
        this.properties.put(button.getProperty(), button.getSelectedValue());
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$15(ToolModeProperty prop, TooltipSpriteButton button, GuiGraphics poseStack, int mouseX, int mouseY) {
        this.renderDescription((GuiEventListener)button, prop.getNameComponent(), prop.getDescKey(), new Object[0]);
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$14(PropertyImageButton button) {
        this.properties.put(button.getProperty(), button.getSelectedValue());
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$13(TooltipSpriteButton button, GuiGraphics poseStack, int mouseX, int mouseY) {
        this.renderDescription((GuiEventListener)button, EDIT_SELECTION_TEXT, EDIT_SELECTION_DESC, SGText.keybindString(this.minecraft.options.keyDrop));
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$12(Button button) {
        this.minecraft.setScreen((Screen)new EditSelectionScreen(this));
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$11(TooltipSpriteButton button, GuiGraphics poseStack, int mouseX, int mouseY) {
        this.renderDescription((GuiEventListener)button, SELECT_POS_2_TEXT, SELECT_POS_2_DESC, new Object[0]);
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$10(Button button) {
        this.selectedPosB = Optional.ofNullable(this.minecraft.player.blockPosition());
        this.usedEditSelectionScreen = false;
        this.close();
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$9(TooltipSpriteButton button, GuiGraphics poseStack, int mouseX, int mouseY) {
        this.renderDescription((GuiEventListener)button, SELECT_POS_1_TEXT, SELECT_POS_1_DESC, new Object[0]);
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$8(Button button) {
        this.selectedPosA = Optional.ofNullable(this.minecraft.player.blockPosition());
        this.usedEditSelectionScreen = false;
        this.close();
    }

    private record RadialSlice(float minDegree, float maxDegree, WidgetSprites sprite, BuildingToolMode mode) {
    }

    public static class DescriptionRenderer {
        private final Screen screen;
        private final Component title;
        private final int x;
        private final List<Pair<String, Object[]>> descriptionKeys;

        public DescriptionRenderer(Screen screen, int x, Component title, List<Pair<String, Object[]>> descriptionKeys) {
            this.screen = screen;
            this.x = x;
            this.title = title;
            this.descriptionKeys = descriptionKeys;
        }

        void render(GuiGraphics graphics) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            int centerX = this.screen.width / 2;
            int centerY = this.screen.height / 2;
            boolean renderRight = this.x - centerX < 110;
            LinkedList<FormattedCharSequence> lines = new LinkedList<FormattedCharSequence>();
            lines.add(this.title.getVisualOrderText());
            int remainingWidth = Math.max(0, this.screen.width / 2 - 100 - 15);
            for (Pair<String, Object[]> desc : this.descriptionKeys) {
                Object[] args = (Object[])desc.getSecond();
                lines.addAll(Minecraft.getInstance().font.split((FormattedText)SGText.applyKeybindFilter((Component)Component.translatable((String)((String)desc.getFirst()), (Object[])args)), remainingWidth));
            }
            graphics.renderTooltip(Minecraft.getInstance().font, lines, renderRight ? centerX + 100 : 0, centerY - 74);
            poseStack.popPose();
        }
    }
}

