/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.core.client.widget.PropertyImageButton;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public class PanelSelectionButton<T extends ToolModeProperty.IPanelSelection>
extends PropertyImageButton<T> {
    private final Panel panel;

    public PanelSelectionButton(int x, int y, WidgetSprites sprites, PropertyImageButton.OnPress<PropertyImageButton<T>> onPress, Component name, ToolModeProperty.SelectionProp<T> property, T currentVal) {
        this(x, y, 100, 24, sprites, onPress, name, property, currentVal);
    }

    public PanelSelectionButton(int x, int y, int width, int height, WidgetSprites sprites, PropertyImageButton.OnPress<PropertyImageButton<T>> onPress, Component name, ToolModeProperty.SelectionProp<T> property, T currentVal) {
        super(x, y, width, height, sprites, onPress, name, property, currentVal);
        this.panel = new Panel(x + 10, y + 25, (Component)Component.literal((String)"selection_panel"), property.getAllValues(), (ToolModeProperty.IPanelSelection)currentVal);
    }

    public Panel getPanel() {
        return this.panel;
    }

    private void setValue(int index) {
        List vals = this.property.getAllValues();
        index = Mth.clamp((int)index, (int)0, (int)(vals.size() - 1));
        this.currentValue = (StringRepresentable)vals.get(index);
        this.onPress.onPress((Button)this);
    }

    @Override
    public boolean isHoveredOrFocused() {
        return super.isHoveredOrFocused() || this.panel.visible;
    }

    @Override
    public void onPress() {
        this.panel.visible = !this.panel.visible;
    }

    public class Panel
    extends AbstractWidget {
        static final int BUTTON_SIZE = 20;
        static final int BUTTON_PADDING = 1;
        static final int BUTTON_COLUMNS = 4;
        final List<T> values;
        final WidgetSprites[] textures;
        final ResourceLocation backgroundTexture;
        final int backgroundWidth;
        final int backgroundHeight;

        public Panel(int x, int y, Component name, List<T> values, ToolModeProperty.IPanelSelection panelSelectionProp) {
            super(x, y, 20, 20, name);
            this.values = values;
            this.textures = new WidgetSprites[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                ResourceLocation enabled = panelSelectionProp.getSpriteFolder().withSuffix("/" + ((ToolModeProperty.IPanelSelection)values.get(i)).getSerializedName());
                ResourceLocation highlighted = panelSelectionProp.getSpriteFolder().withSuffix("/" + ((ToolModeProperty.IPanelSelection)values.get(i)).getSerializedName() + "_highlighted");
                this.textures[i] = new WidgetSprites(enabled, enabled, highlighted, highlighted);
            }
            this.backgroundTexture = panelSelectionProp.getSpriteFolder().withSuffix("/background");
            int s = 20;
            this.width = 4 * s;
            this.height = (Math.max(1, values.size() / 4) + (values.size() % 4 > 0 ? 1 : 0)) * s;
            this.backgroundWidth = 4 * ++s;
            this.backgroundHeight = (Math.max(1, values.size() / 4) + (values.size() % 4 > 0 ? 1 : 0)) * s;
            this.visible = false;
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 10.0f);
            int texWidth = 21;
            graphics.blitSprite(RenderType::guiTextured, this.backgroundTexture, this.getX() - 5, this.getY() - 5, this.backgroundWidth + 9, this.backgroundHeight + 9);
            for (int i = 0; i < this.values.size(); ++i) {
                int x = this.getX() + i % 4 * texWidth;
                int y = this.getY() + i / 4 * texWidth;
                boolean isHovered = mouseX >= x && mouseX <= x + 20 && mouseY >= y && mouseY <= y + 20;
                graphics.blitSprite(RenderType::guiTextured, this.textures[i].get(true, isHovered), x, y, 20, 20);
                if (!isHovered) continue;
                graphics.renderTooltip(Minecraft.getInstance().font, PanelSelectionButton.this.property.getValueComponent((ToolModeProperty.IPanelSelection)this.values.get(i)), mouseX, mouseY);
            }
            poseStack.popPose();
        }

        protected void updateWidgetNarration(NarrationElementOutput narration) {
        }

        public void onClick(double mouseX, double mouseY) {
            int texWidth = 21;
            int column = ((int)mouseX - this.getX()) / texWidth;
            int row = ((int)mouseY - this.getY()) / texWidth;
            int index = row * 4 + column;
            PanelSelectionButton.this.setValue(index);
            this.visible = false;
        }
    }
}

