/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class DebugCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"debug").requires(source -> source.hasPermission(2));
        LiteralArgumentBuilder updateStructuresToStructure = Commands.literal((String)"update_structures_to_structure");
        updateStructuresToStructure.then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> DebugCommand.updateStructuresToStructure((CommandContext<CommandSourceStack>)context, BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"to"))))));
        updateStructuresToStructure.then(((LiteralArgumentBuilder)Commands.literal((String)"search").executes(context -> DebugCommand.updateStructuresToStructure((CommandContext<CommandSourceStack>)context, 32))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)128)).executes(context -> DebugCommand.updateStructuresToStructure((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, (LiteralArgumentBuilder<CommandSourceStack>)updateStructuresToStructure, Component.empty().append((Component)Component.literal((String)"Updates save mode structure blocks by replacing ")).append((Component)Component.literal((String)":structures/").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" to ")).append((Component)Component.literal((String)":structure/").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" for Minecraft 1.21+ file location changes")));
        command.then((ArgumentBuilder)updateStructuresToStructure);
        return command;
    }

    private static int updateStructuresToStructure(CommandContext<CommandSourceStack> context, BoundingBox area) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        return DebugCommand.updateStructuresToStructure(context, StructureGelCommand.findStructureBlocks(level, area));
    }

    private static int updateStructuresToStructure(CommandContext<CommandSourceStack> context, int radius) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition());
        return DebugCommand.updateStructuresToStructure(context, StructureGelCommand.findStructureBlocks(level, pos, radius));
    }

    private static int updateStructuresToStructure(CommandContext<CommandSourceStack> context, Map<BlockPos, StructureBlockEntity> structureBlocks) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        ArrayList<UpdatedStructureBlock> updated = new ArrayList<UpdatedStructureBlock>();
        LinkedHashMap<BlockPos, String> errored = new LinkedHashMap<BlockPos, String>();
        for (Map.Entry<BlockPos, StructureBlockEntity> entry : structureBlocks.entrySet()) {
            String oldName;
            StructureBlockEntity structureBlock = entry.getValue();
            if (!structureBlock.hasStructureName() || !structureBlock.saveStructure() || !(oldName = structureBlock.getStructureName()).contains(":structures/")) continue;
            String newName = oldName.replaceFirst(":structures/", ":structure/");
            ResourceLocation structureName = ResourceLocation.tryParse((String)newName);
            if (structureName != null) {
                structureBlock.setStructureName(structureName);
                structureBlock.setChanged();
                BlockState state = structureBlock.getBlockState();
                level.sendBlockUpdated(entry.getKey(), state, state, 3);
                updated.add(new UpdatedStructureBlock(oldName, newName));
                continue;
            }
            errored.put(entry.getKey(), oldName);
        }
        if (updated.size() > 0) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("[Updated " + updated.size() + " Structure Blocks]")).withStyle(ChatFormatting.GREEN), true);
            updated.stream().sorted().forEach(structure -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(" - " + String.valueOf(structure))), true));
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No structure blocks were updated."), true);
        }
        if (errored.size() > 0) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Warning: Found " + errored.size() + " structure blocks that could not be updated. Click to teleport.")).withStyle(ChatFormatting.RED), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"[Errored Structure Blocks]").withStyle(ChatFormatting.RED), true);
            errored.forEach((pos, name) -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("%s at (%d, %d, %d)", name, pos.getX(), pos.getY(), pos.getZ())).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.getX() + " " + pos.getY() + " " + pos.getZ()))), true));
        }
        return updated.size();
    }

    private record UpdatedStructureBlock(String oldName, String newName) implements Comparable<UpdatedStructureBlock>
    {
        @Override
        public final String toString() {
            return this.oldName + " -> " + this.newName;
        }

        @Override
        public int compareTo(UpdatedStructureBlock o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

