/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec2;

public class DistanceCommand {
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(o -> Component.translatable((String)"commands.locate.structure.invalid", (Object[])new Object[]{o}));
    private static final DynamicCommandExceptionType ERROR_BIOME_INVALID = new DynamicCommandExceptionType(o -> Component.translatable((String)"commands.locate.biome.invalid", (Object[])new Object[]{o}));

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"distance").requires(source -> source.hasPermission(2));
        command.then(Commands.literal((String)"structure").then(((RequiredArgumentBuilder)Commands.argument((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE)).executes(c -> DistanceCommand.structure((CommandContext<CommandSourceStack>)c, (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)c, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID), 25))).then(Commands.argument((String)"sample_size", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> DistanceCommand.structure((CommandContext<CommandSourceStack>)c, (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)c, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID), (Integer)c.getArgument("sample_size", Integer.class))))));
        command.then(Commands.literal((String)"biome").then(((RequiredArgumentBuilder)Commands.argument((String)"biome", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.BIOME)).executes(c -> DistanceCommand.biome((CommandContext<CommandSourceStack>)c, (ResourceOrTagKeyArgument.Result<Biome>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)c, (String)"biome", (ResourceKey)Registries.BIOME, (DynamicCommandExceptionType)ERROR_BIOME_INVALID), 25))).then(Commands.argument((String)"sample_size", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> DistanceCommand.biome((CommandContext<CommandSourceStack>)c, (ResourceOrTagKeyArgument.Result<Biome>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)c, (String)"biome", (ResourceKey)Registries.BIOME, (DynamicCommandExceptionType)ERROR_BIOME_INVALID), (Integer)c.getArgument("sample_size", Integer.class))))));
        command.then(Commands.literal((String)"vanilla_stats").executes(c -> DistanceCommand.printVanillaStats((CommandContext<CommandSourceStack>)c)));
        return command;
    }

    private static <T> Optional<? extends HolderSet.ListBacked<T>> getHolders(ResourceOrTagKeyArgument.Result<T> result, Registry<T> registry) {
        return (Optional)result.unwrap().map(key -> registry.get(key).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})), tagKey -> registry.get(tagKey));
    }

    private static int structure(CommandContext<CommandSourceStack> context, ResourceOrTagKeyArgument.Result<Structure> result, int sampleSize) throws CommandSyntaxException {
        return DistanceCommand.distance(context, result, sampleSize, Registries.STRUCTURE, ERROR_STRUCTURE_INVALID, (level, pos, holderSet) -> Optional.ofNullable(level.getChunkSource().getGenerator().findNearestMapStructure(level, holderSet, pos, 100, false)));
    }

    private static int biome(CommandContext<CommandSourceStack> context, ResourceOrTagKeyArgument.Result<Biome> result, int sampleSize) throws CommandSyntaxException {
        return DistanceCommand.distance(context, result, sampleSize, Registries.BIOME, ERROR_BIOME_INVALID, (level, pos, holderSet) -> Optional.ofNullable(level.findClosestBiome3d(arg_0 -> ((HolderSet)holderSet).contains(arg_0), pos, 6400, 32, 64)));
    }

    private static <T> int distance(CommandContext<CommandSourceStack> context, ResourceOrTagKeyArgument.Result<T> result, int sampleSize, ResourceKey<Registry<T>> registry, DynamicCommandExceptionType error, Search<T> search) throws CommandSyntaxException {
        ServerPlayer player;
        String searchFor = result.asPrintable();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        int r = (int)((double)level.getServer().getAbsoluteMaxWorldSize() * 0.9);
        int y = (int)source.getPosition().y;
        HolderSet holderSet = (HolderSet)DistanceCommand.getHolders(result, source.registryAccess().lookupOrThrow(registry)).orElseThrow(() -> error.create((Object)searchFor));
        if (holderSet.size() < 1) {
            source.sendFailure((Component)Component.literal((String)(searchFor + " contains no values or does not exist.")));
            return 0;
        }
        RandomSource rand = level.getRandom();
        int totalDistance = 0;
        int maxDistance = 0;
        int actuallyFound = 0;
        ArrayList<Pair> failedSearches = new ArrayList<Pair>();
        source.sendSuccess(() -> Component.literal((String)String.format("Started search for %s with a sample size of %d. This may take a while.", searchFor, sampleSize)), true);
        for (int i = 0; i < sampleSize; ++i) {
            BlockPos searchPos = new BlockPos(rand.nextInt(r * 2) - r, y, rand.nextInt(r * 2) - r);
            Integer loggedIndex = i + 1;
            source.sendSuccess(() -> Component.literal((String)String.format("Search %d/%d at (%d, %d, %d)", loggedIndex, sampleSize, searchPos.getX(), searchPos.getY(), searchPos.getZ())).withStyle(ChatFormatting.GRAY), false);
            Optional<Pair<BlockPos, Holder<T>>> pair = search.search(level, searchPos, holderSet);
            if (pair.isPresent()) {
                ++actuallyFound;
                BlockPos p = (BlockPos)((Pair)pair.get()).getFirst();
                int distance = (int)Math.sqrt(new Vec2((float)searchPos.getX(), (float)searchPos.getZ()).distanceToSqr(new Vec2((float)p.getX(), (float)p.getZ())));
                totalDistance += distance;
                if (distance <= maxDistance) continue;
                maxDistance = distance;
                continue;
            }
            failedSearches.add(Pair.of((Object)(i + 1), (Object)searchPos));
        }
        int averageDist = actuallyFound > 0 ? totalDistance / actuallyFound : 0;
        source.sendSuccess(() -> Component.literal((String)("Results for " + searchFor)).withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.literal((String)"- Average Distance: ").append((Component)Component.literal((String)("" + averageDist)).withStyle(ChatFormatting.GRAY)), false);
        Integer loggedMaxDistance = maxDistance;
        source.sendSuccess(() -> Component.literal((String)"- Max Distance: ").append((Component)Component.literal((String)("" + loggedMaxDistance)).withStyle(ChatFormatting.GRAY)), false);
        Integer loggedActuallyFound = actuallyFound;
        source.sendSuccess(() -> Component.literal((String)"- Found: ").append((Component)Component.literal((String)(loggedActuallyFound + "/" + sampleSize)).withStyle(ChatFormatting.GRAY)), false);
        if (failedSearches.size() > 0) {
            source.sendSuccess(() -> Component.literal((String)"Failed searches").withStyle(ChatFormatting.RED), false);
            for (Pair fail : failedSearches) {
                BlockPos pos = (BlockPos)fail.getSecond();
                source.sendSuccess(() -> Component.literal((String)"- Search: ").append((Component)Component.literal((String)String.valueOf(fail.getFirst())).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)", Pos: ")).append((Component)Component.literal((String)String.format("(%d, %d, %d)", pos.getX(), pos.getY(), pos.getZ())).withStyle(ChatFormatting.GRAY)), false);
            }
        }
        if ((player = source.getPlayer()) != null) {
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_HARP.value(), SoundSource.MASTER, 1.0f, 1.5f);
        }
        return averageDist;
    }

    private static int printVanillaStats(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TreeMap<String, Integer> distances = new TreeMap<String, Integer>();
        distances.put("Village", 720);
        distances.put("Desert Pyramid", 3500);
        distances.put("Jungle Pyramid", 1937);
        distances.put("Ocean Monument", 1302);
        distances.put("Woodland Mansion", 4492);
        distances.put("Pillager Outpost", 1362);
        distances.put("Ancient City", 1521);
        distances.put("End City", 1164);
        distances.put("Nether Fortress", 418);
        distances.put("Bastion Remnant", 416);
        source.sendSuccess(() -> Component.literal((String)"Average distances of vanilla structures (Recorded in 1.19.2)").withStyle(ChatFormatting.GREEN), false);
        for (Map.Entry entry : distances.entrySet()) {
            source.sendSuccess(() -> Component.literal((String)("- " + (String)entry.getKey() + ": ")).append((Component)Component.literal((String)String.valueOf(entry.getValue())).withStyle(ChatFormatting.GRAY)), false);
        }
        return 1;
    }

    @FunctionalInterface
    private static interface Search<T> {
        public Optional<Pair<BlockPos, Holder<T>>> search(ServerLevel var1, BlockPos var2, HolderSet<T> var3);
    }
}

