/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.Structure;

public class GetBiomesCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"getbiomes").requires(source -> source.hasPermission(2));
        command.then(Commands.argument((String)"structure", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.STRUCTURE)).suggests((context, builder) -> StructureGelCommand.suggestFromRegistry((CommandContext<CommandSourceStack>)context, builder, Registries.STRUCTURE)).executes(context -> GetBiomesCommand.getBiomes((CommandContext<CommandSourceStack>)context, StructureGelCommand.getResourceKeyHolder((CommandContext<CommandSourceStack>)context, Registries.STRUCTURE, "structure"))));
        return command;
    }

    private static int getBiomes(CommandContext<CommandSourceStack> context, Holder<Structure> structure) {
        List<String> biomes = ((Structure)structure.value()).biomes().stream().map(Holder::unwrapKey).filter(Optional::isPresent).map(o -> ((ResourceKey)o.get()).location().toString()).sorted().toList();
        Optional op = structure.unwrapKey();
        String name = op.isPresent() ? ((ResourceKey)op.get()).location().toString() : "null";
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (biomes.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)(name + " has no biomes.")), true);
        } else {
            source.sendSuccess(() -> Component.literal((String)("[" + name + "]")).withStyle(ChatFormatting.GREEN), true);
            biomes.forEach(biomeName -> source.sendSuccess(() -> Component.literal((String)(" - " + biomeName)), true));
        }
        return biomes.size();
    }
}

