/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class GetStructuresCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"getstructures").requires(source -> source.hasPermission(2));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"here").executes(c -> GetStructuresCommand.here((CommandContext<CommandSourceStack>)c, BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition())))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> GetStructuresCommand.here((CommandContext<CommandSourceStack>)c, BlockPosArgument.getLoadedBlockPos((CommandContext)c, (String)"pos")))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"biome").executes(c -> GetStructuresCommand.biome((CommandContext<CommandSourceStack>)c))).then(Commands.argument((String)"biome", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.BIOME)).executes(c -> GetStructuresCommand.biome((CommandContext<CommandSourceStack>)c, (ResourceKey<Biome>)((ResourceKey)c.getArgument("biome", ResourceKey.class))))));
        return command;
    }

    private static int here(CommandContext<CommandSourceStack> context, BlockPos pos) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        Registry structureReg = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        List<Pair> structures = level.structureManager().startsForStructure(new ChunkPos(pos), s -> true).stream().map(s -> {
            Structure struc = s.getStructure();
            boolean inBounds = StructureAccessHelper.isInStructure((ServerLevelAccessor)level, struc, pos);
            boolean inPiece = StructureAccessHelper.isInStructurePiece((ServerLevelAccessor)level, struc, pos);
            String name = structureReg.getResourceKey((Object)struc).map(r -> r.location().toString()).orElse("null");
            return Pair.of((Object)name, (Object)(inPiece ? "inside" : (inBounds ? "in bounds" : "not inside")));
        }).sorted((p1, p2) -> ((String)p1.getFirst()).compareTo((String)p2.getFirst())).toList();
        int size = structures.size();
        if (size > 0) {
            source.sendSuccess(() -> Component.literal((String)String.format("Structures at (%d, %d, %d):", pos.getX(), pos.getY(), pos.getZ())).withStyle(ChatFormatting.GREEN), true);
            structures.forEach(p -> source.sendSuccess(() -> Component.literal((String)String.format("- %s (%s)", p.getFirst(), p.getSecond())), true));
            return size;
        }
        source.sendSuccess(() -> Component.literal((String)"There are no structures."), true);
        return 0;
    }

    private static int biome(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Optional opName = source.getLevel().getBiome(BlockPos.containing((Position)source.getPosition())).unwrapKey();
        if (opName.isPresent()) {
            return GetStructuresCommand.biome(context, (ResourceKey<Biome>)((ResourceKey)opName.get()));
        }
        source.sendFailure((Component)Component.literal((String)"The biome you're in doesn't have a registry name."));
        return 0;
    }

    private static int biome(CommandContext<CommandSourceStack> context, ResourceKey<Biome> biomeKey) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        ResourceLocation name = biomeKey.location();
        Optional opBiome = level.registryAccess().lookupOrThrow(Registries.BIOME).get(biomeKey);
        if (opBiome.isPresent()) {
            Holder biome = (Holder)opBiome.get();
            source.sendSuccess(() -> Component.literal((String)("[" + name.toString() + "]")).withStyle(ChatFormatting.GREEN), true);
            ArrayList structures = new ArrayList();
            ChunkGeneratorStructureState chunkGen = level.getChunkSource().getGeneratorState();
            chunkGen.possibleStructureSets().forEach(holder -> {
                StructureSet structureSet = (StructureSet)holder.value();
                for (StructureSet.StructureSelectionEntry entry : structureSet.structures()) {
                    Structure structure = (Structure)entry.structure().value();
                    if (!structure.biomes().contains(biome)) continue;
                    structures.add(structure);
                }
            });
            if (structures.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)(name.toString() + " has no structures.")), true);
            } else {
                Registry registry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
                structures.stream().map(arg_0 -> ((Registry)registry).getKey(arg_0)).map(r -> r == null ? "null" : r.toString()).sorted().forEach(r -> source.sendSuccess(() -> Component.literal((String)(" - " + r)), true));
            }
            return structures.size();
        }
        source.sendFailure((Component)Component.literal((String)"The biome you're in is unregistered."));
        return 0;
    }
}

