/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SaveStructuresCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"savestructures").requires(source -> source.hasPermission(2));
        command.then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> SaveStructuresCommand.saveStructuresBounds((CommandContext<CommandSourceStack>)context, BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)"to"))))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"search").executes(context -> SaveStructuresCommand.saveStructuresSearch((CommandContext<CommandSourceStack>)context, 32))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)128)).executes(context -> SaveStructuresCommand.saveStructuresSearch((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"radius")))));
        return command;
    }

    private static int saveStructuresBounds(CommandContext<CommandSourceStack> context, BoundingBox area) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        return SaveStructuresCommand.save(context, StructureGelCommand.findStructureBlocks(level, area));
    }

    private static int saveStructuresSearch(CommandContext<CommandSourceStack> context, int radius) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition());
        return SaveStructuresCommand.save(context, StructureGelCommand.findStructureBlocks(level, pos, radius));
    }

    private static int save(CommandContext<CommandSourceStack> context, Map<BlockPos, StructureBlockEntity> structureBlocks) {
        ArrayList<String> savedStructures = new ArrayList<String>();
        HashMap<BlockPos, String> duplicates = new HashMap<BlockPos, String>();
        for (Map.Entry<BlockPos, StructureBlockEntity> entry : structureBlocks.entrySet()) {
            StructureBlockEntity structureBlock = entry.getValue();
            if (!structureBlock.hasStructureName() || !structureBlock.saveStructure()) continue;
            if (savedStructures.contains(structureBlock.getStructureName())) {
                duplicates.put(new BlockPos((Vec3i)entry.getKey()), structureBlock.getStructureName());
            }
            savedStructures.add(structureBlock.getStructureName());
        }
        if (savedStructures.size() > 0) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("[Saved " + savedStructures.size() + " Structures]")).withStyle(ChatFormatting.GREEN), true);
            if (savedStructures.size() <= 50) {
                savedStructures.stream().sorted().forEach(structure -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(" - " + structure)), true));
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)" - Too many structures to print. Check the console."), true);
                StructureGelMod.LOGGER.log("Saved structures:", new Object[0]);
                savedStructures.stream().sorted().forEach(x$0 -> StructureGelMod.LOGGER.log(x$0, new Object[0]));
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No structures were saved."), true);
        }
        if (duplicates.size() > 0) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Warning: Found " + duplicates.size() + " structures with a duplicate name. Click to teleport.")).withStyle(ChatFormatting.RED), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"[Duplicate Structures]").withStyle(ChatFormatting.RED), true);
            if (duplicates.size() <= 50) {
                duplicates.forEach((pos, structure) -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.format("%s at (%d, %d, %d)", structure, pos.getX(), pos.getY(), pos.getZ())).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.getX() + " " + pos.getY() + " " + pos.getZ()))), true));
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)" - Too many duplicates to print. Check the console."), true);
                StructureGelMod.LOGGER.log("Duplicate structures:", new Object[0]);
                duplicates.forEach((pos, structure) -> StructureGelMod.LOGGER.log(String.format("%s /tp @s %d %d %d", structure, pos.getX(), pos.getY(), pos.getZ()), new Object[0]));
            }
        }
        return savedStructures.size();
    }
}

